/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.context.airules.metadata;

import com.intellij.ml.llm.context.airules.AiRulesService;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataField;
import com.intellij.ml.llm.context.airules.metadata.AiRuleMetadataModel;
import com.intellij.ml.llm.context.airules.metadata.AiRuleType;
import com.intellij.ml.llm.context.airules.metadata.AiRuleTypeComboboxProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "metadataModel", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataModel;)V", "typePanel", "extraFieldsPanel", "changeType", "", "newType", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleType;", "setupTypePanel", "type", "updateExtraFields", "createFieldPanel", "field", "Lcom/intellij/ml/llm/context/airules/metadata/AiRuleMetadataField;", "createTextField", "wrapWithLabel", "component", "Ljavax/swing/JComponent;", "intellij.ml.llm.context.airules"})
public final class AiRuleMetadataPanel
extends JPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final AiRuleMetadataModel metadataModel;
    @NotNull
    private final JPanel typePanel;
    @NotNull
    private final JPanel extraFieldsPanel;

    public AiRuleMetadataPanel(@NotNull Project project2, @NotNull AiRuleMetadataModel metadataModel) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)metadataModel, (String)"metadataModel");
        this.project = project2;
        this.metadataModel = metadataModel;
        this.typePanel = new JPanel(new BorderLayout());
        this.extraFieldsPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder((Border)JBUI.Borders.empty((int)8, (int)16));
        AiRuleType aiRuleType = AiRulesService.Companion.getInstance(this.project).getCurrentType(this.metadataModel);
        if (aiRuleType == null) {
            aiRuleType = AiRuleType.ALWAYS;
        }
        AiRuleType selectedType = aiRuleType;
        JPanel mainRow = new JPanel(new BorderLayout(24, 0));
        mainRow.setAlignmentX(0.0f);
        this.typePanel.setAlignmentX(0.0f);
        this.setupTypePanel(selectedType);
        mainRow.add((Component)this.typePanel, "West");
        this.extraFieldsPanel.setAlignmentX(0.0f);
        this.extraFieldsPanel.setLayout(new BoxLayout(this.extraFieldsPanel, 0));
        this.updateExtraFields(selectedType);
        mainRow.add((Component)this.extraFieldsPanel, "Center");
        this.add(mainRow);
    }

    public final void changeType(@NotNull AiRuleType newType) {
        Intrinsics.checkNotNullParameter((Object)((Object)newType), (String)"newType");
        this.setupTypePanel(newType);
        this.updateExtraFields(newType);
        this.revalidate();
        this.repaint();
    }

    private final void setupTypePanel(AiRuleType type2) {
        this.typePanel.removeAll();
        ComboBox<AiRuleType> typeCombo = new AiRuleTypeComboboxProvider(this.project, type2, this.metadataModel, (Function1<? super AiRuleType, Unit>)((Function1)arg_0 -> AiRuleMetadataPanel.setupTypePanel$lambda$0(this, arg_0))).getCombobox();
        this.typePanel.add((Component)this.wrapWithLabel(AiRuleMetadataField.TYPE, (JComponent)typeCombo), "Center");
        this.typePanel.revalidate();
        this.typePanel.repaint();
    }

    private final void updateExtraFields(AiRuleType type2) {
        this.extraFieldsPanel.removeAll();
        AiRuleMetadataField aiRuleMetadataField = type2.getExtraField();
        if (aiRuleMetadataField != null) {
            AiRuleMetadataField field = aiRuleMetadataField;
            boolean bl = false;
            this.extraFieldsPanel.add(this.createFieldPanel(field));
        }
        this.extraFieldsPanel.revalidate();
        this.extraFieldsPanel.repaint();
    }

    private final JPanel createFieldPanel(AiRuleMetadataField field) {
        switch (WhenMappings.$EnumSwitchMapping$0[field.ordinal()]) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Can't create a panel for unsupported field type: " + field);
            }
        }
        return this.createTextField(field);
    }

    private final JPanel createTextField(AiRuleMetadataField field) {
        JBTextField jBTextField;
        JPanel fieldPanel = new JPanel(new BorderLayout(8, 0));
        ContextHelpLabel contextHelpLabel = ContextHelpLabel.create((String)field.getEmptyText());
        Intrinsics.checkNotNullExpressionValue((Object)contextHelpLabel, (String)"create(...)");
        ContextHelpLabel helpLabel = contextHelpLabel;
        String string = this.metadataModel.getField(field);
        if (string == null) {
            string = "";
        }
        String currentValue = string;
        JBTextField $this$createTextField_u24lambda_u240 = jBTextField = new JBTextField(currentValue);
        boolean bl = false;
        if (((CharSequence)currentValue).length() == 0) {
            $this$createTextField_u24lambda_u240.getEmptyText().setText(field.getEmptyText());
        }
        JBTextField textField = jBTextField;
        textField.getDocument().addDocumentListener(new DocumentListener(this, field, textField){
            final /* synthetic */ AiRuleMetadataPanel this$0;
            final /* synthetic */ AiRuleMetadataField $field;
            final /* synthetic */ JBTextField $textField;
            {
                this.this$0 = $receiver;
                this.$field = $field;
                this.$textField = $textField;
            }

            public void insertUpdate(DocumentEvent e) {
                this.updateField();
            }

            public void removeUpdate(DocumentEvent e) {
                this.updateField();
            }

            public void changedUpdate(DocumentEvent e) {
                this.updateField();
            }

            private final void updateField() {
                AiRuleMetadataModel aiRuleMetadataModel = AiRuleMetadataPanel.access$getMetadataModel$p(this.this$0);
                String string = this.$textField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                AiRuleMetadataModel.updateField$default(aiRuleMetadataModel, this.$field, string, false, 4, null);
            }
        });
        fieldPanel.add((Component)textField, "Center");
        fieldPanel.add((Component)helpLabel, "East");
        return this.wrapWithLabel(field, fieldPanel);
    }

    private final JPanel wrapWithLabel(AiRuleMetadataField field, JComponent component2) {
        JPanel jPanel;
        JPanel $this$wrapWithLabel_u24lambda_u240 = jPanel = new JPanel(new BorderLayout(8, 0));
        boolean bl = false;
        $this$wrapWithLabel_u24lambda_u240.add((Component)new JBLabel(field.getDisplayName() + ":"), "West");
        $this$wrapWithLabel_u24lambda_u240.add((Component)component2, "Center");
        return jPanel;
    }

    private static final Unit setupTypePanel$lambda$0(AiRuleMetadataPanel this$0, AiRuleType newType) {
        Intrinsics.checkNotNullParameter((Object)((Object)newType), (String)"newType");
        this$0.updateExtraFields(newType);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ AiRuleMetadataModel access$getMetadataModel$p(AiRuleMetadataPanel $this) {
        return $this.metadataModel;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AiRuleMetadataField.values().length];
            try {
                nArray[AiRuleMetadataField.INSTRUCTIONS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AiRuleMetadataField.PATTERN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

