/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.cpp.common.error;

import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import com.intellij.openapi.project.Project;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/cpp/common/error/CppConsoleOutputExplainFilter;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "isErrorBegin", "", "line", "", "entireLength", "", "isErrorEnd", "intellij.ml.llm.cpp.common"})
public final class CppConsoleOutputExplainFilter
extends ErrorExplainFilter {
    private final Pattern pattern;

    public CppConsoleOutputExplainFilter(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.pattern = Pattern.compile("^\\s*(#\\d+|\\d+#|\\d+>)\\s");
    }

    public boolean isErrorBegin(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.NO_EXCEPTION && this.pattern.matcher(line).find();
    }

    public boolean isErrorEnd(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.COLLECTING && StringsKt.isBlank((CharSequence)line);
    }
}

