/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.listeners;

import com.intellij.ml.llm.daemon.insight.handler.InsightsHandler;
import com.intellij.ml.llm.daemon.insight.handler.provider.Debounce;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.BulkAwareDocumentListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/listeners/InsightTypingListener;", "Lcom/intellij/openapi/editor/event/BulkAwareDocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.ml.llm.daemon"})
public final class InsightTypingListener
implements BulkAwareDocumentListener {
    @NotNull
    private final Editor editor;

    public InsightTypingListener(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
    }

    public void documentChanged(@NotNull DocumentEvent event2) {
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project2 = this.editor.getProject();
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        if (this.editor.isDisposed() || project3.isDisposed()) {
            return;
        }
        Debounce.INSTANCE.typingHappened(this.editor);
        InsightsHandler.Companion.getInstance(project3).hideAll(this.editor);
        InsightEvent insightEvent = InsightEvent.Companion.create(this.editor);
        if (insightEvent == null) {
            return;
        }
        InsightsHandler.Companion.getInstance(project3).execute(insightEvent);
    }
}

