/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.intellij.ml.llm.daemon.insight.handler.provider.InsightsBannedRanges;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightWorkingRange;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "entries", "", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges$CacheEntry;", "getBannedIn", "", "", "document", "Lcom/intellij/openapi/editor/Document;", "workingRange", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "dispose", "", "CacheEntry", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightsBannedRanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsBannedRanges.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1#2:70\n1#2:84\n774#3:71\n865#3,2:72\n1617#3,9:74\n1869#3:83\n1870#3:85\n1626#3:86\n774#3:87\n865#3,2:88\n1374#3:90\n1460#3,5:91\n*S KotlinDebug\n*F\n+ 1 InsightsBannedRanges.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges\n*L\n52#1:84\n51#1:71\n51#1:72,2\n52#1:74,9\n52#1:83\n52#1:85\n52#1:86\n53#1:87\n53#1:88,2\n54#1:90\n54#1:91,5\n*E\n"})
public final class InsightsBannedRanges
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<CacheEntry> entries;
    private static final int EXPANSION_LINES = 30;
    private static final long MARKER_TTL_MS = DurationKt.toDuration((int)3, (DurationUnit)DurationUnit.MINUTES);
    private static final long CACHE_SIZE = 10L;

    public InsightsBannedRanges() {
        ConcurrentMap it = Caffeine.newBuilder().maximumSize(10L).expireAfterWrite(Duration.getInWholeMilliseconds-impl((long)MARKER_TTL_MS), TimeUnit.MILLISECONDS).removalListener((RemovalListener)entries.1.INSTANCE).build().asMap();
        InsightsBannedRanges insightsBannedRanges = this;
        boolean bl = false;
        Set set = Collections.newSetFromMap(it);
        Intrinsics.checkNotNullExpressionValue(set, (String)"let(...)");
        insightsBannedRanges.entries = set;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresReadLock
    @NotNull
    public final Set<Integer> getBannedIn(@NotNull Document document2, @NotNull InsightWorkingRange workingRange) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
        TextRange workingTextRange = new TextRange(document2.getLineStartOffset(workingRange.getFirstLine()), document2.getLineEndOffset(workingRange.getLastLine()));
        Iterable $this$filter$iv = this.entries;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CacheEntry)element$iv$iv;
            boolean bl = false;
            if (!(((CacheEntry)it).getDocumentHash() == document2.hashCode())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        it = $this$forEach$iv$iv$iv.iterator();
        while (it.hasNext()) {
            TextRange it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = it.next();
            boolean bl = false;
            CacheEntry it2 = (CacheEntry)element$iv$iv;
            boolean bl2 = false;
            if (it2.getMarker().getTextRange().intersection(workingTextRange) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TextRange)element$iv$iv;
            boolean bl = false;
            if (!(!it.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (TextRange)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = (Iterable)new IntRange(document2.getLineNumber(it.getStartOffset()), document2.getLineNumber(it.getEndOffset()));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.distinct((Iterable)CollectionsKt.sorted((Iterable)((List)destination$iv$iv))));
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges$CacheEntry;", "", "documentHash", "", "marker", "Lcom/intellij/openapi/editor/RangeMarker;", "<init>", "(ILcom/intellij/openapi/editor/RangeMarker;)V", "getDocumentHash", "()I", "getMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.daemon"})
    private static final class CacheEntry {
        private final int documentHash;
        @NotNull
        private final RangeMarker marker;

        public CacheEntry(int documentHash, @NotNull RangeMarker marker) {
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            this.documentHash = documentHash;
            this.marker = marker;
        }

        public final int getDocumentHash() {
            return this.documentHash;
        }

        @NotNull
        public final RangeMarker getMarker() {
            return this.marker;
        }

        public final int component1() {
            return this.documentHash;
        }

        @NotNull
        public final RangeMarker component2() {
            return this.marker;
        }

        @NotNull
        public final CacheEntry copy(int documentHash, @NotNull RangeMarker marker) {
            Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
            return new CacheEntry(documentHash, marker);
        }

        public static /* synthetic */ CacheEntry copy$default(CacheEntry cacheEntry, int n, RangeMarker rangeMarker, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = cacheEntry.documentHash;
            }
            if ((n2 & 2) != 0) {
                rangeMarker = cacheEntry.marker;
            }
            return cacheEntry.copy(n, rangeMarker);
        }

        @NotNull
        public String toString() {
            return "CacheEntry(documentHash=" + this.documentHash + ", marker=" + this.marker + ")";
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.documentHash);
            result2 = result2 * 31 + this.marker.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheEntry)) {
                return false;
            }
            CacheEntry cacheEntry = (CacheEntry)other;
            if (this.documentHash != cacheEntry.documentHash) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.marker, (Object)cacheEntry.marker);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges$Companion;", "", "<init>", "()V", "EXPANSION_LINES", "", "MARKER_TTL_MS", "Lkotlin/time/Duration;", "J", "CACHE_SIZE", "", "getInstance", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightsBannedRanges.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsBannedRanges.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,69:1\n30#2,2:70\n*S KotlinDebug\n*F\n+ 1 InsightsBannedRanges.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/InsightsBannedRanges$Companion\n*L\n67#1:70,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsightsBannedRanges getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<InsightsBannedRanges> serviceClass$iv = InsightsBannedRanges.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InsightsBannedRanges)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

