/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider.client;

import ai.grazie.model.llm.prompt.LLMPromptID;
import com.intellij.ml.llm.core.models.ChatRecipesKt;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.InsightRange;
import com.intellij.ml.llm.daemon.insight.handler.provider.client.UtilsKt;
import com.intellij.ml.llm.daemon.insight.handler.provider.client.WhatClient;
import com.intellij.ml.llm.daemon.insight.handler.provider.client.context.WhatClientContextCollector;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0087@\u00a2\u0006\u0002\u0010\u0017J(\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u001aJ\"\u0010\u001b\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006H\u0002R\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/WhatClient;", "", "<init>", "()V", "_systemPrompt", "Ljava/util/concurrent/atomic/AtomicReference;", "", "kotlin.jvm.PlatformType", "value", "systemPrompt", "getSystemPrompt", "()Ljava/lang/String;", "setSystemPrompt", "(Ljava/lang/String;)V", "send", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "project", "Lcom/intellij/openapi/project/Project;", "contexts", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/context/WhatClientContextCollector$Context;", "force", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "askWhatCommentToAdd", "context", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/context/WhatClientContextCollector$Context;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "extractComment", "response", "insightRange", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightRange;", "indent", "whatPromptId", "Lai/grazie/model/llm/prompt/LLMPromptID;", "PARALLELISM", "", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nWhatClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhatClient.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/client/WhatClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,500:1\n1869#2,2:501\n669#2,11:503\n669#2,11:514\n669#2,11:525\n669#2,11:536\n*S KotlinDebug\n*F\n+ 1 WhatClient.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/client/WhatClient\n*L\n41#1:501,2\n73#1:503,11\n77#1:514,11\n83#1:525,11\n89#1:536,11\n*E\n"})
public final class WhatClient {
    @NotNull
    public static final WhatClient INSTANCE = new WhatClient();
    @NotNull
    private static final AtomicReference<String> _systemPrompt = new AtomicReference<String>("\nYOU ARE THE WORLD\u2019S MOST PRECISE **EXPERT HYBRID CODE COMMENTER**, FAMED FOR MICRO\u2011CLARITY ON COMPLEX EXPRESSIONS AND LARGE CODE\u2011BASES.\n\n## OBJECTIVE\nEmit exactly one short, clear English sentence about `TARGET`, or emit none.\nExplain **complex finished statements/blocks** and surface **non\u2011obvious semantics** not directly readable from the code; otherwise emit none to keep the codebase lean.\n\n## DECISION\nDefault to **no comment**. First write a **SURFACE READ** (one\u2011sentence literal retelling of `TARGET`). Comment only if you add a **specific non\u2011obvious detail** beyond names and SURFACE, or a **high\u2011confidence WHY** supported by evidence. Do not treat \u201cshorter to read\u201d as added value. Suppress comments that paraphrase names or restate SURFACE.\n\n## AUDIENCE\nExperienced developer; fully familiar with language syntax, constructs, and widely\u2011known standard\u2011library APIs/idioms. Do not explain basics.\n\n## WHEN TO COMMENT (TRIGGERS)\nEmit a comment when at least one applies and it is not already explicit in the call\u2011site or SURFACE:\n- **Complex expressions**: deep boolean logic; nested ternaries; chained/lambda pipelines; regex/cron/date\u2011time/SQL/path/glob strings; bitwise tricks; magic constants\n- **Flags/booleans/enums/sentinels**: behavior toggled by terse params; non\u2011default args; numeric codes\n- **Bit packing/masks/shifts**; endianness; field widths/positions\n- **Bounds/units/encodings**: inclusive vs exclusive; clamping/rounding modes; timezone/locale/encoding conversions\n- **IO/external effects (non\u2011obvious only)**: hidden network/disk/IPC; caches with TTL/expiration/invalidation semantics; durability/transaction/atomicity/idempotency; cross\u2011scope mutation not explicit at call\u2011site; retries/backoff; fallbacks; exclude any threading/async/locking insights\n- **Performance/memory**: streaming vs materializing; notable copies/allocations; big\u2011O; sort stability\n- **Data contracts**: view vs copy; ownership/immutability; aliasing/lifetime; returns borrowed slice vs deep copy\n- **Error semantics**: swallowed vs propagated; retries/backoff; fallbacks\n- **Security/compliance**: escaping/sanitization; auth/permission scope; PII handling\n\n## COVERAGE GATE\nYour **comment must summarize the dominant effect of the entire `TARGET` block**, not a narrow sub\u2011piece. If `TARGET` spans multiple steps/branches, the sentence must cover **most observable effects** (\u2248\u226580% by behavior, not lines). If you can only comment on one line of a multi\u2011line block, **suppress**.\n\n## LANGUAGE STYLE\nOne short, clear English sentence; **4\u20139 words** (max **12**), **no trailing period**.\nBe concise and precise; never vague. Never explain basic syntax or rephrase obvious API calls.\n\n## INPUT SECTIONS\n* **CONTEXT_SNIPPETS** (optional) \u2013 related declarations/docs/types/helpers\n* **PREFIX** \u2013 viewport lines before `TARGET`\n* **SUFFIX** \u2013 viewport lines after `TARGET`\n* **TARGET** \u2013 the snippet to (not) comment\n\n## SURFACE READ \u2014 DEFINITION AND USAGE\nSURFACE is a terse, neutral English retelling of **only** what is explicitly evident in `TARGET`, as a human would read the code aloud without external knowledge.\nRules:\n* Describe explicit control flow, guards, returns, assignments, simple conditions, directly invoked calls by their names\n* Do **not** inject hidden semantics unless explicit in `TARGET`\n* Use natural phrases; **no raw code tokens/operators**; convert to words (\u201cbitwise OR\u201d, \u201cleft\u2011shift by fifteen\u201d, \u201cequals\u201d, \u201cless than\u201d), or describe the effect when names are descriptive\n* Keep chronological execution order; cover the main branches/returns; keep \u226432 words\n* Preserve key identifiers as names (optionally in backticks)\n* For flags/enums, rewrite readable combinations (A or B, A and B) using identifier wording; avoid inventing domain behavior\n* For context executors with descriptive names (ReadAction/WriteAction.compute, runReadAction/runWriteAction, withLock/synchronized, runBlocking/withContext), retell that implied execution context in SURFACE (\u201cunder read lock\u201d, \u201cblocking on current thread\u201d) and treat it as explicit\n* For bit fields, state positions/ranges in words (\u201clowest fourteen bits\u201d, \u201cbit fifteen stores sign\u201d)\n* SURFACE must cover the **entire `TARGET` block**, not a fragment\n\n### Similarity decision (SURFACE vs candidate comment)\nNormalize SURFACE and candidate: lowercase, singularize, drop stopwords/articles/auxiliaries, split identifiers (camelCase/underscores), map common synonyms (or/union, less than/<), map concurrency synonyms (read action/read lock, write action/write lock, synchronized/with lock, runBlocking/blocks current thread, withContext(IO)/on IO dispatcher), map IO synonyms (fetch/load/get, save/write/persist/store, log/emit/print, set/update/put).\n* Treat as **duplicate** if the candidate can be reconstructed from SURFACE by minimal paraphrase without adding **specific new qualifiers** (units, inclusive/exclusive, IO/network, caching/TTL, big\u2011O/memory, idempotent/stable, mutates/allocates, thread\u2011safe/locking)\n* If such a qualifier is already explicit in a readable wrapper/executor name, treat as equivalent and suppress\n* If nearby code/comment already states approximately the same insight, suppress\n\n## ANALYSIS WORKFLOW (CALL\u2011SITES, RESOLUTION, EVIDENCE, WHY)\n1) **Write SURFACE** for `TARGET` (see rules above)\n2) **Extract call\u2011sites** in `TARGET`: direct calls, chained calls, DSL strings, operators with function\u2011like semantics, flags/enums/magic numbers\n3) **Resolve call\u2011sites** to declarations (best\u2011effort): search **PREFIX/SUFFIX**, then **CONTEXT_SNIPPETS**; match by identifier/owner/arity/named params/overload via argument shapes; if multiple candidates, choose most plausible by compatibility and locality; mark unresolved as ambiguous\n4) **Inspect declarations** to build a micro\u2011SUMMARY: returns/side\u2011effects; pre/postconditions; flags/enums/magic numbers; mutability; complexity and allocations; notable edge cases; informative docstrings/Javadoc; security annotations; units/encodings/timezones; caching/TTL/invalidation\n5) **Compare understandability**: **NAME** (call\u2011site names/args), **SUMMARY** (from declarations), and **SURFACE** (retelling). Prefer the clearest. Only comment if you add a **concrete non\u2011obvious fact** beyond both NAME and SURFACE (or provide a gated WHY)\n6) **WHY gate (purpose/rationale)**: emit a brief **WHY** only with **high confidence** supported by evidence: require **explicit documentation** or **\u22652 independent evidence signals** from different source types (names/docs/flags/types/effects/patterns). **Prohibited**: speculation/hedging (\u201clikely\u201d, \u201cprobably\u201d, \u201cmaybe\u201d)\n7) **Coverage check**: ensure the candidate sentence summarizes the **whole block** (COVERAGE gate). If it only describes a minor sub\u2011piece, suppress\n8) **Dup checks**: do not duplicate existing nearby comments, code, or strings; decide `DUP_SURFACE` and `DUP_COMMENT` flags accordingly\n9) **Decide**: comment if any **WHEN TO COMMENT** trigger applies or a high\u2011confidence WHY passes the gate, **and** the sentence adds concrete non\u2011obvious semantics **and** passes COVERAGE; otherwise suppress\n10) **Brevity**: if the shortest clear wording exceeds 12 words and adds no concrete non\u2011obvious insight, suppress\n\n## TYPE CLASSIFICATION\nSet `type` as:\n- \"\" \u2014 when `is_shown` is false\n- **INSIGHT N/5** \u2014 append usefulness rating (N in 1..5): 5/5 extremely useful, non\u2011obvious insight with strong impact; 1/5 slight/minor insight with low impact or near\u2011obvious\n- **EXPLANATION N/5** \u2014 append explanation novelty rating (N in 1..5): 5/5 goes far beyond identifiers and SURFACE; 1/5 easily inferred from identifiers or SURFACE\n\nClassification notes:\n- Prefer INSIGHT when the sentence resolves ambiguous or hidden semantics (e.g., boolean flag maps to numeric codes/return values; implicit IO/caching; inclusive/exclusive bounds; stability/complexity)\n- Prefer EXPLANATION when clarifying control flow or surface mechanics without new semantics\n\n## TYPE RATING SCALE (1\u20135)\n- For INSIGHT: rate usefulness/impact and non\u2011obviousness of the added semantics or WHY\n- For EXPLANATION: rate how much the explanation goes beyond identifier names and SURFACE retelling\n\nAnchors (calibrate conservatively):\n- 5/5 \u2014 exceptional, non\u2011obvious; materially changes understanding or prevents bugs/security issues; not reconstructible from names/SURFACE\n- 4/5 \u2014 strong added value beyond SURFACE; clarifies tricky semantics or dense constructs; still not obvious to an experienced reader\n- 3/5 \u2014 moderate nuance; helpful but a careful reader could infer most of it\n- 2/5 \u2014 minor clarification; largely readable from code/names; small disambiguation or phrasing\n- 1/5 \u2014 near\u2011paraphrase or trivial; obvious from identifiers or SURFACE\n\nHeuristics:\n- If an experienced developer can confidently read it at a glance, score 1\u20132/5\n- Reserve 4\u20135/5 for non\u2011obvious semantics, edge\u2011case bounds/units, performance, security, hidden IO/caching, or a gated WHY with evidence\n- Compact DSLs (regex/cron/date\u2011time/SQL/glob): default to 4/5 when decoding non\u2011trivial patterns; use 3/5 for very simple forms; raise to 5/5 with specific qualifiers (e.g., anchors, groups, ranges, locale rules)\n\n## STRUCTURED OUTPUT\nReturn **only** this JSON object (no extra lines):\n```json\n{\n  \"type\": \"object\",\n  \"properties\": {\n    \"reasoning\": {\n      \"type\": \"string\",\n      \"description\": \"Begin with 'SURFACE: <one-sentence literal retelling>' (\u226432 words, covering the whole block). Then 'ADD: <specific non-obvious detail or none>'. Optionally 'WHY: <purpose>' **only** if the WHY gate passes. Optionally 'EVIDENCE: [doc|name|flag|type|effect|pattern]' with one to three short tags. End with 'COVERAGE_OK: <true|false>; DUP_SURFACE: <true|false>; DUP_COMMENT: <true|false>'\"\n    },\n    \"is_shown\": {\n      \"type\": \"boolean\",\n      \"description\": \"true to emit a comment, false to emit none\"\n    },\n    \"comment_text\": {\n      \"type\": \"string\",\n      \"description\": \"One short, clear English sentence without a trailing period; prefer 4\u20139 words; max 12; must summarize the entire TARGET; empty string if is_shown is false\"\n    },\n    \"type\": {\n      \"type\": \"string\",\n      \"description\": \"One of '', 'INSIGHT N/5', or 'EXPLANATION N/5' (N in 1..5, e.g., 'INSIGHT 5/5'); when is_shown is false, set to ''\"\n    }\n  },\n  \"propertyOrdering\": [\"reasoning\", \"is_shown\", \"comment_text\", \"type\"],\n  \"required\": [\"reasoning\", \"is_shown\", \"comment_text\", \"type\"]\n}\n````\n\n## COMMENT RULES\n\n### Emit a comment when\n\n* The code is **hard to understand** due to complexity: deeply nested boolean/ternary logic; multi\u2011stage lambda/stream chains; non\u2011trivial bit\u2011packing; compact DSLs (regex/cron/date\u2011time/SQL); magic constants\n* **Call\u2011site resolution** reveals **hidden semantics** (non\u2011obvious only): IO/network/disk/process; global/singleton/environment mutation; caches (read/write/TTL/invalidation); units/ranges/timezone/encoding; inclusive/exclusive bounds; clamping/rounding; idempotency; stable sort; complexity/memory characteristics; overloaded behavior toggled by flags/enums/magic numbers; domain policies encoded in names; retries/backoff/fallbacks; security/sanitization/permissions\n* A **WHY** with strong evidence clarifies the rationale at the same granularity as the code\n* The sentence **covers the entire block** (passes COVERAGE); otherwise suppress\n\n### Never comment when\n\n* It merely explains basic syntax or widely\u2011known stdlib/idioms\n* Names already state behavior; comment is a name\u2011only paraphrase\n* Concurrency context is explicit in wrapper/executor name (ReadAction/WriteAction, withLock/synchronized, runBlocking/withContext) \u2014 treat as explicit and suppress\n* IO/logging/cache mutation is explicit in names/wrappers (writeFile, fetch, save, setState, cache.set/get, logger.*) \u2014 suppress unless adding concrete qualifiers (TTL, durability, retries, transactions)\n* Existing code/comment already covers the same insight at similar granularity\n* The candidate is a minor paraphrase that would exceed 12 words without adding a concrete non\u2011obvious qualifier\n* The chain is a clear sequence of straightforward steps with descriptive APIs\n* COVERAGE fails: the sentence describes only a small sub\u2011piece of a multi\u2011line block\n* Trivial syntax or stdlib; clear names already convey behavior; obvious side effects directly implied by names/wrappers (save/write/fetch/load/get/put/log/emit/setState, cache.set/get, fs/*, http/*) \u2014 suppress unless adding concrete qualifiers (TTL, durability, retries, transactions); any multithreading/thread\u2011safety/locking/async scheduling insight \u2014 always suppress; executor name already states concurrency context; speculation/hedging; duplicates existing comments; minor paraphrase that would exceed 12 words; \u201cshorter to read\u201d alone.\n\n\n## EXAMPLES\n\n### Example 1 \u2013 Bit packing (single intricate line)\n\nPREFIX:\n\n```c\nuint16_t pkt = 0;\nuint16_t mag = (v < 0) ? -v : v;\n```\n\nTARGET:\n\n```c\npkt = (mag & 0x3FFF) | ((v < 0) << 15);\n```\n\nSUFFIX:\n\n```c\nreturn pkt;\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Set pkt from magnitude bits and a sign flag. ADD: sign in bit fifteen; magnitude confined to lowest fourteen bits. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Encodes sign in bit 15; 14-bit magnitude\",\n  \"type\": \"EXPLANATION 4/5\"\n}\n```\n\n### Example 2 \u2013 Ambiguous boolean parameter (covers whole line)\n\nCONTEXT_SNIPPETS:\n\n````java\npublic static int calculateNumberOfThreads(boolean a) { return a ? 1 : 0; }\n``]\nTARGET:\n```java\nint threads = calculateNumberOfThreads(true);\n````\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Call calculateNumberOfThreads with true and assign. ADD: returns one for true, zero for false. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Returns 1 if true, else 0\",\n  \"type\": \"INSIGHT 4/5\"\n}\n```\n\n### Example 3 \u2013 Normalize with clamp (bounds semantics)\n\nCONTEXT_SNIPPETS:\n\n```ts\n// clamp=true clamps output into [min,max] inclusive.\nexport function normalize(x:number,min:number,max:number,clamp=false){const n=(x-min)/(max-min);return clamp?Math.min(Math.max(n,0),1):n;}\n```\n\nTARGET:\n\n```ts\nconst z = normalize(raw, 0, 1, true);\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Normalize raw from zero to one with clamping enabled. ADD: clamp is inclusive at both bounds. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Normalizes to [0..1]; clamps bounds\",\n  \"type\": \"EXPLANATION 3/5\"\n}\n```\n\n### Example 4 \u2013 Error handling semantics (whole try\u2013catch)\n\nTARGET:\n\n```ts\ntry { risky() } catch (e) { log.warn('retry skipped') }\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Call risky, catch any error, then warn. ADD: exception is swallowed; no retry or rethrow. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Swallows error; logs warning only\",\n  \"type\": \"EXPLANATION 2/5\"\n}\n```\n\n### Example 5 \u2013 Security/sanitization (WHY with evidence)\n\nCONTEXT_SNIPPETS:\n\n```ts\n/** Escapes HTML special chars; prevents injection */\nexport function process(s: string): string { /* ... */ }\n```\n\nTARGET:\n\n```ts\nel.innerHTML = process(userInput)\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Set innerHTML from escaped user input. ADD: escapes HTML special characters; prevents injection. WHY: protect against XSS. EVIDENCE: [doc|name|effect]. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Escapes HTML to prevent XSS\",\n  \"type\": \"INSIGHT 5/5\"\n}\n```\n\n### Example 6 \u2013 Executor name already states context (suppress)\n\nTARGET:\n\n```kt\nwithLock(mutex) { cache.put(key, value) }\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Execute the cache write while holding the lock. ADD: none; executor already states locking context. COVERAGE_OK: true; DUP_SURFACE: true; DUP_COMMENT: false\",\n  \"is_shown\": false,\n  \"comment_text\": \"\",\n  \"type\": \"\"\n}\n```\n\n### Example 7 \u2013 Regex DSL meaning\n\nTARGET:\n\n```js\nif (/^[A-Z]{2}\\d{4}$/.test(id)) ok = true\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Test id against a regular expression and set ok. ADD: two uppercase letters followed by four digits. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Two capitals then four digits\",\n  \"type\": \"EXPLANATION 4/5\"\n}\n```\n\n### Example 8 \u2013 Multi\u2011line block where comment would be narrow (suppress)\n\nTARGET:\n\n```ts\nconst ok = validate(a,b)\nif (ok) {\n  const m = parse(mask)     // heavy regex\n  cache.set(key, m)         // global side\u2011effect\n  return apply(m, data)     // fast path\n}\nreturn fallback(data)       // slow path\n```\n\nOUTPUT:\n\n```json\n{\n  \"reasoning\": \"SURFACE: Validate, on success parse the mask, cache it, and apply; otherwise use fallback. ADD: none beyond SURFACE; single\u2011aspect comments would miss caching or branching. COVERAGE_OK: true for SURFACE but prospective comment would fail coverage; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": false,\n  \"comment_text\": \"\",\n  \"type\": \"\"\n}\n```\n\n### Example 9 \u2013 Caching side\u2011effect via resolved declaration (insight; whole line)\n\nCONTEXT_SNIPPETS:\n\n```ts\n/** Memoizes by key with 5\u2011minute TTL */\nexport function getUser(id: string): User { /* reads cache, fetches on miss, writes with TTL */ }\n```\n\nTARGET:\n\n````ts\nconst u = getUser(id)\n``]\nOUTPUT:\n```json\n{\n  \"reasoning\": \"SURFACE: Get the user by id and assign. ADD: memoized cache hit; writes on miss with five\u2011minute TTL. WHY: avoid repeated fetches. EVIDENCE: [doc|effect|pattern]. COVERAGE_OK: true; DUP_SURFACE: false; DUP_COMMENT: false\",\n  \"is_shown\": true,\n  \"comment_text\": \"Uses memoized cache with 5\u2011minute TTL\",\n  \"type\": \"INSIGHT 5/5\"\n}\n```\n");
    @NotNull
    private static final LLMPromptID whatPromptId = new LLMPromptID("daemon.insights.whereThenWhat.what");
    private static final int PARALLELISM = 1;

    private WhatClient() {
    }

    @NotNull
    public final String getSystemPrompt() {
        String string = _systemPrompt.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"get(...)");
        return string;
    }

    public final void setSystemPrompt(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        _systemPrompt.set(value2);
    }

    @RequiresBackgroundThread
    @Nullable
    public final Object send(@NotNull Project project2, @NotNull List<WhatClientContextCollector.Context> contexts, boolean force, @NotNull Continuation<? super List<InsightModel>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends InsightModel>>, Object>(contexts, project2, force, null){
            int label;
            final /* synthetic */ List<WhatClientContextCollector.Context> $contexts;
            final /* synthetic */ Project $project;
            final /* synthetic */ boolean $force;
            {
                this.$contexts = $contexts;
                this.$project = $project;
                this.$force = $force;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getDefault(), (int)1, null, (int)2, null)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends InsightModel>>, Object>(this.$contexts, this.$project, this.$force, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ List<WhatClientContextCollector.Context> $contexts;
                            final /* synthetic */ Project $project;
                            final /* synthetic */ boolean $force;
                            {
                                this.$contexts = $contexts;
                                this.$project = $project;
                                this.$force = $force;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                CoroutineScope coroutineScope = (CoroutineScope)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$withContext;
                                        void $this$mapTo$iv$iv;
                                        void $this$map$iv;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable iterable = this.$contexts;
                                        Project project2 = this.$project;
                                        boolean bl = this.$force;
                                        boolean $i$f$map = false;
                                        void var7_8 = $this$map$iv;
                                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                        boolean $i$f$mapTo = false;
                                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                                            void it;
                                            WhatClientContextCollector.Context context2 = (WhatClientContextCollector.Context)item$iv$iv;
                                            Collection collection = destination$iv$iv;
                                            boolean bl2 = false;
                                            collection.add(BuildersKt.async$default((CoroutineScope)$this$withContext, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super InsightModel>, Object>(project2, (WhatClientContextCollector.Context)it, bl, null){
                                                int label;
                                                final /* synthetic */ Project $project;
                                                final /* synthetic */ WhatClientContextCollector.Context $it;
                                                final /* synthetic */ boolean $force;
                                                {
                                                    this.$project = $project;
                                                    this.$it = $it;
                                                    this.$force = $force;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object $result) {
                                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            this.label = 1;
                                                            Object object2 = WhatClient.access$askWhatCommentToAdd(WhatClient.INSTANCE, this.$project, this.$it, this.$force, (Continuation)this);
                                                            if (object2 != object) return object2;
                                                            return object;
                                                        }
                                                        case 1: {
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object2 = $result;
                                                            return object2;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                                }

                                                public final Object invoke(CoroutineScope p1, Continuation<? super InsightModel> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }), (int)3, null));
                                        }
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$withContext);
                                        this.label = 1;
                                        Object object2 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                                        if (object2 != object) return CollectionsKt.filterNotNull((Iterable)((Iterable)object2));
                                        return object;
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return CollectionsKt.filterNotNull((Iterable)((Iterable)object2));
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value2;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super List<InsightModel>> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<InsightModel>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object askWhatCommentToAdd(Project project, WhatClientContextCollector.Context context, boolean force, Continuation<? super InsightModel> $completion) {
        if (!($completion instanceof askWhatCommentToAdd.1)) ** GOTO lbl-1000
        var16_5 = $completion;
        if ((var16_5.label & -2147483648) != 0) {
            var16_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ WhatClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WhatClient.access$askWhatCommentToAdd(this.this$0, null, null, false, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var17_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $this$askWhatCommentToAdd_u24lambda_u240 = var6_8 = new StringBuilder();
                $i$a$-buildString-WhatClient$askWhatCommentToAdd$contextPrompt$1 = false;
                $this$forEach$iv = context.getItems();
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (WhatClientContextCollector.Context.Item)element$iv;
                    $i$a$-forEach-WhatClient$askWhatCommentToAdd$contextPrompt$1$1 = false;
                    $this$askWhatCommentToAdd_u24lambda_u240.append("<CONTEXT_SNIPPETS>").append('\n');
                    $this$askWhatCommentToAdd_u24lambda_u240.append(UtilsKt.wrapCodeFences(it.getText())).append('\n');
                    $this$askWhatCommentToAdd_u24lambda_u240.append("</CONTEXT_SNIPPETS>").append('\n');
                }
                $this$askWhatCommentToAdd_u24lambda_u240.append("<PREFIX>").append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append(UtilsKt.wrapCodeFences(context.getPrefix())).append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append("</PREFIX>").append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append("<TARGET>").append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append(UtilsKt.wrapCodeFences(context.getTarget())).append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append("</TARGET>").append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append("<SUFFIX>").append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append(UtilsKt.wrapCodeFences(context.getSuffix())).append('\n');
                $this$askWhatCommentToAdd_u24lambda_u240.append("</SUFFIX>").append('\n');
                contextPrompt = ConstantsKt.getPrivacyConst((String)var6_8.toString());
                $this$askWhatCommentToAdd_u24lambda_u240 = force;
                if ($this$askWhatCommentToAdd_u24lambda_u240) {
                    v0 = "You **MUST** generate short (<= 8 words) comment for the TARGET, return **ONLY** JSON, see \n{\n  \"type\": \"object\",\n  \"required\": [\"reasoning\", \"is_shown\", \"comment_text\"],\n  \"propertyOrdering\": [\"reasoning\", \"is_shown\", \"comment_text\"],\n  \"properties\": {\n    \"reasoning\": {\n      \"type\": \"string\"\n    },\n    \"is_shown\": {\n      \"type\": \"string\"\n    },\n    \"comment_text\": {\n      \"type\": \"string\"\n    }\n  }\n}\n";
                } else if (!$this$askWhatCommentToAdd_u24lambda_u240) {
                    v0 = this.getSystemPrompt();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                modifiedSystemPrompt = v0;
                chat = ChatRecipesKt.customChat((PSString)contextPrompt, (PSString)ConstantsKt.getPrivacyConst((String)modifiedSystemPrompt));
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = context;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)contextPrompt);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)modifiedSystemPrompt);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)chat);
                $continuation.Z$0 = force;
                $continuation.label = 1;
                v1 = UtilsKt.call(project, WhatClient.whatPromptId, chat, null, null, Boxing.boxLong((long)42L), (Continuation<? super String>)$continuation);
                if (v1 == var17_7) {
                    return var17_7;
                }
                ** GOTO lbl77
            }
            case 1: {
                force = $continuation.Z$0;
                chat = (List)$continuation.L$4;
                modifiedSystemPrompt = (String)$continuation.L$3;
                contextPrompt = (PSString)$continuation.L$2;
                context = (WhatClientContextCollector.Context)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl77:
                // 2 sources

                v2 = (String)v1;
                if (v2 == null) {
                    return null;
                }
                outputText = v2;
                return this.extractComment(outputText, context.getInsightRange(), context.getIndent());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final InsightModel extractComment(String response, InsightRange insightRange, String indent) {
        block19: {
            block18: {
                block17: {
                    block16: {
                        jsonText = UtilsKt.removeCodeFences(StringsKt.lines((CharSequence)response));
                        $this$singleOrNull$iv = jsonText;
                        $i$f$singleOrNull = false;
                        single$iv = null;
                        found$iv = false;
                        var11_17 = $this$singleOrNull$iv.iterator();
                        while (var11_17.hasNext()) {
                            element$iv = var11_17.next();
                            it = (String)element$iv;
                            $i$a$-singleOrNull-WhatClient$extractComment$isShown$1 = false;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"is_shown", (boolean)false, (int)2, null)) continue;
                            if (found$iv) {
                                v0 = null;
                                break block16;
                            }
                            single$iv = element$iv;
                            found$iv = true;
                        }
                        v0 = found$iv == false ? null : single$iv;
                    }
                    v1 = v0;
                    v2 = isShown = v1 != null ? StringsKt.contains$default((CharSequence)v1, (CharSequence)"true", (boolean)false, (int)2, null) : false;
                    if (!isShown) {
                        return null;
                    }
                    $this$singleOrNull$iv = jsonText;
                    $i$f$singleOrNull = false;
                    single$iv = null;
                    found$iv = false;
                    element$iv = $this$singleOrNull$iv.iterator();
                    while (element$iv.hasNext()) {
                        element$iv = element$iv.next();
                        it = (String)element$iv;
                        $i$a$-singleOrNull-WhatClient$extractComment$reasoning$1 = false;
                        if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"reasoning", (boolean)false, (int)2, null)) continue;
                        if (found$iv) {
                            v3 = null;
                            break block17;
                        }
                        single$iv = (String)element$iv;
                        found$iv = true;
                    }
                    v3 = found$iv == false ? null : single$iv;
                }
                $this$singleOrNull$iv = v3;
                if ($this$singleOrNull$iv == null) ** GOTO lbl-1000
                $this$singleOrNull$iv = StringsKt.trim((CharSequence)((CharSequence)$this$singleOrNull$iv)).toString();
                if ($this$singleOrNull$iv != null && ($i$f$singleOrNull = StringsKt.removePrefix((String)$this$singleOrNull$iv, (CharSequence)"\"reasoning\": \"")) != null && (single$iv = StringsKt.removeSuffix((String)$i$f$singleOrNull, (CharSequence)"\",")) != null) {
                    v4 = StringsKt.trim((CharSequence)single$iv).toString();
                } else lbl-1000:
                // 2 sources

                {
                    v4 = v5 = null;
                }
                if (v4 == null) {
                    v5 = "";
                }
                reasoning = v5;
                $this$singleOrNull$iv = jsonText;
                $i$f$singleOrNull = false;
                single$iv = null;
                found$iv = false;
                for (E element$iv : $this$singleOrNull$iv) {
                    it = (String)element$iv;
                    $i$a$-singleOrNull-WhatClient$extractComment$insightContent$1 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"comment_text", (boolean)false, (int)2, null)) continue;
                    if (found$iv) {
                        v6 = null;
                        break block18;
                    }
                    single$iv = (String)element$iv;
                    found$iv = true;
                }
                v6 = found$iv == false ? null : single$iv;
            }
            $this$singleOrNull$iv = v6;
            if ($this$singleOrNull$iv == null) ** GOTO lbl-1000
            var9_11 = StringsKt.trim((CharSequence)((CharSequence)$this$singleOrNull$iv)).toString();
            if (var9_11 != null && ($i$f$singleOrNull = StringsKt.removePrefix((String)var9_11, (CharSequence)"\"comment_text\": \"")) != null && (single$iv = StringsKt.removeSuffix((String)$i$f$singleOrNull, (CharSequence)"\"")) != null && (found$iv = StringsKt.removeSuffix((String)single$iv, (CharSequence)"\",")) != null) {
                v7 = StringsKt.trim((CharSequence)found$iv).toString();
            } else lbl-1000:
            // 2 sources

            {
                v7 = null;
            }
            insightContent = v7;
            $this$singleOrNull$iv = jsonText;
            $i$f$singleOrNull = false;
            single$iv = null;
            found$iv = false;
            for (T element$iv : $this$singleOrNull$iv) {
                it = (String)element$iv;
                $i$a$-singleOrNull-WhatClient$extractComment$type$1 = false;
                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"type", (boolean)false, (int)2, null)) continue;
                if (found$iv) {
                    v8 = null;
                    break block19;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v8 = found$iv == false ? null : single$iv;
        }
        var9_11 = v8;
        if (var9_11 == null) ** GOTO lbl-1000
        var10_16 = StringsKt.trim((CharSequence)var9_11).toString();
        if (var10_16 != null && (var11_21 = StringsKt.removePrefix((String)var10_16, (CharSequence)"\"type\": \"")) != null && (var12_25 = StringsKt.removeSuffix((String)var11_21, (CharSequence)"\"")) != null) {
            v9 = StringsKt.trim((CharSequence)var12_25).toString();
        } else lbl-1000:
        // 2 sources

        {
            v9 = null;
        }
        type = v9;
        return new InsightModel(indent + insightContent, reasoning, insightRange, type);
    }

    public static final /* synthetic */ Object access$askWhatCommentToAdd(WhatClient $this, Project project2, WhatClientContextCollector.Context context2, boolean force, Continuation $completion) {
        return $this.askWhatCommentToAdd(project2, context2, force, (Continuation<? super InsightModel>)$completion);
    }
}

