/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider.client.context;

import com.intellij.ml.llm.daemon.insight.handler.provider.InsightsBannedRanges;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightRequest;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightWorkingRange;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\t\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0087@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/context/WhereClientContextCollector;", "", "<init>", "()V", "collect", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/context/WhereClientContextCollector$Context;", "request", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightRequest;", "(Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightRequest;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Context", "Parameters", "intellij.ml.llm.daemon"})
public final class WhereClientContextCollector {
    @NotNull
    public static final WhereClientContextCollector INSTANCE = new WhereClientContextCollector();

    private WhereClientContextCollector() {
    }

    @RequiresBackgroundThread
    @Nullable
    public final Object collect(@NotNull InsightRequest request2, @NotNull Continuation<? super Context> $completion) {
        return CoroutinesKt.readAction(() -> WhereClientContextCollector.collect$lambda$0(request2), $completion);
    }

    private static final Context collect$lambda$0(InsightRequest $request) {
        int startLine = Math.max(0, $request.getWorkingRange().getFirstLine() - 7);
        int endLine = Math.min($request.getDocument().getLineCount() - 1, $request.getWorkingRange().getLastLine() + 20);
        int startOffset = $request.getDocument().getLineStartOffset(startLine);
        int endOffset = $request.getDocument().getLineEndOffset(endLine);
        Set<Integer> bannedLinesInWorkingRange = InsightsBannedRanges.Companion.getInstance($request.getProject()).getBannedIn($request.getDocument(), $request.getWorkingRange());
        String string = $request.getDocument().getText(new TextRange(startOffset, endOffset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new Context(StringsKt.lines((CharSequence)string), startLine, $request.getWorkingRange(), bannedLinesInWorkingRange);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0003J=\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/context/WhereClientContextCollector$Context;", "", "fragmentLines", "", "", "fragmentStartLine", "", "workingRange", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "bannedLinesInWorkingRange", "", "<init>", "(Ljava/util/List;ILcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;Ljava/util/Set;)V", "getFragmentLines", "()Ljava/util/List;", "getFragmentStartLine", "()I", "getWorkingRange", "()Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "getBannedLinesInWorkingRange", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.ml.llm.daemon"})
    public static final class Context {
        @NotNull
        private final List<String> fragmentLines;
        private final int fragmentStartLine;
        @NotNull
        private final InsightWorkingRange workingRange;
        @NotNull
        private final Set<Integer> bannedLinesInWorkingRange;

        public Context(@NotNull List<String> fragmentLines, int fragmentStartLine, @NotNull InsightWorkingRange workingRange, @NotNull Set<Integer> bannedLinesInWorkingRange) {
            Intrinsics.checkNotNullParameter(fragmentLines, (String)"fragmentLines");
            Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
            Intrinsics.checkNotNullParameter(bannedLinesInWorkingRange, (String)"bannedLinesInWorkingRange");
            this.fragmentLines = fragmentLines;
            this.fragmentStartLine = fragmentStartLine;
            this.workingRange = workingRange;
            this.bannedLinesInWorkingRange = bannedLinesInWorkingRange;
        }

        @NotNull
        public final List<String> getFragmentLines() {
            return this.fragmentLines;
        }

        public final int getFragmentStartLine() {
            return this.fragmentStartLine;
        }

        @NotNull
        public final InsightWorkingRange getWorkingRange() {
            return this.workingRange;
        }

        @NotNull
        public final Set<Integer> getBannedLinesInWorkingRange() {
            return this.bannedLinesInWorkingRange;
        }

        @NotNull
        public final List<String> component1() {
            return this.fragmentLines;
        }

        public final int component2() {
            return this.fragmentStartLine;
        }

        @NotNull
        public final InsightWorkingRange component3() {
            return this.workingRange;
        }

        @NotNull
        public final Set<Integer> component4() {
            return this.bannedLinesInWorkingRange;
        }

        @NotNull
        public final Context copy(@NotNull List<String> fragmentLines, int fragmentStartLine, @NotNull InsightWorkingRange workingRange, @NotNull Set<Integer> bannedLinesInWorkingRange) {
            Intrinsics.checkNotNullParameter(fragmentLines, (String)"fragmentLines");
            Intrinsics.checkNotNullParameter((Object)workingRange, (String)"workingRange");
            Intrinsics.checkNotNullParameter(bannedLinesInWorkingRange, (String)"bannedLinesInWorkingRange");
            return new Context(fragmentLines, fragmentStartLine, workingRange, bannedLinesInWorkingRange);
        }

        public static /* synthetic */ Context copy$default(Context context2, List list, int n, InsightWorkingRange insightWorkingRange, Set set, int n2, Object object) {
            if ((n2 & 1) != 0) {
                list = context2.fragmentLines;
            }
            if ((n2 & 2) != 0) {
                n = context2.fragmentStartLine;
            }
            if ((n2 & 4) != 0) {
                insightWorkingRange = context2.workingRange;
            }
            if ((n2 & 8) != 0) {
                set = context2.bannedLinesInWorkingRange;
            }
            return context2.copy(list, n, insightWorkingRange, set);
        }

        @NotNull
        public String toString() {
            return "Context(fragmentLines=" + this.fragmentLines + ", fragmentStartLine=" + this.fragmentStartLine + ", workingRange=" + this.workingRange + ", bannedLinesInWorkingRange=" + this.bannedLinesInWorkingRange + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.fragmentLines).hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.fragmentStartLine);
            result2 = result2 * 31 + this.workingRange.hashCode();
            result2 = result2 * 31 + ((Object)this.bannedLinesInWorkingRange).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            if (!Intrinsics.areEqual(this.fragmentLines, context2.fragmentLines)) {
                return false;
            }
            if (this.fragmentStartLine != context2.fragmentStartLine) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.workingRange, (Object)context2.workingRange)) {
                return false;
            }
            return Intrinsics.areEqual(this.bannedLinesInWorkingRange, context2.bannedLinesInWorkingRange);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/client/context/WhereClientContextCollector$Parameters;", "", "<init>", "()V", "CONTEXT_PREFIX_LINES", "", "CONTEXT_SUFFIX_LINES", "intellij.ml.llm.daemon"})
    private static final class Parameters {
        @NotNull
        public static final Parameters INSTANCE = new Parameters();
        public static final int CONTEXT_PREFIX_LINES = 7;
        public static final int CONTEXT_SUFFIX_LINES = 20;

        private Parameters() {
        }
    }
}

