/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.provider.postprocessing;

import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache;", "", "<init>", "()V", "cache", "", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache$Key;", "hide", "", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "document", "Lcom/intellij/openapi/editor/Document;", "isHidden", "", "getKey", "Key", "Companion", "intellij.ml.llm.daemon"})
public final class InsightsHiddenCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<Key> cache;
    private static final int PREFIX_LINES = 10;
    private static final int SUFFIX_LINES = 10;

    public InsightsHiddenCache() {
        ConcurrentHashMap.KeySetView keySetView = ConcurrentHashMap.newKeySet();
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"newKeySet(...)");
        this.cache = keySetView;
    }

    public final void hide(@NotNull InsightModel insight, @NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Key key = this.getKey(insight, document2);
        if (key == null) {
            return;
        }
        Key key2 = key;
        this.cache.add(key2);
    }

    public final boolean isHidden(@NotNull InsightModel insight, @NotNull Document document2) {
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Key key = this.getKey(insight, document2);
        if (key == null) {
            return false;
        }
        Key key2 = key;
        return this.cache.contains(key2);
    }

    private final Key getKey(InsightModel insight, Document document2) {
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(document2);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        String string = virtualFile3.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path = string;
        String string2 = document2.getText(new TextRange(document2.getLineStartOffset(Math.max(insight.getRange().getStartLine() - 10, 0)), document2.getLineStartOffset(insight.getRange().getStartLine())));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String prefix = string2;
        String string3 = document2.getText(new TextRange(document2.getLineStartOffset(insight.getRange().getStartLine()), document2.getLineEndOffset(insight.getRange().getEndLine())));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String target = string3;
        String string4 = document2.getText(new TextRange(document2.getLineEndOffset(insight.getRange().getEndLine()), document2.getLineEndOffset(Math.min(insight.getRange().getEndLine() + 10, document2.getLineCount() - 1))));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        String suffix = string4;
        return new Key(path, prefix, target, suffix);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache;", "project", "Lcom/intellij/openapi/project/Project;", "PREFIX_LINES", "", "SUFFIX_LINES", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightsHiddenCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightsHiddenCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,52:1\n30#2,2:53\n*S KotlinDebug\n*F\n+ 1 InsightsHiddenCache.kt\ncom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache$Companion\n*L\n47#1:53,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsightsHiddenCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<InsightsHiddenCache> serviceClass$iv = InsightsHiddenCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (InsightsHiddenCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/provider/postprocessing/InsightsHiddenCache$Key;", "", "path", "", "prefix", "target", "suffix", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "getPrefix", "getTarget", "getSuffix", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.daemon"})
    private static final class Key {
        @NotNull
        private final String path;
        @NotNull
        private final String prefix;
        @NotNull
        private final String target;
        @NotNull
        private final String suffix;

        public Key(@NotNull String path, @NotNull String prefix, @NotNull String target, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            this.path = path;
            this.prefix = prefix;
            this.target = target;
            this.suffix = suffix;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        @NotNull
        public final String getPrefix() {
            return this.prefix;
        }

        @NotNull
        public final String getTarget() {
            return this.target;
        }

        @NotNull
        public final String getSuffix() {
            return this.suffix;
        }

        @NotNull
        public final String component1() {
            return this.path;
        }

        @NotNull
        public final String component2() {
            return this.prefix;
        }

        @NotNull
        public final String component3() {
            return this.target;
        }

        @NotNull
        public final String component4() {
            return this.suffix;
        }

        @NotNull
        public final Key copy(@NotNull String path, @NotNull String prefix, @NotNull String target, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
            return new Key(path, prefix, target, suffix);
        }

        public static /* synthetic */ Key copy$default(Key key, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = key.path;
            }
            if ((n & 2) != 0) {
                string2 = key.prefix;
            }
            if ((n & 4) != 0) {
                string3 = key.target;
            }
            if ((n & 8) != 0) {
                string4 = key.suffix;
            }
            return key.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "Key(path=" + this.path + ", prefix=" + this.prefix + ", target=" + this.target + ", suffix=" + this.suffix + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.prefix.hashCode();
            result2 = result2 * 31 + this.target.hashCode();
            result2 = result2 * 31 + this.suffix.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)key.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.prefix, (Object)key.prefix)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target, (Object)key.target)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.suffix, (Object)key.suffix);
        }
    }
}

