/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.handler.request;

import com.intellij.ml.llm.daemon.insight.handler.request.InsightViewport;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "", "firstLine", "", "lastLine", "<init>", "(II)V", "getFirstLine", "()I", "getLastLine", "containsLine", "", "value", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "Companion", "intellij.ml.llm.daemon"})
public final class InsightWorkingRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int firstLine;
    private final int lastLine;
    private static final int MAX_SEARCH_DISTANCE = 20;

    public InsightWorkingRange(int firstLine, int lastLine) {
        this.firstLine = firstLine;
        this.lastLine = lastLine;
    }

    public final int getFirstLine() {
        return this.firstLine;
    }

    public final int getLastLine() {
        return this.lastLine;
    }

    public final boolean containsLine(int value2) {
        int n = this.firstLine;
        return value2 < this.lastLine ? n <= value2 : false;
    }

    public final int component1() {
        return this.firstLine;
    }

    public final int component2() {
        return this.lastLine;
    }

    @NotNull
    public final InsightWorkingRange copy(int firstLine, int lastLine) {
        return new InsightWorkingRange(firstLine, lastLine);
    }

    public static /* synthetic */ InsightWorkingRange copy$default(InsightWorkingRange insightWorkingRange, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = insightWorkingRange.firstLine;
        }
        if ((n3 & 2) != 0) {
            n2 = insightWorkingRange.lastLine;
        }
        return insightWorkingRange.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "InsightWorkingRange(firstLine=" + this.firstLine + ", lastLine=" + this.lastLine + ")";
    }

    public int hashCode() {
        int result2 = Integer.hashCode(this.firstLine);
        result2 = result2 * 31 + Integer.hashCode(this.lastLine);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InsightWorkingRange)) {
            return false;
        }
        InsightWorkingRange insightWorkingRange = (InsightWorkingRange)other;
        if (this.firstLine != insightWorkingRange.firstLine) {
            return false;
        }
        return this.lastLine == insightWorkingRange.lastLine;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001c\u0010\f\u001a\u00020\u0005*\u00020\t2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0014\u0010\u0010\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0003J\u001c\u0010\u0012\u001a\u00020\u0005*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0003J\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\u0005*\u00020\t2\u0006\u0010\u001a\u001a\u00020\u0005H\u0003\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange$Companion;", "", "<init>", "()V", "MAX_SEARCH_DISTANCE", "", "create", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange;", "document", "Lcom/intellij/openapi/editor/Document;", "viewport", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightViewport;", "findNonBlankLine", "startLine", "goDown", "", "findBestStart", "start", "findBestEnd", "end", "startIndent", "indent", "line", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "indentOfLineNumber", "lineNumber", "(Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Integer;", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightWorkingRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightWorkingRange.kt\ncom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,98:1\n648#2,5:99\n*S KotlinDebug\n*F\n+ 1 InsightWorkingRange.kt\ncom/intellij/ml/llm/daemon/insight/handler/request/InsightWorkingRange$Companion\n*L\n85#1:99,5\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresReadLock
        @NotNull
        public final InsightWorkingRange create(@NotNull Document document2, @NotNull InsightViewport viewport) {
            Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
            Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
            String string = document2.getText(new TextRange(document2.getLineStartOffset(viewport.getFirstLine()), document2.getLineEndOffset(viewport.getLastLine())));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String fragmentText = string;
            if (StringsKt.isBlank((CharSequence)fragmentText)) {
                return new InsightWorkingRange(viewport.getFirstLine(), viewport.getLastLine());
            }
            int nonBlankFirst = this.findNonBlankLine(document2, viewport.getFirstLine(), true);
            int nonBlankLast = this.findNonBlankLine(document2, viewport.getLastLine(), false);
            int first = this.findBestStart(document2, nonBlankFirst);
            Integer n = this.indentOfLineNumber(document2, first);
            Intrinsics.checkNotNull((Object)n);
            int last = this.findBestEnd(document2, nonBlankLast, n);
            return new InsightWorkingRange(first, last);
        }

        @RequiresReadLock
        private final int findNonBlankLine(Document $this$findNonBlankLine, int startLine, boolean goDown) {
            int curLine = startLine;
            while (true) {
                TextRange curLineTextRange = new TextRange($this$findNonBlankLine.getLineStartOffset(curLine), $this$findNonBlankLine.getLineEndOffset(curLine));
                String string = $this$findNonBlankLine.getText(curLineTextRange);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (!StringsKt.isBlank((CharSequence)string)) break;
                curLine += goDown ? 1 : -1;
            }
            return curLine;
        }

        @RequiresReadLock
        private final int findBestStart(Document $this$findBestStart, int start2) {
            Integer n = this.indentOfLineNumber($this$findBestStart, start2);
            Intrinsics.checkNotNull((Object)n);
            int startIndent = n;
            int cur = start2;
            for (int i = 1; i < 21; ++i) {
                Integer curIndent = this.indentOfLineNumber($this$findBestStart, cur);
                if (curIndent != null && curIndent < startIndent) {
                    return cur;
                }
                if (cur == 0) break;
                --cur;
            }
            return start2;
        }

        @RequiresReadLock
        private final int findBestEnd(Document $this$findBestEnd, int end, int startIndent) {
            Integer curIndent;
            Integer n = this.indentOfLineNumber($this$findBestEnd, end);
            Intrinsics.checkNotNull((Object)n);
            int endIndent = n;
            int cur = end;
            for (int i = 1; i < 21 && ((curIndent = this.indentOfLineNumber($this$findBestEnd, cur)) == null || curIndent >= endIndent || curIndent >= startIndent) && cur != $this$findBestEnd.getLineCount() - 1; ++cur, ++i) {
            }
            return cur;
        }

        /*
         * WARNING - void declaration
         */
        private final Integer indent(String line) {
            String string;
            block2: {
                void var2_2;
                if (StringsKt.isBlank((CharSequence)line)) {
                    return null;
                }
                String $this$takeWhile$iv = line;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char p0 = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl = false;
                    if (CharsKt.isWhitespace((char)p0)) continue;
                    String string2 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string3 = string2.substring(n2, index$iv);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block2;
                }
                string = var2_2;
            }
            return string.length();
        }

        @RequiresReadLock
        private final Integer indentOfLineNumber(Document $this$indentOfLineNumber, int lineNumber) {
            String string = $this$indentOfLineNumber.getText(new TextRange($this$indentOfLineNumber.getLineStartOffset(lineNumber), $this$indentOfLineNumber.getLineEndOffset(lineNumber)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            return this.indent(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

