/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.MLLlmIcons;
import com.intellij.ml.llm.core.AIAssistantBranding;
import com.intellij.ml.llm.core.settings.LLMDataSharingManager;
import com.intellij.ml.llm.daemon.MLLlmDaemonIcons;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.rating.InsightRating;
import com.intellij.ml.llm.daemon.insight.ui.BackgroundHighlighter;
import com.intellij.ml.llm.daemon.insight.ui.FeedbackPanel;
import com.intellij.ml.llm.daemon.insight.ui.InsightMenu;
import com.intellij.ml.llm.daemon.insight.ui.InsightRenderTextBlock;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020'2\n\u0010(\u001a\u0006\u0012\u0002\b\u00030)J\u0006\u0010*\u001a\u00020+J\u0012\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010\u0012H\u0002J\u000e\u0010.\u001a\u00020+2\u0006\u0010&\u001a\u00020'J\f\u0010/\u001a\u00020\"*\u00020'H\u0002J\u000e\u00100\u001a\u0004\u0018\u00010\u0012*\u00020'H\u0002J\u0014\u00101\u001a\u00020\u00192\n\u00102\u001a\u0006\u0012\u0002\b\u00030)H\u0016J,\u00103\u001a\u00020+2\n\u00102\u001a\u0006\u0012\u0002\b\u00030)2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u000209H\u0016J0\u0010:\u001a\u00020+2\u0006\u0010;\u001a\u00020\u00142\u0006\u00104\u001a\u0002052\u0006\u0010<\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u00142\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010A\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u00142\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010B\u001a\u00020?2\u0006\u0010;\u001a\u00020\u00142\u0006\u0010>\u001a\u00020?H\u0002J\u0010\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020?H\u0002J\u0010\u0010E\u001a\u00020?2\u0006\u0010F\u001a\u00020GH\u0002J\f\u0010H\u001a\u00020I*\u00020IH\u0002J\b\u0010J\u001a\u00020+H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;)V", "rating", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "getRating", "()Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating;", "block", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock;", "highlightedRatingButton", "Lcom/intellij/ml/llm/daemon/insight/rating/InsightRating$Rating;", "insightIcon", "Ljavax/swing/Icon;", "insightIconHovered", "optionsIcon", "Lorg/jetbrains/annotations/NotNull;", "iconGap", "", "getIconGap", "()I", "insightIconX", "iconY", "optionsIconX", "likeX", "dislikeX", "hovered", "", "backgroundHighlighter", "Lcom/intellij/ml/llm/daemon/insight/ui/BackgroundHighlighter;", "processHover", "point", "Ljava/awt/Point;", "insightInlay", "Lcom/intellij/openapi/editor/Inlay;", "processOutOfHover", "", "setRatingHighlightedButton", "button", "processClick", "isOpenSettingsArea", "findRatingButtonUnder", "calcWidthInPixels", "inlay", "paint", "g", "Ljava/awt/Graphics;", "targetRegion", "Ljava/awt/Rectangle;", "textAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "doPaintIcon", "icon", "x", "y", "targetHeight", "", "getActualIconWidth", "getActualIconHeight", "getIconScale", "ceilToInt", "value", "getTargetIconHeight", "font", "Ljava/awt/Font;", "formatTabs", "", "dispose", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightElementRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightElementRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,191:1\n648#2,5:192\n648#2,5:197\n*S KotlinDebug\n*F\n+ 1 InsightElementRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer\n*L\n103#1:192,5\n126#1:197,5\n*E\n"})
public final class InsightElementRenderer
implements EditorCustomElementRenderer,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final InsightModel insight;
    @NotNull
    private final InsightRenderTextBlock block;
    @Nullable
    private InsightRating.Rating highlightedRatingButton;
    @NotNull
    private final Icon insightIcon;
    @NotNull
    private final Icon insightIconHovered;
    @NotNull
    private final Icon optionsIcon;
    private int insightIconX;
    private int iconY;
    private int optionsIconX;
    private int likeX;
    private int dislikeX;
    private boolean hovered;
    @NotNull
    private final BackgroundHighlighter backgroundHighlighter;
    private static final float ICON_SCALE_FACTOR = 1.1f;

    public InsightElementRenderer(@NotNull Editor editor2, @NotNull Project project2, @NotNull InsightModel insight) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        this.editor = editor2;
        this.project = project2;
        this.insight = insight;
        this.block = new InsightRenderTextBlock(this.formatTabs(this.insight.getText()), this.editor);
        this.highlightedRatingButton = this.getRating().getRating(this.insight);
        this.insightIcon = AIAssistantBranding.Logo16;
        this.insightIconHovered = AIAssistantBranding.Logo16Colored;
        Icon icon2 = MLLlmDaemonIcons.FluentSettings;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FluentSettings");
        this.optionsIcon = icon2;
        this.insightIconX = -1;
        this.iconY = -1;
        this.optionsIconX = -1;
        this.likeX = -1;
        this.dislikeX = -1;
        this.backgroundHighlighter = new BackgroundHighlighter(this.editor, this.insight, this);
        if (!(this.insightIcon.getIconWidth() == this.insightIconHovered.getIconWidth())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.insightIcon.getIconHeight() == this.insightIconHovered.getIconHeight())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final InsightRating getRating() {
        return InsightRating.Companion.getInstance(this.project);
    }

    private final int getIconGap() {
        return JBUI.scale((int)5);
    }

    public final boolean processHover(@NotNull Point point, @NotNull Inlay<?> insightInlay) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter(insightInlay, (String)"insightInlay");
        this.hovered = true;
        InsightRating.Rating rating = this.findRatingButtonUnder(point);
        if (rating == null) {
            rating = this.getRating().getRating(this.insight);
        }
        this.setRatingHighlightedButton(rating);
        this.backgroundHighlighter.show(insightInlay);
        return this.isOpenSettingsArea(point) || this.findRatingButtonUnder(point) != null;
    }

    public final void processOutOfHover() {
        this.hovered = false;
        this.setRatingHighlightedButton(this.getRating().getRating(this.insight));
        this.backgroundHighlighter.hide();
    }

    private final void setRatingHighlightedButton(InsightRating.Rating button2) {
        if (button2 != this.highlightedRatingButton) {
            this.highlightedRatingButton = button2;
            this.editor.getContentComponent().repaint();
        }
    }

    public final void processClick(@NotNull Point point) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            if (this.isOpenSettingsArea(point)) {
                new InsightMenu(point, this.editor, this.insight, this).show();
            }
            InsightRating.Rating rating = this.findRatingButtonUnder(point);
            if (rating == null) break block1;
            InsightRating.Rating button2 = rating;
            boolean bl = false;
            LLMDataSharingManager.Companion.askDataSharingConsentIfNeeded(this.project);
            this.highlightedRatingButton = button2;
            this.getRating().addRating(this.insight, button2);
            new FeedbackPanel().show(this.editor, this.project, this.insight, button2, point);
        }
    }

    private final boolean isOpenSettingsArea(Point $this$isOpenSettingsArea) {
        int n = this.insightIconX;
        int n2 = this.optionsIconX + this.getActualIconWidth(this.optionsIcon, this.getTargetIconHeight(this.block.getFontType()));
        int n3 = $this$isOpenSettingsArea.x;
        return n <= n3 ? n3 <= n2 : false;
    }

    private final InsightRating.Rating findRatingButtonUnder(Point $this$findRatingButtonUnder) {
        Icon icon2 = MLLlmIcons.Like;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Like");
        int iconWidth = this.getActualIconWidth(icon2, this.getTargetIconHeight(this.block.getFontType()));
        int n = this.likeX;
        int n2 = this.likeX + iconWidth;
        int n3 = $this$findRatingButtonUnder.x;
        boolean bl = n <= n3 ? n3 <= n2 : false;
        if (bl) {
            return InsightRating.Rating.LIKE;
        }
        n = this.dislikeX;
        n2 = this.dislikeX + iconWidth;
        n3 = $this$findRatingButtonUnder.x;
        boolean bl2 = n <= n3 ? n3 <= n2 : false;
        if (bl2) {
            return InsightRating.Rating.DISLIKE;
        }
        return null;
    }

    public int calcWidthInPixels(@NotNull Inlay<?> inlay) {
        String string;
        block1: {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            String $this$takeWhile$iv = this.block.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = $this$takeWhile$iv;
        }
        String blankPrefix = string;
        Font font = this.block.getFontType();
        FontMetrics fontMetrics = this.editor.getContentComponent().getFontMetrics(font);
        float iconTargetHeight = this.getTargetIconHeight(font);
        int n = EditorUtil.getPlainSpaceWidth((Editor)this.editor) * blankPrefix.length() + this.getActualIconWidth(this.insightIcon, iconTargetHeight) + this.getIconGap() + fontMetrics.stringWidth(StringsKt.drop((String)this.block.getText(), (int)blankPrefix.length())) + this.getIconGap() + this.getActualIconWidth(this.optionsIcon, iconTargetHeight) + this.getIconGap();
        Icon icon2 = MLLlmIcons.Like;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Like");
        int n3 = n + this.getActualIconHeight(icon2, iconTargetHeight) + this.getIconGap();
        Icon icon3 = MLLlmIcons.Dislike;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Dislike");
        return n3 + this.getActualIconHeight(icon3, iconTargetHeight);
    }

    public void paint(@NotNull Inlay<?> inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
        String string;
        float targetIconHeight;
        block8: {
            Color color;
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
            Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
            if (((CharSequence)this.block.getText()).length() == 0) {
                return;
            }
            g.setFont(this.block.getFontType());
            if (!this.hovered) {
                color = (Color)this.block.getForegroundColor();
            } else {
                color = inlay.getEditor().getColorsScheme().getAttributes(HighlighterColors.TEXT);
                if (color == null || (color = color.getForegroundColor()) == null) {
                    color = (Color)this.block.getForegroundColor();
                }
            }
            g.setColor(color);
            this.iconY = targetRegion.y + g.getFontMetrics().getDescent();
            Font font = g.getFont();
            Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
            targetIconHeight = this.getTargetIconHeight(font);
            String $this$takeWhile$iv = this.block.getText();
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (CharsKt.isWhitespace((char)it22)) continue;
                String it22 = $this$takeWhile$iv;
                int n2 = 0;
                String string2 = it22.substring(n2, index$iv);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                break block8;
            }
            string = $this$takeWhile$iv;
        }
        String blankPrefix = string;
        this.insightIconX = targetRegion.x + EditorUtil.getPlainSpaceWidth((Editor)this.editor) * blankPrefix.length();
        Icon insightIconToPaint = this.hovered ? this.insightIconHovered : this.insightIcon;
        this.doPaintIcon(insightIconToPaint, g, this.insightIconX, this.iconY, targetIconHeight);
        int textX = this.insightIconX + this.getActualIconWidth(insightIconToPaint, targetIconHeight) + this.getIconGap();
        String renderText = StringsKt.removePrefix((String)this.block.getText(), (CharSequence)blankPrefix);
        g.drawString(renderText, textX, targetRegion.y + this.editor.getAscent());
        this.optionsIconX = textX + g.getFontMetrics().stringWidth(renderText) + this.getIconGap();
        if (this.hovered) {
            this.doPaintIcon(this.optionsIcon, g, this.optionsIconX, this.iconY, targetIconHeight);
        }
        this.likeX = this.optionsIconX + this.getActualIconWidth(this.optionsIcon, targetIconHeight) + this.getIconGap();
        Icon it22 = this.highlightedRatingButton == InsightRating.Rating.LIKE ? MLLlmIcons.LikeSelected : MLLlmIcons.Like;
        Intrinsics.checkNotNull((Object)it22);
        Icon likeIcon = it22;
        if (this.hovered) {
            this.doPaintIcon(likeIcon, g, this.likeX, this.iconY, targetIconHeight);
        }
        Icon icon2 = MLLlmIcons.Dislike;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Dislike");
        this.dislikeX = this.likeX + this.getActualIconWidth(icon2, targetIconHeight) + this.getIconGap();
        Icon icon3 = this.highlightedRatingButton == InsightRating.Rating.DISLIKE ? MLLlmIcons.DislikeSelected : MLLlmIcons.Dislike;
        Intrinsics.checkNotNull((Object)icon3);
        Icon dislikeIcon = icon3;
        if (this.hovered) {
            this.doPaintIcon(dislikeIcon, g, this.dislikeX, this.iconY, targetIconHeight);
        }
    }

    private final void doPaintIcon(Icon icon2, Graphics g, int x, int y, float targetHeight) {
        Icon scaledIcon = IconUtil.scale((Icon)icon2, (Component)this.editor.getContentComponent(), (float)this.getIconScale(icon2, targetHeight));
        scaledIcon.paintIcon(this.editor.getContentComponent(), g, x, y);
    }

    private final int getActualIconWidth(Icon icon2, float targetHeight) {
        return this.ceilToInt((float)icon2.getIconWidth() * this.getIconScale(icon2, targetHeight));
    }

    private final int getActualIconHeight(Icon icon2, float targetHeight) {
        return this.ceilToInt((float)icon2.getIconHeight() * this.getIconScale(icon2, targetHeight));
    }

    private final float getIconScale(Icon icon2, float targetHeight) {
        return targetHeight / (float)icon2.getIconHeight() * 1.1f;
    }

    private final int ceilToInt(float value2) {
        return (int)Math.ceil((double)value2 + 0.01);
    }

    private final float getTargetIconHeight(Font font) {
        return font.getSize2D();
    }

    private final String formatTabs(String $this$formatTabs) {
        int tabSize = this.editor.getSettings().getTabSize(this.editor.getProject());
        String tab = StringsKt.repeat((CharSequence)" ", (int)tabSize);
        return StringsKt.replace$default((String)$this$formatTabs, (String)"\t", (String)tab, (boolean)false, (int)4, null);
    }

    public void dispose() {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer$Companion;", "", "<init>", "()V", "ICON_SCALE_FACTOR", "", "intellij.ml.llm.daemon"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

