/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.ml.llm.daemon.insight.InsightsBundle;
import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.provider.postprocessing.InsightsHiddenCache;
import com.intellij.ml.llm.daemon.insight.ui.InsightMenu;
import com.intellij.ml.llm.daemon.insight.ui.InsightRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightMenu;", "", "position", "Ljava/awt/Point;", "editor", "Lcom/intellij/openapi/editor/Editor;", "insight", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Ljava/awt/Point;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;Lcom/intellij/openapi/Disposable;)V", "show", "", "hideInsight", "copyInsightToClipboard", "convertInsightToComment", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightMenu.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightMenu\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,92:1\n648#2,5:93\n123#3:98\n112#3,5:99\n*S KotlinDebug\n*F\n+ 1 InsightMenu.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightMenu\n*L\n79#1:93,5\n81#1:98\n81#1:99,5\n*E\n"})
public final class InsightMenu {
    @NotNull
    private final Point position;
    @NotNull
    private final Editor editor;
    @NotNull
    private final InsightModel insight;
    @NotNull
    private final Disposable parentDisposable;

    public InsightMenu(@NotNull Point position, @NotNull Editor editor2, @NotNull InsightModel insight, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)insight, (String)"insight");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.position = position;
        this.editor = editor2;
        this.insight = insight;
        this.parentDisposable = parentDisposable;
    }

    @RequiresEdt
    public final void show() {
        Object[] objectArray = new MenuItem[3];
        String string = InsightsBundle.message("insight.menu.insert.as.comment", new Object[0]);
        Icon icon2 = AllIcons.FileTypes.Text;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Text");
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00003\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B'\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J2\u0010\u0014\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0015J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"com/intellij/ml/llm/daemon/insight/ui/InsightMenu$show$MenuItem", "", "text", "", "icon", "Ljavax/swing/Icon;", "action", "Lkotlin/Function0;", "", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)V", "getText", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getAction", "()Lkotlin/jvm/functions/Function0;", "component1", "component2", "component3", "copy", "(Ljava/lang/String;Ljavax/swing/Icon;Lkotlin/jvm/functions/Function0;)Lcom/intellij/ml/llm/daemon/insight/ui/InsightMenu$show$MenuItem;", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.daemon"})
        public final class MenuItem {
            private final String text;
            private final Icon icon;
            private final Function0<Unit> action;

            public MenuItem(@NlsContexts.ListItem String text2, Icon icon2, Function0<Unit> action2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                this.text = text2;
                this.icon = icon2;
                this.action = action2;
            }

            public final String getText() {
                return this.text;
            }

            public final Icon getIcon() {
                return this.icon;
            }

            public final Function0<Unit> getAction() {
                return this.action;
            }

            public final String component1() {
                return this.text;
            }

            public final Icon component2() {
                return this.icon;
            }

            public final Function0<Unit> component3() {
                return this.action;
            }

            public final MenuItem copy(@NlsContexts.ListItem String text2, Icon icon2, Function0<Unit> action2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
                Intrinsics.checkNotNullParameter(action2, (String)"action");
                return new MenuItem(text2, icon2, action2);
            }

            public static /* synthetic */ MenuItem copy$default(MenuItem menuItem, String string, Icon icon2, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    string = menuItem.text;
                }
                if ((n & 2) != 0) {
                    icon2 = menuItem.icon;
                }
                if ((n & 4) != 0) {
                    function0 = menuItem.action;
                }
                return menuItem.copy(string, icon2, function0);
            }

            public String toString() {
                return "MenuItem(text=" + this.text + ", icon=" + this.icon + ", action=" + this.action + ")";
            }

            public int hashCode() {
                int result2 = this.text.hashCode();
                result2 = result2 * 31 + this.icon.hashCode();
                result2 = result2 * 31 + this.action.hashCode();
                return result2;
            }

            public boolean equals(Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof MenuItem)) {
                    return false;
                }
                MenuItem menuItem = (MenuItem)other;
                if (!Intrinsics.areEqual((Object)this.text, (Object)menuItem.text)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.icon, (Object)menuItem.icon)) {
                    return false;
                }
                return Intrinsics.areEqual(this.action, menuItem.action);
            }
        }
        objectArray[0] = new MenuItem(string, icon2, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                InsightMenu.access$convertInsightToComment((InsightMenu)this.receiver);
            }
        }));
        String string2 = InsightsBundle.message("insight.menu.copy.insight", new Object[0]);
        Icon icon3 = AllIcons.Actions.Copy;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Copy");
        objectArray[1] = new MenuItem(string2, icon3, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                InsightMenu.access$copyInsightToClipboard((InsightMenu)this.receiver);
            }
        }));
        String string3 = InsightsBundle.message("insight.menu.hide.insight", new Object[0]);
        Icon icon4 = AllIcons.Actions.Cancel;
        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Cancel");
        objectArray[2] = new MenuItem(string3, icon4, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                InsightMenu.access$hideInsight((InsightMenu)this.receiver);
            }
        }));
        List items2 = CollectionsKt.listOf((Object[])objectArray);
        BaseListPopupStep<MenuItem> step2 = new BaseListPopupStep<MenuItem>((List<MenuItem>)items2){
            {
                super(null, $items);
            }

            public PopupStep<?> onChosen(MenuItem selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                selectedValue.getAction().invoke();
                return BaseListPopupStep.FINAL_CHOICE;
            }

            public String getTextFor(MenuItem value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return value2.getText();
            }

            public Icon getIconFor(MenuItem value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                return value2.getIcon();
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        ListPopup popup2 = listPopup;
        popup2.setAdText(InsightsBundle.message("insight.menu.ad.text", new Object[0]), 2);
        Disposer.register((Disposable)this.parentDisposable, () -> InsightMenu.show$lambda$0(popup2));
        popup2.show(new RelativePoint((Component)this.editor.getContentComponent(), this.position));
    }

    private final void hideInsight() {
        block1: {
            Project project2 = this.editor.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            InsightsHiddenCache insightsHiddenCache = InsightsHiddenCache.Companion.getInstance(project3);
            Document document2 = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            insightsHiddenCache.hide(this.insight, document2);
            InsightRenderer insightRenderer = InsightRenderer.Companion.getOrNull(this.editor);
            if (insightRenderer == null) break block1;
            insightRenderer.hideInsight(this.insight.getId());
        }
    }

    private final void copyInsightToClipboard() {
        String text2 = this.insight.getText();
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(text2));
    }

    /*
     * WARNING - void declaration
     */
    private final void convertInsightToComment() {
        String string;
        int n;
        String $this$takeWhile$iv;
        StringBuilder stringBuilder;
        StringBuilder $this$convertInsightToComment_u24lambda_u240;
        StringBuilder stringBuilder2;
        String blockSuffix;
        String blockPrefix;
        String linePrefix;
        PsiFile psiFile;
        Document document2;
        block9: {
            Commenter commenter;
            Project project2 = this.editor.getProject();
            if (project2 == null) {
                return;
            }
            Project project3 = project2;
            Document document3 = this.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document3, (String)"getDocument(...)");
            document2 = document3;
            PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)project3).getPsiFile(document2);
            if (psiFile2 == null) {
                return;
            }
            psiFile = psiFile2;
            Commenter commenter2 = commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(psiFile.getLanguage());
            String string2 = commenter2 != null ? commenter2.getLineCommentPrefix() : null;
            if (string2 == null) {
                string2 = "";
            }
            linePrefix = string2;
            Commenter commenter3 = commenter;
            String string3 = commenter3 != null ? commenter3.getBlockCommentPrefix() : null;
            if (string3 == null) {
                string3 = "";
            }
            blockPrefix = string3;
            Commenter commenter4 = commenter;
            String string4 = commenter4 != null ? commenter4.getBlockCommentSuffix() : null;
            if (string4 == null) {
                string4 = "";
            }
            blockSuffix = string4;
            $this$convertInsightToComment_u24lambda_u240 = stringBuilder2 = new StringBuilder();
            boolean bl = false;
            String string5 = this.insight.getText();
            stringBuilder = $this$convertInsightToComment_u24lambda_u240;
            boolean $i$f$takeWhile = false;
            int n2 = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it22 = $this$takeWhile$iv.charAt(index$iv);
                boolean bl2 = false;
                if (CharsKt.isWhitespace((char)it22)) continue;
                void it22 = $this$takeWhile$iv;
                n = 0;
                String string6 = it22.substring(n, index$iv);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
                break block9;
            }
            string = $this$takeWhile$iv;
        }
        stringBuilder.append(string);
        if (!StringsKt.isBlank((CharSequence)linePrefix)) {
            CharSequence charSequence;
            block10: {
                void $this$trimStart$iv;
                $this$takeWhile$iv = this.insight.getText();
                stringBuilder = $this$convertInsightToComment_u24lambda_u240.append(linePrefix).append(' ');
                boolean $i$f$trimStart = false;
                CharSequence $this$trimStart$iv$iv = (CharSequence)$this$trimStart$iv;
                boolean $i$f$trimStart2 = false;
                n = $this$trimStart$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char it = $this$trimStart$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (CharsKt.isWhitespace((char)it)) continue;
                    charSequence = $this$trimStart$iv$iv.subSequence(index$iv$iv, $this$trimStart$iv$iv.length());
                    break block10;
                }
                charSequence = "";
            }
            v12 = stringBuilder.append(((Object)charSequence).toString()).append('\n');
        } else {
            v12 = $this$convertInsightToComment_u24lambda_u240.append(blockPrefix).append(' ').append(this.insight.getText()).append(' ').append(blockSuffix).append('\n');
        }
        String commentedText = stringBuilder2.toString();
        WriteCommandAction.writeCommandAction((PsiFile)psiFile, (PsiFile[])new PsiFile[0]).run(() -> InsightMenu.convertInsightToComment$lambda$1(document2, this, commentedText));
    }

    private static final void show$lambda$0(ListPopup $popup) {
        $popup.cancel();
    }

    private static final void convertInsightToComment$lambda$1(Document $document, InsightMenu this$0, String $commentedText) {
        $document.insertString($document.getLineStartOffset(this$0.insight.getRange().getStartLine()), (CharSequence)$commentedText);
    }

    public static final /* synthetic */ void access$convertInsightToComment(InsightMenu $this) {
        $this.convertInsightToComment();
    }

    public static final /* synthetic */ void access$copyInsightToClipboard(InsightMenu $this) {
        $this.copyInsightToClipboard();
    }

    public static final /* synthetic */ void access$hideInsight(InsightMenu $this) {
        $this.hideInsight();
    }
}

