/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Font;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0012\u001a\u0004\u0018\u00010\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0013\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock;", "", "text", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/editor/Editor;)V", "getText", "()Ljava/lang/String;", "fontType", "Ljava/awt/Font;", "getFontType", "()Ljava/awt/Font;", "foregroundColor", "Lcom/intellij/ui/JBColor;", "getForegroundColor", "()Lcom/intellij/ui/JBColor;", "defaultFont", "getDefaultFont", "defaultFont$delegate", "Lkotlin/Lazy;", "doGetFont", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightRenderTextBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderTextBlock.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,33:1\n1#2:34\n1855#3,2:35\n*S KotlinDebug\n*F\n+ 1 InsightRenderTextBlock.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderTextBlock\n*L\n21#1:35,2\n*E\n"})
public final class InsightRenderTextBlock {
    @NotNull
    private final String text;
    @NotNull
    private final Editor editor;
    @NotNull
    private final JBColor foregroundColor;
    @NotNull
    private final Lazy defaultFont$delegate;

    public InsightRenderTextBlock(@NotNull String text2, @NotNull Editor editor2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            this.text = text2;
            this.editor = editor2;
            this.foregroundColor = new JBColor(8027781, 0x808080);
            if (!(!StringsKt.isBlank((CharSequence)this.text))) {
                boolean $i$a$-require-InsightRenderTextBlock$22 = false;
                String $i$a$-require-InsightRenderTextBlock$22 = "Text cannot be blank";
                throw new IllegalArgumentException($i$a$-require-InsightRenderTextBlock$22.toString());
            }
            CharSequence $this$none$iv = this.text;
            boolean $i$f$none = false;
            for (int i = 0; i < $this$none$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$none$iv.charAt(i);
                boolean bl2 = false;
                if (!(it == '\n' || it == '\r')) continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Text cannot contain newlines";
            throw new IllegalArgumentException(string.toString());
        }
        this.defaultFont$delegate = LazyKt.lazy(InsightRenderTextBlock::defaultFont_delegate$lambda$0);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final Font getFontType() {
        return this.doGetFont();
    }

    @NotNull
    public final JBColor getForegroundColor() {
        return this.foregroundColor;
    }

    private final Font getDefaultFont() {
        Lazy lazy = this.defaultFont$delegate;
        return (Font)lazy.getValue();
    }

    private final Font doGetFont() {
        Font font = this.editor.getColorsScheme().getFont(EditorFontType.PLAIN);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        Font editorFont = font;
        Font font2 = this.getDefaultFont();
        if (font2 == null || (font2 = font2.deriveFont(editorFont.getSize2D())) == null) {
            font2 = editorFont;
        }
        Font baseFont = font2;
        Font font3 = UIUtil.getFontWithFallbackIfNeeded((Font)baseFont, (String)this.text);
        Intrinsics.checkNotNullExpressionValue((Object)font3, (String)"getFontWithFallbackIfNeeded(...)");
        return font3;
    }

    private static final Font defaultFont_delegate$lambda$0() {
        Font font;
        String string = UISettings.Companion.getInstance().getFontFace();
        if (string != null) {
            String it = string;
            boolean bl = false;
            font = new Font(it, 0, 13);
        } else {
            font = null;
        }
        return font;
    }
}

