/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.daemon.insight.ui;

import com.intellij.ml.llm.daemon.insight.handler.InsightModel;
import com.intellij.ml.llm.daemon.insight.handler.request.InsightEvent;
import com.intellij.ml.llm.daemon.insight.ui.InsightElementRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\bH\u0007J\u0018\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0002J$\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J$\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\u0010H\u0002J\b\u0010 \u001a\u00020\u000bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "current", "", "", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Rendering;", "update", "", "request", "Lcom/intellij/ml/llm/daemon/insight/handler/request/InsightEvent;", "insights", "", "Lcom/intellij/ml/llm/daemon/insight/handler/InsightModel;", "processHover", "point", "Ljava/awt/Point;", "processClick", "hideInsight", "insightId", "findInlayUnder", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "removeInvalidated", "removeNoRelevantFromWorkingRange", "event", "addNew", "addInsight", "insight", "hideAll", "Rendering", "Companion", "intellij.ml.llm.daemon"})
@SourceDebugExtension(value={"SMAP\nInsightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,136:1\n19#2:137\n126#3:138\n153#3,3:139\n216#3,2:161\n774#4:142\n865#4,2:143\n1869#4,2:145\n504#5,7:147\n488#5,7:154\n*S KotlinDebug\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer\n*L\n40#1:137\n41#1:138\n41#1:139,3\n86#1:161,2\n41#1:142\n41#1:143,2\n41#1:145,2\n56#1:147,7\n86#1:154,7\n*E\n"})
public final class InsightRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Map<Long, Rendering> current;
    private static final int INLAY_PRIORITY = 1000;
    @NotNull
    private static final Key<InsightRenderer> key;

    public InsightRenderer(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        this.editor = editor2;
        this.current = new LinkedHashMap();
    }

    @RequiresEdt
    public final void update(@NotNull InsightEvent request2, @NotNull Map<Long, InsightModel> insights) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
        Intrinsics.checkNotNullParameter(insights, (String)"insights");
        boolean bl2 = bl = this.editor == request2.getEditor();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.removeInvalidated();
        this.removeNoRelevantFromWorkingRange(request2, insights);
        this.addNew(request2, insights);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void processHover(@NotNull Point point) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        InsightElementRenderer it;
        void $this$mapTo$iv$iv;
        InsightElementRenderer renderer2;
        Inlay<InsightElementRenderer> insightInlay;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Inlay<InsightElementRenderer> inlay = insightInlay = this.findInlayUnder(point);
        InsightElementRenderer insightElementRenderer = renderer2 = inlay != null ? (InsightElementRenderer)inlay.getRenderer() : null;
        boolean isButtonUnder = insightElementRenderer != null ? insightElementRenderer.processHover(point, insightInlay) : false;
        Cursor cursor = isButtonUnder ? Cursor.getPredefinedCursor(12) : (renderer2 != null ? Cursor.getPredefinedCursor(0) : null);
        Editor $this$asSafely$iv = this.editor;
        boolean $i$f$asSafely22 = false;
        Editor editor2 = $this$asSafely$iv;
        if (!(editor2 instanceof EditorEx)) {
            editor2 = null;
        }
        EditorEx editorEx = (EditorEx)editor2;
        if (editorEx != null) {
            editorEx.setCustomCursor(InsightRenderer.class, cursor);
        }
        Object $this$map$iv = this.current;
        boolean $i$f$map = false;
        Map<Long, Rendering> $i$f$asSafely22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((InsightElementRenderer)((Rendering)it.getValue()).getInlay().getRenderer());
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Map.Entry element$iv$iv : $this$filterTo$iv$iv) {
            it = (InsightElementRenderer)((Object)element$iv$iv);
            boolean bl = false;
            if (!(it != renderer2)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            InsightElementRenderer it2 = (InsightElementRenderer)element$iv;
            boolean bl = false;
            it2.processOutOfHover();
        }
    }

    @RequiresEdt
    public final void processClick(@NotNull Point point) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            Object object = this.findInlayUnder(point);
            if (object == null || (object = (InsightElementRenderer)object.getRenderer()) == null) break block0;
            ((InsightElementRenderer)object).processClick(point);
        }
    }

    @RequiresEdt
    public final void hideInsight(long insightId) {
        Rendering rendering = this.current.remove(insightId);
        if (rendering == null) {
            return;
        }
        Rendering rendering2 = rendering;
        Disposer.dispose((Disposable)((Disposable)rendering2.getInlay()));
    }

    private final Inlay<InsightElementRenderer> findInlayUnder(Point point) {
        Map<Long, Rendering> $this$filterValues$iv = this.current;
        boolean $i$f$filterValues = false;
        LinkedHashMap<Long, Rendering> result$iv = new LinkedHashMap<Long, Rendering>();
        for (Map.Entry<Long, Rendering> entry$iv : $this$filterValues$iv.entrySet()) {
            Rendering it = entry$iv.getValue();
            boolean bl = false;
            Rectangle rectangle = it.getInlay().getBounds();
            boolean bl2 = rectangle != null ? rectangle.contains(point) : false;
            if (!bl2) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Rendering rendering = (Rendering)CollectionsKt.firstOrNull((Iterable)((Map)result$iv).values());
        return rendering != null ? rendering.getInlay() : null;
    }

    private final void removeInvalidated() {
        Iterator<Map.Entry<Long, Rendering>> iter = this.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            if (current.getValue().getInlay().isValid()) continue;
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)current.getValue().getInlay()));
        }
    }

    private final void removeNoRelevantFromWorkingRange(InsightEvent event2, Map<Long, InsightModel> insights) {
        Iterator<Map.Entry<Long, Rendering>> iter = this.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            int lineNumber = event2.getDocument().getLineNumber(current.getValue().getInlay().getOffset());
            if (!event2.getWorkingRange().containsLine(lineNumber) || insights.containsKey(current.getKey())) continue;
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)current.getValue().getInlay()));
        }
    }

    private final void addNew(InsightEvent event2, Map<Long, InsightModel> insights) {
        Map<Long, InsightModel> $this$filterKeys$iv = insights;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<Long, InsightModel> result$iv = new LinkedHashMap<Long, InsightModel>();
        for (Map.Entry<Long, InsightModel> entry$iv : $this$filterKeys$iv.entrySet()) {
            long it = ((Number)entry$iv.getKey()).longValue();
            boolean bl = false;
            if (!(!this.current.containsKey(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map $this$forEach$iv = result$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            this.addInsight(event2, (InsightModel)it.getValue());
        }
    }

    private final void addInsight(InsightEvent event2, InsightModel insight) {
        InsightElementRenderer renderer2 = new InsightElementRenderer(event2.getEditor(), event2.getProject(), insight);
        Inlay inlay = event2.getEditor().getInlayModel().addBlockElement(event2.getDocument().getLineEndOffset(insight.getRange().getStartLine()), false, true, 1000, (EditorCustomElementRenderer)renderer2);
        if (inlay == null) {
            return;
        }
        Inlay inlay2 = inlay;
        Disposer.register((Disposable)((Disposable)inlay2), (Disposable)renderer2);
        this.current.put(insight.getId(), new Rendering((Inlay<InsightElementRenderer>)inlay2));
    }

    @RequiresEdt
    public final void hideAll() {
        Iterator<Map.Entry<Long, Rendering>> iter = this.current.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Long, Rendering> current = iter.next();
            iter.remove();
            Disposer.dispose((Disposable)((Disposable)current.getValue().getInlay()));
        }
    }

    static {
        Key key = Key.create((String)"InsightRenderer");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        InsightRenderer.key = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Companion;", "", "<init>", "()V", "INLAY_PRIORITY", "", "key", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getOrCreate", "editor", "Lcom/intellij/openapi/editor/Editor;", "getOrNull", "intellij.ml.llm.daemon"})
    @SourceDebugExtension(value={"SMAP\nInsightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InsightRenderer.kt\ncom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,136:1\n1#2:137\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        @NotNull
        public final InsightRenderer getOrCreate(@NotNull Editor editor2) {
            InsightRenderer insightRenderer;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            InsightRenderer insightRenderer2 = (InsightRenderer)editor2.getUserData(key);
            if (insightRenderer2 != null) {
                InsightRenderer it = insightRenderer2;
                boolean bl = false;
                return it;
            }
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.getOrCreate$lambda$1(editor2));
            InsightRenderer it = insightRenderer = new InsightRenderer(editor2);
            boolean bl = false;
            editor2.putUserData(key, (Object)it);
            return insightRenderer;
        }

        @RequiresEdt
        @Nullable
        public final InsightRenderer getOrNull(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (InsightRenderer)editor2.getUserData(key);
        }

        private static final void getOrCreate$lambda$1(Editor $editor) {
            $editor.putUserData(key, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\n\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/daemon/insight/ui/InsightRenderer$Rendering;", "", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/ml/llm/daemon/insight/ui/InsightElementRenderer;", "<init>", "(Lcom/intellij/openapi/editor/Inlay;)V", "getInlay", "()Lcom/intellij/openapi/editor/Inlay;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.daemon"})
    private static final class Rendering {
        @NotNull
        private final Inlay<InsightElementRenderer> inlay;

        public Rendering(@NotNull Inlay<InsightElementRenderer> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            this.inlay = inlay;
        }

        @NotNull
        public final Inlay<InsightElementRenderer> getInlay() {
            return this.inlay;
        }

        @NotNull
        public final Inlay<InsightElementRenderer> component1() {
            return this.inlay;
        }

        @NotNull
        public final Rendering copy(@NotNull Inlay<InsightElementRenderer> inlay) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            return new Rendering(inlay);
        }

        public static /* synthetic */ Rendering copy$default(Rendering rendering, Inlay inlay, int n, Object object) {
            if ((n & 1) != 0) {
                inlay = rendering.inlay;
            }
            return rendering.copy(inlay);
        }

        @NotNull
        public String toString() {
            return "Rendering(inlay=" + this.inlay + ")";
        }

        public int hashCode() {
            return this.inlay.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rendering)) {
                return false;
            }
            Rendering rendering = (Rendering)other;
            return Intrinsics.areEqual(this.inlay, rendering.inlay);
        }
    }
}

