/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.domains.ide.commands;

import com.intellij.ml.llm.core.chat.session.ChatSession;
import com.intellij.ml.llm.core.chat.session.ChatSessionStorage;
import com.intellij.ml.llm.domains.DomainProvider;
import com.intellij.ml.llm.domains.commands.LLMDomainCommand;
import com.intellij.ml.llm.domains.context.DomainItemContext;
import com.intellij.ml.llm.domains.ide.commands.CommandChooserPopup;
import com.intellij.ml.llm.domains.ide.commands.CommandPromptComputationKt;
import com.intellij.ml.llm.domains.ide.utils.LlmContexProviderSearchKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.popup.list.ListPopupImpl;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ml/llm/domains/ide/commands/RunCommandForSelectionAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.ml.llm.domains.ide"})
public final class RunCommandForSelectionAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext2);
        if (project2 == null) {
            return;
        }
        Project project3 = project2;
        ChatSession chatSession = (ChatSession)CollectionsKt.lastOrNull((List)ChatSessionStorage.Companion.getInstance(project3).getChatSessions());
        if (chatSession == null) {
            return;
        }
        ChatSession randomChatSession = chatSession;
        DataContext dataContext3 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext3, (String)"getDataContext(...)");
        List<DomainItemContext> selectedItems = LlmContexProviderSearchKt.findLlmItemContexts(dataContext3);
        Collection<DomainProvider<?>> selectedProviders = LlmContexProviderSearchKt.findLlmItemContextProviders(e.getDataContext());
        Function1 promptComputation = arg_0 -> RunCommandForSelectionAction.actionPerformed$lambda$0(selectedItems, arg_0);
        new ListPopupImpl(project3, (ListPopupStep)new CommandChooserPopup(selectedProviders, promptComputation, randomChatSession, project3, null, 16, null)).showInBestPositionFor(e.getDataContext());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!Registry.Companion.is("domains.show.in.services")) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        DataContext dataContext2 = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        List<DomainItemContext> selectedItems = LlmContexProviderSearchKt.findLlmItemContexts(dataContext2);
        Collection<DomainProvider<?>> selectedProviders = LlmContexProviderSearchKt.findLlmItemContextProviders(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(!((Collection)selectedItems).isEmpty() || !selectedProviders.isEmpty());
    }

    private static final String actionPerformed$lambda$0(List $selectedItems, LLMDomainCommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return CommandPromptComputationKt.computePromptForCommand(command, $selectedItems);
    }
}

