/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.agents.export;

import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.ds.agents.base.DataSpellAgentOneShotContext;
import com.intellij.ml.llm.ds.agents.base.DataSpellAgentOneShotWithHistorySupport;
import com.intellij.ml.llm.ds.agents.base.tools.DataSpellTool;
import com.intellij.ml.llm.ds.agents.export.ExportAgentContext;
import com.intellij.ml.llm.ds.agents.export.model.SelectedFileModel;
import com.intellij.ml.llm.ds.agents.export.tools.ConvertJupyterToFormatTool;
import com.intellij.ml.llm.ds.agents.export.tools.ConvertJupyterToPythonTool;
import com.intellij.ml.llm.ds.agents.export.tools.ConvertPythonToJupyterTool;
import com.intellij.ml.llm.ds.agents.export.tools.ExportDataTool;
import com.intellij.ml.llm.ds.agents.export.tools.ExportTableByInfoTool;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\u00100\u0005H\u0014R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/ds/agents/export/ExportAgentSupport;", "Lcom/intellij/ml/llm/ds/agents/base/DataSpellAgentOneShotWithHistorySupport;", "Lcom/intellij/ml/llm/ds/agents/export/ExportAgentContext;", "context", "history", "", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "<init>", "(Lcom/intellij/ml/llm/ds/agents/export/ExportAgentContext;Ljava/util/List;)V", "clientAgentName", "", "getClientAgentName", "()Ljava/lang/String;", "systemPrompt", "getSystemPrompt", "createTools", "Lcom/intellij/ml/llm/ds/agents/base/tools/DataSpellTool;", "Companion", "intellij.ml.llm.ds"})
public final class ExportAgentSupport
extends DataSpellAgentOneShotWithHistorySupport<ExportAgentContext> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXPORT_AGENT_NAME = "ai-agents_dataspell_export";

    public ExportAgentSupport(@NotNull ExportAgentContext context2, @NotNull List<? extends ChatMessage> history) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(history, (String)"history");
        super((DataSpellAgentOneShotContext)context2, history);
    }

    @Override
    @NotNull
    protected String getClientAgentName() {
        return EXPORT_AGENT_NAME;
    }

    @Override
    @NotNull
    protected String getSystemPrompt() {
        String string;
        SelectedFileModel selectedFileModel = ((ExportAgentContext)this.getContext()).getExportModel().getSelectedFile();
        if (selectedFileModel != null) {
            SelectedFileModel it = selectedFileModel;
            boolean bl = false;
            string = "\n      The user has a currently open file: " + it.getName() + ".\n\n      When handling an export operation, do not include filePath in the export tool if any of the following is true:\n      - The user did not specify a source file,\n      - The user indicated they want to use the current file as the source,\n      - The user explicitly mentioned " + it.getName() + " (with or without its extension).\n\n      In this case, the currently open file will be used for an export operation.\n      ";
        } else {
            string = null;
        }
        return StringsKt.trimIndent((String)("\n      You are an agent who helps users export data.\n      There are several tools that allow exporting jupyter notebooks, SQL tables or data into different formats.\n      \n      You will receive a user request and, using the tools, must perform actions that best fulfill the user's request.\n      \n      You MUST operate with tools, not offer text solutions in the result.\n      You MUST perform the user's task with maximum accuracy.\n      \n      " + string + "\n      \n      If you have not applied any actions, include an explanation in your response to the user, stating why you cannot generate a non-empty sequence of actions for their request.\n    "));
    }

    @Override
    @NotNull
    protected List<DataSpellTool<ExportAgentContext, ?>> createTools() {
        DataSpellTool[] dataSpellToolArray = new DataSpellTool[]{new ConvertJupyterToPythonTool((ExportAgentContext)this.getContext()), new ConvertJupyterToFormatTool((ExportAgentContext)this.getContext()), new ConvertPythonToJupyterTool((ExportAgentContext)this.getContext()), new ExportTableByInfoTool((ExportAgentContext)this.getContext()), new ExportDataTool((ExportAgentContext)this.getContext())};
        return CollectionsKt.listOf((Object[])dataSpellToolArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/ds/agents/export/ExportAgentSupport$Companion;", "", "<init>", "()V", "EXPORT_AGENT_NAME", "", "intellij.ml.llm.ds"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

