/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.chat.history;

import com.intellij.ml.llm.core.chat.messages.CancelledState;
import com.intellij.ml.llm.core.chat.messages.ChatMessage;
import com.intellij.ml.llm.core.chat.messages.ErrorState;
import com.intellij.ml.llm.core.chat.messages.MessageState;
import com.intellij.ml.llm.core.chat.messages.ReadyState;
import com.intellij.ml.llm.core.chat.messages.UserMessage;
import com.intellij.ml.llm.ds.agents.DataSpellAgentType;
import com.intellij.ml.llm.ds.chat.message.DataSpellChatMessage;
import com.intellij.ml.llm.ds.chat.message.DataSpellChatMessageType;
import com.intellij.openapi.util.registry.Registry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001c\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\u0014\u0010\u0014\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u001e\u0010\u0015\u001a\u0004\u0018\u00010\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\rJ\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0010H\u0002J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/ds/chat/history/DataSpellChatHistoryHandler;", "", "<init>", "()V", "UNLIMITED_HISTORY_SIZE", "", "CANCELED_MESSAGE_CONTENT", "", "ERROR_MESSAGE_CONTENT", "UNAVAILABILITY_MESSAGE_CONTENT", "SOLUTION_MESSAGE_CONTENT", "UNKNOWN_MESSAGE_CONTENT", "findPreviousAgentType", "Lcom/intellij/ml/llm/ds/agents/DataSpellAgentType;", "fullHistory", "", "Lcom/intellij/ml/llm/core/chat/messages/ChatMessage;", "agentUserHistorySize", "history", "agentType", "userHistorySize", "buildAgentHistoryText", "buildMessageText", "message", "takeAgentHistory", "adjustHistory", "intellij.ml.llm.ds"})
@SourceDebugExtension(value={"SMAP\nDataSpellChatHistoryHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSpellChatHistoryHandler.kt\ncom/intellij/ml/llm/ds/chat/history/DataSpellChatHistoryHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,91:1\n1788#2,4:92\n967#2,7:96\n1#3:103\n*S KotlinDebug\n*F\n+ 1 DataSpellChatHistoryHandler.kt\ncom/intellij/ml/llm/ds/chat/history/DataSpellChatHistoryHandler\n*L\n29#1:92,4\n82#1:96,7\n*E\n"})
public final class DataSpellChatHistoryHandler {
    @NotNull
    public static final DataSpellChatHistoryHandler INSTANCE = new DataSpellChatHistoryHandler();
    private static final int UNLIMITED_HISTORY_SIZE = -1;
    @NotNull
    private static final String CANCELED_MESSAGE_CONTENT = "<canceled>";
    @NotNull
    private static final String ERROR_MESSAGE_CONTENT = "<error>";
    @NotNull
    private static final String UNAVAILABILITY_MESSAGE_CONTENT = "<unavailability>";
    @NotNull
    private static final String SOLUTION_MESSAGE_CONTENT = "<solution>";
    @NotNull
    private static final String UNKNOWN_MESSAGE_CONTENT = "<unknown>";

    private DataSpellChatHistoryHandler() {
    }

    @Nullable
    public final DataSpellAgentType findPreviousAgentType(@NotNull List<? extends ChatMessage> fullHistory) {
        Intrinsics.checkNotNullParameter(fullHistory, (String)"fullHistory");
        Object object = CollectionsKt.firstOrNull(fullHistory);
        DataSpellChatMessage dataSpellChatMessage = object instanceof DataSpellChatMessage ? (DataSpellChatMessage)object : null;
        if (dataSpellChatMessage == null) {
            return null;
        }
        DataSpellChatMessage previousMessage = dataSpellChatMessage;
        return previousMessage.getAgentType();
    }

    public final int agentUserHistorySize(@NotNull List<? extends ChatMessage> history, @NotNull DataSpellAgentType agentType) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        Intrinsics.checkNotNullParameter((Object)((Object)agentType), (String)"agentType");
        return this.userHistorySize(this.takeAgentHistory(history, agentType));
    }

    public final int userHistorySize(@NotNull List<? extends ChatMessage> history) {
        int n;
        Intrinsics.checkNotNullParameter(history, (String)"history");
        Iterable $this$count$iv = history;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                ChatMessage it = (ChatMessage)element$iv;
                boolean bl = false;
                if (!(it instanceof UserMessage) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return n;
    }

    @Nullable
    public final String buildAgentHistoryText(@NotNull List<? extends ChatMessage> history, @NotNull DataSpellAgentType agentType) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        Intrinsics.checkNotNullParameter((Object)((Object)agentType), (String)"agentType");
        List<ChatMessage> agentHistory = this.takeAgentHistory(history, agentType);
        List<ChatMessage> adjustedAgentHistory = this.adjustHistory(agentHistory);
        if (adjustedAgentHistory.isEmpty()) {
            return null;
        }
        return StringsKt.trimIndent((String)("\n      The history contains previous messages exchanged between the user and the " + agentType + " agent, listed from most recent to oldest.\n      \n      History format description:\n      1. User and " + agentType + " agent messages alternate.\n      2. Messages start with \"----- user:\" for user messages and \"----- " + agentType + ":\" for " + agentType + " agent messages.\n      3. If a message was sent by the " + agentType + " agent, it starts with the " + agentType + " followed by a colon and the message content (e.g., " + agentType + ": <agent message content>).\n      4. If a message was sent by the user, it has no prefix (e.g., <user message content>).\n      5. In some cases, instead of the actual message content, one of the following placeholders is used:\n          - <canceled> \u2014 the message content does not exist because its sending or processing was canceled.\n          - <error> \u2014 the message content does not exist due to an error during sending or creation.\n          - <solution> \u2014 the message content contains a solution to the user\u2019s task.\n          - <unavailability> \u2014 the message contains a reason why the agent is unavailable to perform the task.\n          - <unknown> \u2014 the message content doesn\u2019t matter or is unavailable for unknown reasons.\n          \n      History:    \n      *** history start ***\n      \n      " + CollectionsKt.joinToString$default((Iterable)adjustedAgentHistory, (CharSequence)"\n\n      ", null, null, (int)0, null, DataSpellChatHistoryHandler::buildAgentHistoryText$lambda$0, (int)30, null) + "\n      \n      *** history end ***    \n      "));
    }

    private final String buildMessageText(ChatMessage message) {
        String string;
        Object agentType;
        block9: {
            block11: {
                MessageState messageState;
                DataSpellChatMessage agentMessage2;
                block10: {
                    block8: {
                        if (message instanceof UserMessage) {
                            return "----- user:\n      " + ((Object)StringsKt.trim((CharSequence)((String)message.getText().unwrap()))).toString();
                        }
                        agentMessage2 = message instanceof DataSpellChatMessage ? (DataSpellChatMessage)message : null;
                        Object object = agentMessage2;
                        if (object == null || (object = object.getAgentType()) == null) {
                            object = agentType = DataSpellAgentType.MAIN;
                        }
                        if (!((messageState = message.getState()) instanceof CancelledState)) break block8;
                        string = CANCELED_MESSAGE_CONTENT;
                        break block9;
                    }
                    if (!(messageState instanceof ErrorState)) break block10;
                    string = ERROR_MESSAGE_CONTENT;
                    break block9;
                }
                if (!(messageState instanceof ReadyState)) break block11;
                DataSpellChatMessage dataSpellChatMessage = agentMessage2;
                DataSpellChatMessageType dataSpellChatMessageType = dataSpellChatMessage != null ? dataSpellChatMessage.getType() : null;
                switch (dataSpellChatMessageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[dataSpellChatMessageType.ordinal()]) {
                    case 1: {
                        string = UNAVAILABILITY_MESSAGE_CONTENT;
                        break block9;
                    }
                    case 2: {
                        string = SOLUTION_MESSAGE_CONTENT;
                        break block9;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        string = ((Object)StringsKt.trim((CharSequence)((String)message.getText().unwrap()))).toString();
                        break block9;
                    }
                    case -1: {
                        string = UNKNOWN_MESSAGE_CONTENT;
                        break block9;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            string = UNKNOWN_MESSAGE_CONTENT;
        }
        String messageContent = string;
        return "----- " + (DataSpellAgentType)((Object)agentType) + ":\n      " + messageContent;
    }

    private final List<ChatMessage> takeAgentHistory(List<? extends ChatMessage> fullHistory, DataSpellAgentType agentType) {
        Iterable $this$takeWhile$iv = fullHistory;
        boolean $i$f$takeWhile = false;
        ArrayList list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            ChatMessage it = (ChatMessage)item$iv;
            boolean bl = false;
            if (!(it instanceof UserMessage || it instanceof DataSpellChatMessage && ((DataSpellChatMessage)it).getAgentType() == agentType)) break;
            list$iv.add(item$iv);
        }
        return list$iv;
    }

    private final List<ChatMessage> adjustHistory(List<? extends ChatMessage> history) {
        Object object;
        if (history.isEmpty()) {
            return history;
        }
        Object object2 = this;
        try {
            DataSpellChatHistoryHandler $this$adjustHistory_u24lambda_u240 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)Registry.Companion.get("llm.dataspell.agent.historySize").asInteger());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = -1;
        int historySize = ((Number)(Result.isFailure-impl((Object)object2) ? object : object2)).intValue();
        if (historySize == -1) {
            return history;
        }
        return historySize > 0 ? history.subList(0, RangesKt.coerceAtMost((int)historySize, (int)history.size())) : CollectionsKt.emptyList();
    }

    private static final CharSequence buildAgentHistoryText$lambda$0(ChatMessage it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return INSTANCE.buildMessageText(it);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DataSpellChatMessageType.values().length];
            try {
                nArray[DataSpellChatMessageType.UNAVAILABILITY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSpellChatMessageType.SOLUTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSpellChatMessageType.COMMUNICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSpellChatMessageType.QUESTION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DataSpellChatMessageType.REFUSAL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

