/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.dataspell.llm.ExportFormat;
import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.ExportAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.ExistingFileModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.SelectedFileModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.operations.ExportOperation;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ConvertJupyterToFormatTool$Args$;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.FileUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0018R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentContext;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool$Args;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentContext;)V", "nameToFormatMap", "", "", "Lcom/intellij/dataspell/llm/ExportFormat;", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "description", "getDescription", "()Ljava/lang/String;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "args", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "intellij.ml.llm.ds.next"})
@SourceDebugExtension(value={"SMAP\nConvertJupyterToFormatTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertJupyterToFormatTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,81:1\n1208#2,2:82\n1236#2,4:84\n37#3,2:88\n*S KotlinDebug\n*F\n+ 1 ConvertJupyterToFormatTool.kt\ncom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool\n*L\n26#1:82,2\n26#1:84,4\n51#1:88,2\n*E\n"})
public final class ConvertJupyterToFormatTool
extends DataSpellNextTool<ExportAgentContext, Args> {
    @NotNull
    private final Map<String, ExportFormat> nameToFormatMap;
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private final String description;

    /*
     * WARNING - void declaration
     */
    public ConvertJupyterToFormatTool(@NotNull ExportAgentContext context2) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellNextAgentContext)context2);
        Iterable iterable = context2.getExportModel().getJupyterExportFormats();
        ConvertJupyterToFormatTool convertJupyterToFormatTool = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var5_6 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            ExportFormat exportFormat = (ExportFormat)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getTitle(), element$iv$iv);
        }
        convertJupyterToFormatTool.nameToFormatMap = destination$iv$iv;
        this.argsSerializer = Args.Companion.serializer();
        this.description = "Convert a Jupyter notebook to a specified format.\nThe user may provide an absolute file to the file. If no path is provided, the currently open ipynb file will be converted if any.\nThe original notebook file is not modified.";
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        Collection $this$toTypedArray$iv = this.nameToFormatMap.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new ToolDescriptor("convert_jupyter_to_format", this.getDescription(), CollectionsKt.listOf((Object)new ToolParameterDescriptor("format_name", "The target format to convert the notebook to. Must be one of the supported formats.", (ToolParameterType)new ToolParameterType.Enum(thisCollection$iv.toArray(new String[0])))), CollectionsKt.listOf((Object)new ToolParameterDescriptor("file_path", "Optional: The absolute path to the Jupyter notebook file to convert. If path not provided, the currently open ipynb file will be converted if any.", (ToolParameterType)ToolParameterType.String.INSTANCE)));
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Args args, @NotNull Continuation<? super String> $completion) {
        SelectedFileModel selectedFile;
        String formatName = args.getFormatName();
        ExportFormat format = this.nameToFormatMap.get(formatName);
        if (format == null) {
            return "Failure: Format named \"" + formatName + "\" not found.";
        }
        String filePath = args.getFilePath();
        Either<String, ExistingFileModel> fileEither = FileUtils.INSTANCE.findExistingFile(filePath, selectedFile = ((ExportAgentContext)this.getContext()).getExportModel().getSelectedFile(), "ipynb");
        if (fileEither.isLeft()) {
            Object object = fileEither.getLeft();
            Intrinsics.checkNotNull((Object)object);
            return object;
        }
        Object object = fileEither.getRight();
        Intrinsics.checkNotNull((Object)object);
        ExistingFileModel file = (ExistingFileModel)object;
        ((ExportAgentContext)this.getContext()).addOperation(new ExportOperation.ConvertJupyterToFormat(file, format));
        return "Success";
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\bH\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"R\u001c\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0010\u0010\r\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006%"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool$Args;", "Lai/koog/agents/core/tools/ToolArgs;", "formatName", "", "filePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFormatName$annotations", "()V", "getFormatName", "()Ljava/lang/String;", "getFilePath$annotations", "getFilePath", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_ds_next", "$serializer", "Companion", "intellij.ml.llm.ds.next"})
    public static final class Args
    implements ToolArgs {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String formatName;
        @Nullable
        private final String filePath;

        public Args(@NotNull String formatName, @Nullable String filePath) {
            Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
            this.formatName = formatName;
            this.filePath = filePath;
        }

        @NotNull
        public final String getFormatName() {
            return this.formatName;
        }

        @SerialName(value="format_name")
        public static /* synthetic */ void getFormatName$annotations() {
        }

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }

        @SerialName(value="file_path")
        public static /* synthetic */ void getFilePath$annotations() {
        }

        @NotNull
        public final String component1() {
            return this.formatName;
        }

        @Nullable
        public final String component2() {
            return this.filePath;
        }

        @NotNull
        public final Args copy(@NotNull String formatName, @Nullable String filePath) {
            Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
            return new Args(formatName, filePath);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.formatName;
            }
            if ((n & 2) != 0) {
                string2 = args.filePath;
            }
            return args.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Args(formatName=" + this.formatName + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            int result2 = this.formatName.hashCode();
            result2 = result2 * 31 + (this.filePath == null ? 0 : this.filePath.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            if (!Intrinsics.areEqual((Object)this.formatName, (Object)args.formatName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePath, (Object)args.filePath);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_ds_next(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.formatName);
            output.encodeNullableSerializableElement(serialDesc, 1, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.filePath);
        }

        public /* synthetic */ Args(int seen0, String formatName, String filePath, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.formatName = formatName;
            this.filePath = filePath;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertJupyterToFormatTool$Args;", "intellij.ml.llm.ds.next"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

