/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools;

import ai.koog.agents.core.tools.ToolArgs;
import ai.koog.agents.core.tools.ToolDescriptor;
import ai.koog.agents.core.tools.ToolParameterDescriptor;
import ai.koog.agents.core.tools.ToolParameterType;
import com.intellij.database.dataSource.connection.Either;
import com.intellij.ml.llm.ds.next.agents.impl.DataSpellNextAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.base.tools.DataSpellNextTool;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.ExportAgentContext;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.ExistingFileModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.model.SelectedFileModel;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.operations.ExportOperation;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.ConvertPythonToJupyterTool$Args$;
import com.intellij.ml.llm.ds.next.agents.impl.executors.export.tools.FileUtils;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0016B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0096@\u00a2\u0006\u0002\u0010\u0015R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertPythonToJupyterTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/base/tools/DataSpellNextTool;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentContext;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertPythonToJupyterTool$Args;", "context", "<init>", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/ExportAgentContext;)V", "argsSerializer", "Lkotlinx/serialization/KSerializer;", "getArgsSerializer", "()Lkotlinx/serialization/KSerializer;", "description", "", "getDescription", "()Ljava/lang/String;", "descriptor", "Lai/koog/agents/core/tools/ToolDescriptor;", "getDescriptor", "()Lai/koog/agents/core/tools/ToolDescriptor;", "doExecuteImpl", "args", "(Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertPythonToJupyterTool$Args;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Args", "intellij.ml.llm.ds.next"})
public final class ConvertPythonToJupyterTool
extends DataSpellNextTool<ExportAgentContext, Args> {
    @NotNull
    private final KSerializer<Args> argsSerializer;
    @NotNull
    private final String description;

    public ConvertPythonToJupyterTool(@NotNull ExportAgentContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super((DataSpellNextAgentContext)context2);
        this.argsSerializer = Args.Companion.serializer();
        this.description = "Convert a Python file to a Jupyter notebook.\nThe user may provide an absolute file to the file. If no path is provided, the currently open Python file will be converted if any.\nThe original Python file is not modified.";
    }

    @NotNull
    public KSerializer<Args> getArgsSerializer() {
        return this.argsSerializer;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    @NotNull
    public ToolDescriptor getDescriptor() {
        return new ToolDescriptor("convert_python_to_jupyter", this.getDescription(), CollectionsKt.emptyList(), CollectionsKt.listOf((Object)new ToolParameterDescriptor("file_path", "Optional: The absolute path to the Python file to convert. If path not provided, the currently open Python file will be converted if any.", (ToolParameterType)ToolParameterType.String.INSTANCE)));
    }

    @Override
    @Nullable
    public Object doExecuteImpl(@NotNull Args args, @NotNull Continuation<? super String> $completion) {
        SelectedFileModel selectedFile;
        String filePath = args.getFilePath();
        Either<String, ExistingFileModel> sourceFileEither = FileUtils.INSTANCE.findExistingFile(filePath, selectedFile = ((ExportAgentContext)this.getContext()).getExportModel().getSelectedFile(), "py");
        if (sourceFileEither.isLeft()) {
            Object object = sourceFileEither.getLeft();
            Intrinsics.checkNotNull((Object)object);
            return object;
        }
        Object object = sourceFileEither.getRight();
        Intrinsics.checkNotNull((Object)object);
        ExistingFileModel sourceFile = (ExistingFileModel)object;
        String targetFileName = FileUtils.INSTANCE.generateTargetFileName(sourceFile, "ipynb");
        ((ExportAgentContext)this.getContext()).addOperation(new ExportOperation.ConvertJupyterToPython(sourceFile, targetFileName));
        return "Success";
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0015\u0010\u0010\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u001e\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006!"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertPythonToJupyterTool$Args;", "Lai/koog/agents/core/tools/ToolArgs;", "filePath", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFilePath$annotations", "()V", "getFilePath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_ml_llm_ds_next", "$serializer", "Companion", "intellij.ml.llm.ds.next"})
    public static final class Args
    implements ToolArgs {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String filePath;

        public Args(@Nullable String filePath) {
            this.filePath = filePath;
        }

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }

        @SerialName(value="file_path")
        public static /* synthetic */ void getFilePath$annotations() {
        }

        @Nullable
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final Args copy(@Nullable String filePath) {
            return new Args(filePath);
        }

        public static /* synthetic */ Args copy$default(Args args, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = args.filePath;
            }
            return args.copy(string);
        }

        @NotNull
        public String toString() {
            return "Args(filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            return this.filePath == null ? 0 : this.filePath.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Args)) {
                return false;
            }
            Args args = (Args)other;
            return Intrinsics.areEqual((Object)this.filePath, (Object)args.filePath);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_ml_llm_ds_next(Args self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeNullableSerializableElement(serialDesc, 0, (SerializationStrategy)StringSerializer.INSTANCE, (Object)self.filePath);
        }

        public /* synthetic */ Args(int seen0, String filePath, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)Args$$serializer.INSTANCE.getDescriptor());
            }
            this.filePath = filePath;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertPythonToJupyterTool$Args$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/ml/llm/ds/next/agents/impl/executors/export/tools/ConvertPythonToJupyterTool$Args;", "intellij.ml.llm.ds.next"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<Args> serializer() {
                return (KSerializer)Args$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

