/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.editor.common.progress;

import com.intellij.ml.llm.editor.common.progress.MagicWandManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH$J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0018\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/editor/common/progress/InlineProgressIndicatorController;", "", "<init>", "()V", "managerKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/editor/common/progress/MagicWandManager;", "getManagerKey", "()Lcom/intellij/openapi/util/Key;", "createManager", "editor", "Lcom/intellij/openapi/editor/Editor;", "startIndicator", "", "token", "", "stopIndicator", "isIndicatorActive", "", "installIfNeeded", "intellij.ml.llm.editor.common"})
@SourceDebugExtension(value={"SMAP\nInlineProgressIndicatorController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineProgressIndicatorController.kt\ncom/intellij/ml/llm/editor/common/progress/InlineProgressIndicatorController\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,46:1\n1#2:47\n*E\n"})
public abstract class InlineProgressIndicatorController {
    @NotNull
    protected abstract Key<MagicWandManager> getManagerKey();

    @NotNull
    protected abstract MagicWandManager createManager(@NotNull Editor var1);

    @RequiresEdt
    public final void startIndicator(@NotNull Editor editor2, @NotNull String token) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            this.installIfNeeded(editor2);
            ThreadingAssertions.assertEventDispatchThread();
            MagicWandManager magicWandManager = (MagicWandManager)editor2.getUserData(this.getManagerKey());
            if (magicWandManager == null) break block0;
            magicWandManager.start(token);
        }
    }

    @RequiresEdt
    public final void stopIndicator(@NotNull Editor editor2, @NotNull String token) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            ThreadingAssertions.assertEventDispatchThread();
            MagicWandManager magicWandManager = (MagicWandManager)editor2.getUserData(this.getManagerKey());
            if (magicWandManager == null) break block0;
            magicWandManager.stop(token);
        }
    }

    @RequiresEdt
    public final boolean isIndicatorActive(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        ThreadingAssertions.assertEventDispatchThread();
        MagicWandManager magicWandManager = (MagicWandManager)editor2.getUserData(this.getManagerKey());
        return magicWandManager != null ? magicWandManager.isActive() : false;
    }

    private final void installIfNeeded(Editor editor2) {
        if (editor2.getUserData(this.getManagerKey()) != null) {
            return;
        }
        editor2.putUserData(this.getManagerKey(), (Object)this.createManager(editor2));
        EditorUtil.disposeWithEditor((Editor)editor2, () -> InlineProgressIndicatorController.installIfNeeded$lambda$0(editor2, this));
    }

    private static final void installIfNeeded$lambda$0(Editor $editor, InlineProgressIndicatorController this$0) {
        MagicWandManager magicWandManager = (MagicWandManager)$editor.getUserData(this$0.getManagerKey());
        if (magicWandManager != null) {
            MagicWandManager it = magicWandManager;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
        $editor.putUserData(this$0.getManagerKey(), null);
    }
}

