/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.go.testGeneration;

import com.goide.psi.GoTypeSpec;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.go.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.go.testGeneration.GoTestsPromptBuildUtilKt;
import com.intellij.ml.llm.go.testGeneration.GoTestsPromptGeneratorKt;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.PSStringBackendKt;
import com.intellij.ml.llm.privacy.PSStringConvertible;
import com.intellij.ml.llm.privacy.PSStringKt;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConcatenateBuilder;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.ml.llm.tokenizer.Tokenizer;
import com.intellij.ml.llm.tokenizer.fus.PromptSource;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/go/testGeneration/GoTestsPromptGenerator;", "", "<init>", "()V", "createPrompt", "Lcom/intellij/ml/llm/privacy/PSString;", "target", "Lcom/intellij/psi/PsiElement;", "testFilePath", "Ljava/nio/file/Path;", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "createPromptToCreate", "declarationName", "packageName", "createPromptToModify", "getGuideline", "goSdkVersion", "collectRelatedCode", "declarationDescription", "intellij.ml.llm.go"})
public final class GoTestsPromptGenerator {
    @NotNull
    public static final GoTestsPromptGenerator INSTANCE = new GoTestsPromptGenerator();

    private GoTestsPromptGenerator() {
    }

    @RequiresReadLock
    @NotNull
    public final PSString createPrompt(@NotNull PsiElement target, @NotNull Path testFilePath2, @NotNull Tokenizer tokenizer) {
        PSString pSString;
        VirtualFile virtualFile2;
        VirtualFileSystem virtualFileSystem;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)testFilePath2, (String)"testFilePath");
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Pair<PSString, PSString> pair = GoTestsPromptBuildUtilKt.getPresentableNameAndDescription(target, tokenizer);
        if (pair == null) {
            return ConstantsKt.getPrivacyConst((String)"");
        }
        Pair<PSString, PSString> pair2 = pair;
        PSString declarationName = (PSString)pair2.component1();
        PSString declarationDescription = (PSString)pair2.component2();
        GoSdk goSdk = GoSdkService.getInstance((Project)target.getProject()).getSdk(null);
        Intrinsics.checkNotNullExpressionValue((Object)goSdk, (String)"getSdk(...)");
        PSString goSdkVersion = PSStringKt.orEmpty((PSString)ExtensionsKtKt.getPrivacySafe(goSdk).getVersion());
        PSString pSString2 = ExtensionsKtKt.getPrivacySafe(GoTestsPromptGeneratorKt.getContainingFile(target)).getPackageName();
        if (pSString2 == null) {
            return ConstantsKt.getEMPTY();
        }
        PSString packageName2 = pSString2;
        PSString relatedCode = this.collectRelatedCode(target, declarationDescription, tokenizer);
        Project project2 = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        VirtualFile virtualFile3 = ProjectUtil.guessProjectDir((Project)project2);
        VirtualFileSystem virtualFileSystem2 = virtualFileSystem = virtualFile3 != null ? virtualFile3.getFileSystem() : null;
        VirtualFile virtualFile4 = virtualFile2 = virtualFileSystem2 != null ? virtualFileSystem2.findFileByPath(((Object)testFilePath2.toAbsolutePath()).toString()) : null;
        PSString instructionText = (virtualFile4 != null ? virtualFile4.exists() : false) ? this.createPromptToModify(testFilePath2, declarationName) : this.createPromptToCreate(declarationName, packageName2);
        Project project3 = target.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project3).findPrompt("llm.testGeneration.go");
        PSString customPrompt = aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null ? pSString : ConstantsKt.getEMPTY();
        PSString promptText = PSStringKt.buildStringPrivacySafe(arg_0 -> GoTestsPromptGenerator.createPrompt$lambda$0(instructionText, customPrompt, target, goSdkVersion, relatedCode, arg_0)).trim();
        return PSStringBackendKt.trim(tokenizer, promptText, 3000, PromptSource.GO_TESTS_PROMPT_GENERATOR);
    }

    private final PSString createPromptToCreate(PSString declarationName, PSString packageName2) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{declarationName, packageName2};
        return ConstantsKt.getPrivacyConst((String)"\n      Write enough tests for %s in Go.\n      Put test file to the SAME PACKAGE `%s`. DO NOT add a \"_test\" suffix to the package name.\n      ").format(pSStringConvertibleArray).trimIndent();
    }

    private final PSString createPromptToModify(Path testFilePath2, PSString declarationName) {
        PSString testFileName = SharedExtensionsKtKt.getPrivacySafe((Path)testFilePath2).getName();
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{declarationName, testFileName, declarationName};
        return ConstantsKt.getPrivacyConst((String)"\n      Write enough tests for %s in Go. Append new tests to the currently opened file `%s`.\n      \n      Be consistent with the existing testing code.\n      If there is already an EXISTING test case for %s:\n      - DO NOT DUPLICATE the existing test case!\n      - Consider EXTENDING existing case instead of creating another one.\n    ").format(pSStringConvertibleArray).trimIndent();
    }

    private final PSString getGuideline(PsiElement target, PSString goSdkVersion) {
        PSStringConvertible[] pSStringConvertibleArray = new PSStringConvertible[]{GoTestsPromptGeneratorKt.access$getNamedDuplicatesGuideline(target), goSdkVersion};
        return ConstantsKt.getPrivacyConst((String)"\n     Guideline:\n     - %s\n     - Think about SEVERAL TEST CASES and COVER all possible CORNER CASES.\n     - Code should be COMPLETE and COMPILABLE, without need for further actions.\n     - Ensure that each test focuses on a single use case to maintain CLARITY and READABILITY.\n     - PREFER TABLE DRIVEN TESTS in a single testing function per method or function.\n     - KEEP names of TABLE DRIVEN test cases as SHORT as possible. DO NOT NUMBER test case names.\n     - The project uses Go version %s. Use the same Go version for writing the tests.\n    ").format(pSStringConvertibleArray).trimIndent();
    }

    private final PSString collectRelatedCode(PsiElement target, PSString declarationDescription, Tokenizer tokenizer) {
        List relatedTypes = GoTestsPromptGeneratorKt.access$getRelatedTypes(target);
        return PSStringKt.buildStringPrivacySafe(arg_0 -> GoTestsPromptGenerator.collectRelatedCode$lambda$0(declarationDescription, relatedTypes, tokenizer, arg_0));
    }

    private static final Unit createPrompt$lambda$0(PSString $instructionText, PSString $customPrompt, PsiElement $target, PSString $goSdkVersion, PSString $relatedCode, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        $this$buildStringPrivacySafe.appendLine($instructionText);
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)$this$buildStringPrivacySafe, null, (int)1, null);
        if (((CharSequence)$customPrompt).length() > 0) {
            $this$buildStringPrivacySafe.appendLine($customPrompt);
            ConcatenateBuilder.appendLine$default((ConcatenateBuilder)$this$buildStringPrivacySafe, null, (int)1, null);
        }
        $this$buildStringPrivacySafe.appendLine(INSTANCE.getGuideline($target, $goSdkVersion));
        ConcatenateBuilder.appendLine$default((ConcatenateBuilder)$this$buildStringPrivacySafe, null, (int)1, null);
        $this$buildStringPrivacySafe.appendLine($relatedCode);
        return Unit.INSTANCE;
    }

    private static final Unit collectRelatedCode$lambda$0(PSString $declarationDescription, List $relatedTypes, Tokenizer $tokenizer, ConcatenateBuilder $this$buildStringPrivacySafe) {
        Intrinsics.checkNotNullParameter((Object)$this$buildStringPrivacySafe, (String)"$this$buildStringPrivacySafe");
        $this$buildStringPrivacySafe.appendLine($declarationDescription);
        if (!((Collection)$relatedTypes).isEmpty()) {
            $this$buildStringPrivacySafe.appendLine(ConstantsKt.getPrivacyConst((String)"Following EXISTING declarations below may be useful, but DO NOT COPY them to the test file!"));
            for (GoTypeSpec relatedType : $relatedTypes) {
                $this$buildStringPrivacySafe.appendLine(GoTestsPromptBuildUtilKt.getTypeDescription(relatedType, null, $tokenizer));
            }
        }
        return Unit.INSTANCE;
    }
}

