/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ideolog.highlighting;

import com.intellij.codeInsight.editorLineStripeHint.EditorLineStripeHintComponent;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.ideolog.highlighting.LogHeavyFilterService;
import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import com.intellij.ml.llm.ideolog.explainWithAi.LogEditorLineStripeHintComponentBuilderProvider;
import com.intellij.ml.llm.ideolog.explainWithAi.LogErrorExplainFilter;
import com.intellij.ml.llm.ideolog.explainWithAi.LogErrorExplainFilterFactory;
import com.intellij.ml.llm.ideolog.highlighting.ui.EmptyInlayProvider;
import com.intellij.ml.llm.ideolog.highlighting.ui.LogEditorLineStripeHintComponent;
import com.intellij.ml.llm.ideolog.highlighting.ui.LogInlay;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rH\u0002J \u0010\u001a\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/ideolog/highlighting/AILogHeavyFilterService;", "Lcom/intellij/ideolog/highlighting/LogHeavyFilterService;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "enqueueHeavyFiltering", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "eventOffset", "", "event", "", "enqueueInlayFiltering", "createLogErrorExplainFilter", "Lcom/intellij/execution/filters/Filter;", "processInlays", "inlayProvider", "Lcom/intellij/execution/impl/InlayProvider;", "offset", "isLineEndWithoutInlays", "", "lineEndOffset", "createInlay", "intellij.ml.llm.ideolog"})
@SourceDebugExtension(value={"SMAP\nAILogHeavyFilterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AILogHeavyFilterService.kt\ncom/intellij/ml/llm/ideolog/highlighting/AILogHeavyFilterService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,108:1\n1#2:109\n1869#3,2:110\n1869#3,2:112\n*S KotlinDebug\n*F\n+ 1 AILogHeavyFilterService.kt\ncom/intellij/ml/llm/ideolog/highlighting/AILogHeavyFilterService\n*L\n74#1:110,2\n40#1:112,2\n*E\n"})
public final class AILogHeavyFilterService
extends LogHeavyFilterService {
    @NotNull
    private final Project project;

    public AILogHeavyFilterService(@NotNull Project project2, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        super(project2, cs);
        this.project = project2;
    }

    public void enqueueHeavyFiltering(@NotNull Editor editor2, int eventOffset, @NotNull CharSequence event2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        if (editor2.isDisposed() || editor2.getSettings().isUseSoftWraps()) {
            return;
        }
        this.enqueueInlayFiltering(editor2, eventOffset, event2);
        super.enqueueHeavyFiltering(editor2, eventOffset, event2);
    }

    private final void enqueueInlayFiltering(Editor editor2, int eventOffset, CharSequence event2) {
        int newlineIndex = StringsKt.indexOf$default((CharSequence)event2, (char)'\n', (int)0, (boolean)false, (int)6, null);
        String firstLine = ((Object)(newlineIndex == -1 ? event2 : (CharSequence)((Object)event2.subSequence(0, newlineIndex)).toString())).toString();
        Filter logErrorExplainFilter = this.createLogErrorExplainFilter(editor2, this.project);
        AILogHeavyFilterService.enqueueInlayFiltering$consumeResult(editor2, eventOffset, this, logErrorExplainFilter.applyFilter(firstLine, eventOffset + firstLine.length()), false);
    }

    private final Filter createLogErrorExplainFilter(Editor editor2, Project project2) {
        ErrorExplainFilter errorExplainFilter;
        ErrorExplainFilter $this$createLogErrorExplainFilter_u24lambda_u240 = errorExplainFilter = new LogErrorExplainFilterFactory().createErrorExplainFilter(project2);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$createLogErrorExplainFilter_u24lambda_u240, (String)"null cannot be cast to non-null type com.intellij.ml.llm.ideolog.explainWithAi.LogErrorExplainFilter");
        ((LogErrorExplainFilter)$this$createLogErrorExplainFilter_u24lambda_u240).setEditor(editor2);
        return (Filter)errorExplainFilter;
    }

    private final void processInlays(InlayProvider inlayProvider, Editor editor2, int offset) {
        int $this$processInlays_u24lambda_u240 = editor2.getDocument().getLineNumber(offset);
        boolean bl = false;
        Pair pair = TuplesKt.to((Object)editor2.getDocument().getLineStartOffset($this$processInlays_u24lambda_u240), (Object)editor2.getDocument().getLineEndOffset($this$processInlays_u24lambda_u240));
        int lineStartOffset = ((Number)pair.component1()).intValue();
        int lineEndOffset = ((Number)pair.component2()).intValue();
        if (offset != lineEndOffset) {
            return;
        }
        List list = editor2.getInlayModel().getAfterLineEndElementsInRange(lineStartOffset, lineEndOffset);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAfterLineEndElementsInRange(...)");
        List lineInlays = list;
        if (lineInlays.isEmpty()) {
            this.createInlay(inlayProvider, editor2, offset);
        } else if (this.isLineEndWithoutInlays(editor2, offset, lineEndOffset)) {
            Iterable $this$forEach$iv = lineInlays;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay it = (Inlay)element$iv;
                boolean bl2 = false;
                Disposer.dispose((Disposable)((Disposable)it));
            }
            this.createInlay(inlayProvider, editor2, offset);
        }
    }

    private final boolean isLineEndWithoutInlays(Editor editor2, int offset, int lineEndOffset) {
        return offset == lineEndOffset && editor2.getInlayModel().getAfterLineEndElementsInRange(offset, offset).isEmpty();
    }

    private final void createInlay(InlayProvider inlayProvider, Editor editor2, int offset) {
        Disposable disposable;
        LogEditorLineStripeHintComponentBuilderProvider provider = new LogEditorLineStripeHintComponentBuilderProvider();
        EditorLineStripeHintComponent inlayLineComponent = provider.getBuilder(this.project).build(inlayProvider, editor2, offset);
        Component[] componentArray = inlayLineComponent.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object object = ArraysKt.first((Object[])componentArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ml.llm.ideolog.highlighting.ui.LogEditorLineStripeHintComponent.LogPhantomInlayComponent");
        EmptyInlayProvider emptyInlayProvider = new EmptyInlayProvider(((LogEditorLineStripeHintComponent.LogPhantomInlayComponent)((Object)object)).getPixelWidth() + 16 + editor2.getSettings().getLineCursorWidth());
        Inlay emptyInlay = editor2.getInlayModel().addAfterLineEndElement(offset, false, emptyInlayProvider.createInlayRenderer(editor2));
        if (emptyInlay != null) {
            LogInlay inlay = new LogInlay(inlayLineComponent);
            DisposerUtilKt.whenDisposed((Disposable)((Disposable)emptyInlay), () -> AILogHeavyFilterService.createInlay$lambda$0(inlay));
            EditorUtil.disposeWithEditor((Editor)editor2, (Disposable)((Disposable)emptyInlay));
        }
        DocumentListener documentListener2 = new DocumentListener((Inlay<EditorCustomElementRenderer>)emptyInlay, editor2){
            final /* synthetic */ Inlay<EditorCustomElementRenderer> $emptyInlay;
            final /* synthetic */ Editor $editor;
            {
                this.$emptyInlay = $emptyInlay;
                this.$editor = $editor;
            }

            public void documentChanged(DocumentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                if (this.$emptyInlay != null) {
                    Disposer.dispose((Disposable)((Disposable)this.$emptyInlay));
                }
                this.$editor.getDocument().removeDocumentListener((DocumentListener)this);
            }
        };
        Disposable it = disposable = Disposer.newDisposable();
        boolean bl = false;
        EditorUtil.disposeWithEditor((Editor)editor2, (Disposable)it);
        Disposable disposable2 = disposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"also(...)");
        Disposable disposable3 = disposable2;
        editor2.getDocument().addDocumentListener(documentListener2, disposable3);
    }

    private static final void enqueueInlayFiltering$consumeResult(Editor $editor, int $eventOffset, AILogHeavyFilterService this$0, Filter.Result result2, boolean addOffset) {
        if (result2 == null) {
            return;
        }
        if ($editor.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> AILogHeavyFilterService.enqueueInlayFiltering$consumeResult$lambda$0($editor, addOffset, $eventOffset, result2, this$0));
    }

    private static final void enqueueInlayFiltering$consumeResult$lambda$0(Editor $editor, boolean $addOffset, int $eventOffset, Filter.Result $result, AILogHeavyFilterService this$0) {
        if ($editor.isDisposed()) {
            return;
        }
        int extraOffset = $addOffset ? $eventOffset : 0;
        List list = $result.getResultItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResultItems(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Filter.ResultItem it = (Filter.ResultItem)element$iv;
            boolean bl = false;
            int highlightEndOffset = it.getHighlightEndOffset() + extraOffset;
            if (highlightEndOffset > $editor.getDocument().getTextLength() || !(it instanceof InlayProvider)) continue;
            this$0.processInlays((InlayProvider)it, $editor, highlightEndOffset);
        }
    }

    private static final Unit createInlay$lambda$0(LogInlay $inlay) {
        Disposer.dispose((Disposable)$inlay);
        return Unit.INSTANCE;
    }
}

