/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.ideolog.highlighting.ui;

import com.intellij.codeInsight.editorLineStripeHint.EditorLineStripeHintComponent;
import com.intellij.codeInsight.editorLineStripeHint.RepositionableJPanel;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.ml.llm.ideolog.highlighting.ui.LogEditorLineStripePresentationRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.BorderFactory;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0002%&B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\"\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u000b2\u0010\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u0006H\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\b\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u000bH\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripeHintComponent;", "Lcom/intellij/codeInsight/editorLineStripeHint/EditorLineStripeHintComponent;", "editor", "Lcom/intellij/openapi/editor/Editor;", "panelRenderer", "Lkotlin/Function0;", "", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "stripeColor", "Lcom/intellij/ui/JBColor;", "offset", "", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lkotlin/jvm/functions/Function0;Lcom/intellij/ui/JBColor;I)V", "line", "getLine", "()I", "createPhantomInlayComponent", "Lcom/intellij/codeInsight/editorLineStripeHint/RepositionableJPanel;", "renderer", "getStripeVisibleWidth", "getLineStripeY", "getLineEndOffset", "getInlaysStartOffset", "getMeaningfulTextEnd", "lineEndOffset", "inlays", "Lcom/intellij/openapi/editor/Inlay;", "isEndOfLineVisible", "", "componentSize", "calculateStripeWidthVisible", "calculateStripeWidthInvisible", "paintComponent", "", "g", "Ljava/awt/Graphics;", "LogPhantomInlayComponent", "LogEditorListener", "intellij.ml.llm.ideolog"})
public final class LogEditorLineStripeHintComponent
extends EditorLineStripeHintComponent {
    private final int offset;

    public LogEditorLineStripeHintComponent(@NotNull Editor editor2, @NotNull Function0<? extends List<? extends List<? extends EditorCustomElementRenderer>>> panelRenderer, @NotNull JBColor stripeColor, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(panelRenderer, (String)"panelRenderer");
        Intrinsics.checkNotNullParameter((Object)stripeColor, (String)"stripeColor");
        super(editor2, panelRenderer, (Color)stripeColor, 0, 8, null);
        this.offset = offset;
        this.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 16));
        LogEditorListener editorListener = new LogEditorListener(this);
        editor2.getCaretModel().addCaretListener((CaretListener)editorListener);
        DisposerUtilKt.whenDisposed((Disposable)((Disposable)this), () -> LogEditorLineStripeHintComponent._init_$lambda$0(editor2, editorListener));
    }

    private final int getLine() {
        return this.getEditor().getDocument().getLineNumber(RangesKt.coerceIn((int)this.offset, (int)0, (int)this.getEditor().getDocument().getTextLength()));
    }

    @Nullable
    public RepositionableJPanel createPhantomInlayComponent(@NotNull EditorCustomElementRenderer renderer2) {
        Intrinsics.checkNotNullParameter((Object)renderer2, (String)"renderer");
        return renderer2 instanceof LogEditorLineStripePresentationRenderer ? (RepositionableJPanel)new LogPhantomInlayComponent(this.getEditor(), (LogEditorLineStripePresentationRenderer)renderer2) : null;
    }

    public int getStripeVisibleWidth() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object object = ArraysKt.last((Object[])componentArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ml.llm.ideolog.highlighting.ui.LogEditorLineStripeHintComponent.LogPhantomInlayComponent");
        return this.isEndOfLineVisible(((LogPhantomInlayComponent)((Object)object)).getPixelWidth()) ? this.calculateStripeWidthVisible() : this.calculateStripeWidthInvisible();
    }

    public int getLineStripeY() {
        return this.getEditor().offsetToXY((int)this.getEditor().getDocument().getLineEndOffset((int)this.getLine())).y;
    }

    public int getLineEndOffset() {
        return this.getEditor().getDocument().getLineEndOffset(this.getEditor().offsetToVisualPosition((int)this.getEditor().getDocument().getLineEndOffset((int)this.getLine())).line);
    }

    public int getInlaysStartOffset() {
        return this.getEditor().getDocument().getLineEndOffset(this.getLine());
    }

    public int getMeaningfulTextEnd(int lineEndOffset, @NotNull List<? extends Inlay<?>> inlays) {
        Intrinsics.checkNotNullParameter(inlays, (String)"inlays");
        return -1;
    }

    private final boolean isEndOfLineVisible(int componentSize) {
        int endVisualPosition = this.getEditor().visualPositionToXY((VisualPosition)this.getEditor().offsetToVisualPosition((int)this.getEditor().getDocument().getLineEndOffset((int)this.getLine()))).x;
        Rectangle rectangle = this.getEditor().getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        return endVisualPosition >= visibleArea.x && endVisualPosition + componentSize + 24 <= visibleArea.x + visibleArea.width;
    }

    private final int calculateStripeWidthVisible() {
        int endVisualPosition = this.getEditor().visualPositionToXY((VisualPosition)this.getEditor().offsetToVisualPosition((int)this.getEditor().getDocument().getLineEndOffset((int)this.getLine()))).x + this.getEditor().getSettings().getLineCursorWidth();
        Rectangle rectangle = this.getEditor().getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        return visibleArea.x + visibleArea.width - endVisualPosition;
    }

    private final int calculateStripeWidthInvisible() {
        Component[] componentArray = this.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object object = ArraysKt.last((Object[])componentArray);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.ml.llm.ideolog.highlighting.ui.LogEditorLineStripeHintComponent.LogPhantomInlayComponent");
        return ((LogPhantomInlayComponent)((Object)object)).getPixelWidth() + 24;
    }

    protected void paintComponent(@Nullable Graphics g) {
        super.paintComponent(g);
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(this.getEditor().getColorsScheme().getDefaultBackground());
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private static final Unit _init_$lambda$0(Editor $editor, LogEditorListener $editorListener) {
        $editor.getCaretModel().removeCaretListener((CaretListener)$editorListener);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripeHintComponent$LogEditorListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "panel", "Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripeHintComponent;", "<init>", "(Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripeHintComponent;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "adjustScrollPosition", "editor", "Lcom/intellij/openapi/editor/Editor;", "newPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "intellij.ml.llm.ideolog"})
    private static final class LogEditorListener
    implements CaretListener {
        @NotNull
        private final LogEditorLineStripeHintComponent panel;

        public LogEditorListener(@NotNull LogEditorLineStripeHintComponent panel2) {
            Intrinsics.checkNotNullParameter((Object)((Object)panel2), (String)"panel");
            this.panel = panel2;
            Editor editor2 = this.panel.getEditor();
            LogicalPosition logicalPosition = this.panel.getEditor().getCaretModel().getCurrentCaret().getLogicalPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
            this.adjustScrollPosition(editor2, logicalPosition);
        }

        public void caretPositionChanged(@NotNull CaretEvent event2) {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            Editor editor2 = event2.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
            LogicalPosition logicalPosition = event2.getNewPosition();
            Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getNewPosition(...)");
            this.adjustScrollPosition(editor2, logicalPosition);
        }

        private final void adjustScrollPosition(Editor editor2, LogicalPosition newPosition) {
            int caretX = editor2.visualPositionToXY((VisualPosition)editor2.getCaretModel().getVisualPosition()).x;
            int visibleWidth = editor2.getContentComponent().getVisibleRect().x + editor2.getContentComponent().getVisibleRect().width;
            int stripeWidth = this.panel.calculateStripeWidthInvisible();
            if (newPosition.line == this.panel.getLine() && visibleWidth - caretX < stripeWidth) {
                editor2.getScrollingModel().scrollHorizontally(editor2.getScrollingModel().getHorizontalScrollOffset() + (stripeWidth - visibleWidth + caretX + 2));
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripeHintComponent$LogPhantomInlayComponent;", "Lcom/intellij/codeInsight/editorLineStripeHint/RepositionableJPanel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "presentationRenderer", "Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripePresentationRenderer;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/ml/llm/ideolog/highlighting/ui/LogEditorLineStripePresentationRenderer;)V", "pixelWidth", "", "getPixelWidth", "()I", "reposition", "", "paint", "g", "Ljava/awt/Graphics;", "intellij.ml.llm.ideolog"})
    public static final class LogPhantomInlayComponent
    extends RepositionableJPanel {
        @NotNull
        private final Editor editor;
        @NotNull
        private final LogEditorLineStripePresentationRenderer presentationRenderer;
        private final int pixelWidth;

        public LogPhantomInlayComponent(@NotNull Editor editor2, @NotNull LogEditorLineStripePresentationRenderer presentationRenderer) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)presentationRenderer, (String)"presentationRenderer");
            this.editor = editor2;
            this.presentationRenderer = presentationRenderer;
            this.pixelWidth = this.presentationRenderer.getPresentation().getWidth();
            this.addMouseListener(this.presentationRenderer);
            this.setMaximumSize(new Dimension(this.pixelWidth, this.editor.getLineHeight()));
        }

        public final int getPixelWidth() {
            return this.pixelWidth;
        }

        public void reposition() {
        }

        /*
         * WARNING - void declaration
         */
        public void paint(@NotNull Graphics g) {
            void $this$paint_u24lambda_u240;
            TextAttributes textAttributes;
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            TextAttributes textAttributes2 = textAttributes = this.editor.getColorsScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT_HIGHLIGHTED);
            Graphics2D graphics2D = (Graphics2D)g;
            InlayPresentation inlayPresentation = this.presentationRenderer.getPresentation();
            boolean bl = false;
            $this$paint_u24lambda_u240.setBackgroundColor(this.editor.getColorsScheme().getDefaultBackground());
            Unit unit = Unit.INSTANCE;
            TextAttributes textAttributes3 = textAttributes;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributes3, (String)"apply(...)");
            inlayPresentation.paint(graphics2D, textAttributes3);
        }
    }
}

