/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.agent.appliers;

import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.ml.llm.codeGeneration.diff.AIResponseApplier;
import com.intellij.ml.llm.codeGeneration.diff.AIResponseApplierChange;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010\u0017\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0019H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ml/llm/jupyter/common/agent/appliers/JupyterAgentApplier;", "Lcom/intellij/ml/llm/codeGeneration/diff/AIResponseApplier;", "initialText", "", "targetOrdinalCandidate", "", "<init>", "(Ljava/lang/CharSequence;I)V", "hasModifications", "", "getHasModifications", "()Z", "setHasModifications", "(Z)V", "processedText", "", "initialDocument", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "initialLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "applierDocument", "targetOrdinal", "calculateTargetOrdinal", "apply", "message", "", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "complete", "getModifiedRanges", "Lcom/intellij/ml/llm/codeGeneration/diff/AIResponseApplierChange;", "intellij.ml.llm.jupyter.common"})
public final class JupyterAgentApplier
implements AIResponseApplier {
    private boolean hasModifications;
    @NotNull
    private String processedText;
    @NotNull
    private final DocumentImpl initialDocument;
    @NotNull
    private final NotebookCellLines initialLines;
    @NotNull
    private final DocumentImpl applierDocument;
    private final int targetOrdinal;

    public JupyterAgentApplier(@NotNull CharSequence initialText, int targetOrdinalCandidate) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        this.processedText = "";
        this.initialDocument = new DocumentImpl(initialText, true);
        this.initialLines = NotebookCellLinesProvider.Companion.install((Document)this.initialDocument, (NotebookCellLinesProvider)new JupyterCellLinesProvider());
        this.applierDocument = new DocumentImpl(initialText, true);
        this.targetOrdinal = this.calculateTargetOrdinal(targetOrdinalCandidate);
    }

    @Override
    public boolean getHasModifications() {
        return this.hasModifications;
    }

    public void setHasModifications(boolean bl) {
        this.hasModifications = bl;
    }

    private final int calculateTargetOrdinal(int targetOrdinalCandidate) {
        int prevOrdinal = Math.max(0, targetOrdinalCandidate - 1);
        CharSequence prevCellText = ((NotebookCellLines.Interval)this.initialLines.getIntervals().get(prevOrdinal)).getContentText((Document)this.initialDocument);
        if (StringsKt.trim((CharSequence)prevCellText).length() == 0) {
            return prevOrdinal;
        }
        return targetOrdinalCandidate;
    }

    @Override
    @NotNull
    public CharSequence apply(@NotNull List<? extends MessagePart> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        String string = this.applierDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.processedText = string;
        return this.processedText;
    }

    @Override
    @NotNull
    public CharSequence complete() {
        return this.processedText;
    }

    @Override
    @NotNull
    public List<AIResponseApplierChange> getModifiedRanges() {
        int prevOrdinal = Math.max(0, this.targetOrdinal - 1);
        int startOffset = this.initialDocument.getLineEndOffset(((NotebookCellLines.Interval)this.initialLines.getIntervals().get(prevOrdinal)).getLastContentLine());
        int length = this.applierDocument.getTextLength() - this.initialDocument.getTextLength();
        TextRange textRange = TextRange.create((int)startOffset, (int)(startOffset + length));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange modifiedRange = textRange;
        return CollectionsKt.listOf((Object)new AIResponseApplierChange(modifiedRange, false, 2, null));
    }
}

