/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.interactions;

import com.intellij.jupyter.core.core.impl.actions.NotebookCellLinesDocumentUtils;
import com.intellij.jupyter.core.jupyter.editor.JupyterCellLinesProvider;
import com.intellij.ml.llm.codeGeneration.diff.AIResponseApplier;
import com.intellij.ml.llm.codeGeneration.diff.AIResponseApplierChange;
import com.intellij.ml.llm.core.chat.parts.MessagePart;
import com.intellij.ml.llm.jupyter.common.JupyterAIUtils;
import com.intellij.ml.llm.jupyter.common.interactions.JupyterAICodeGenerationState;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookCellLinesProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u001c\u001a\u00020\u00032\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\b\u0010 \u001a\u00020\u0003H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/jupyter/common/interactions/JupyterAIManyCellsCodeGenerationResponseApplier;", "Lcom/intellij/ml/llm/codeGeneration/diff/AIResponseApplier;", "initialText", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "targetOrdinalCandidate", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/lang/CharSequence;Lcom/intellij/openapi/editor/Editor;ILcom/intellij/openapi/project/Project;)V", "hasModifications", "", "getHasModifications", "()Z", "setHasModifications", "(Z)V", "processedText", "", "cellsTextsLength", "initialDocument", "Lcom/intellij/openapi/editor/impl/DocumentImpl;", "initialLines", "Lcom/intellij/notebooks/visualization/NotebookCellLines;", "applierDocument", "targetOrdinal", "calculateTargetOrdinal", "apply", "message", "", "Lcom/intellij/ml/llm/core/chat/parts/MessagePart;", "complete", "getModifiedRanges", "Lcom/intellij/ml/llm/codeGeneration/diff/AIResponseApplierChange;", "intellij.ml.llm.jupyter.common"})
public final class JupyterAIManyCellsCodeGenerationResponseApplier
implements AIResponseApplier {
    @NotNull
    private final CharSequence initialText;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    private boolean hasModifications;
    @NotNull
    private String processedText;
    private int cellsTextsLength;
    @NotNull
    private final DocumentImpl initialDocument;
    @NotNull
    private final NotebookCellLines initialLines;
    @NotNull
    private final DocumentImpl applierDocument;
    private final int targetOrdinal;

    public JupyterAIManyCellsCodeGenerationResponseApplier(@NotNull CharSequence initialText, @NotNull Editor editor2, int targetOrdinalCandidate, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.initialText = initialText;
        this.editor = editor2;
        this.project = project2;
        this.processedText = "";
        this.initialDocument = new DocumentImpl(this.initialText, true);
        this.initialLines = NotebookCellLinesProvider.Companion.install((Document)this.initialDocument, (NotebookCellLinesProvider)new JupyterCellLinesProvider());
        this.applierDocument = new DocumentImpl(this.initialText, true);
        this.targetOrdinal = this.calculateTargetOrdinal(targetOrdinalCandidate);
    }

    @Override
    public boolean getHasModifications() {
        return this.hasModifications;
    }

    public void setHasModifications(boolean bl) {
        this.hasModifications = bl;
    }

    private final int calculateTargetOrdinal(int targetOrdinalCandidate) {
        int prevOrdinal = Math.max(0, targetOrdinalCandidate - 1);
        CharSequence prevCellText = ((NotebookCellLines.Interval)this.initialLines.getIntervals().get(prevOrdinal)).getContentText((Document)this.initialDocument);
        if (StringsKt.trim((CharSequence)prevCellText).length() == 0) {
            return prevOrdinal;
        }
        return targetOrdinalCandidate;
    }

    @Override
    @NotNull
    public CharSequence apply(@NotNull List<? extends MessagePart> message) {
        NotebookCellLines.Interval nextCellInterval;
        CharSequence nextCellText;
        Intrinsics.checkNotNullParameter(message, (String)"message");
        List<JupyterAIUtils.JupyterCellText> cellsInfos = JupyterAIUtils.INSTANCE.getJupyterCellsTexts(message);
        this.applierDocument.setText(this.initialText);
        String combinedCellsText = JupyterAIUtils.INSTANCE.combineJupyterCellTexts(this.editor, cellsInfos);
        if (((CharSequence)combinedCellsText).length() == 0) {
            this.setHasModifications(false);
            return this.initialText;
        }
        this.setHasModifications(true);
        NotebookCellLinesDocumentUtils.insertCells$default((NotebookCellLinesDocumentUtils)NotebookCellLinesDocumentUtils.INSTANCE, (Document)((Document)this.applierDocument), (NotebookCellLines)this.initialLines, (String)combinedCellsText, (int)this.targetOrdinal, (boolean)false, (int)8, null);
        JupyterAICodeGenerationState.INSTANCE.getGeneratedCellsOrdinals().clear();
        CollectionsKt.addAll((Collection)JupyterAICodeGenerationState.INSTANCE.getGeneratedCellsOrdinals(), (Iterable)((Iterable)RangesKt.until((int)this.targetOrdinal, (int)(this.targetOrdinal + cellsInfos.size()))));
        this.cellsTextsLength = combinedCellsText.length();
        NotebookCellLines applierLines = NotebookCellLinesProvider.Companion.install((Document)this.applierDocument, (NotebookCellLinesProvider)new JupyterCellLinesProvider());
        if (this.targetOrdinal + cellsInfos.size() < applierLines.getIntervals().size() && StringsKt.trim((CharSequence)(nextCellText = (nextCellInterval = (NotebookCellLines.Interval)applierLines.getIntervals().get(this.targetOrdinal + cellsInfos.size())).getContentText((Document)this.applierDocument))).length() == 0) {
            NotebookCellLinesDocumentUtils.INSTANCE.removeCell((Document)this.applierDocument, nextCellInterval, null);
        }
        String string = this.applierDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.processedText = string;
        return this.processedText;
    }

    @Override
    @NotNull
    public CharSequence complete() {
        return this.processedText;
    }

    @Override
    @NotNull
    public List<AIResponseApplierChange> getModifiedRanges() {
        int prevOrdinal = Math.max(0, this.targetOrdinal - 1);
        int startOffset = this.initialDocument.getLineEndOffset(((NotebookCellLines.Interval)this.initialLines.getIntervals().get(prevOrdinal)).getLastContentLine());
        int length = this.applierDocument.getTextLength() - this.initialDocument.getTextLength();
        TextRange textRange = TextRange.create((int)startOffset, (int)(startOffset + length));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        TextRange modifiedRange = textRange;
        return CollectionsKt.listOf((Object)new AIResponseApplierChange(modifiedRange, false, 2, null));
    }
}

