/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.jupyter.common.prompts.utils;

import com.intellij.ml.llm.tokenizer.Tokenizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/jupyter/common/prompts/utils/JupyterTrimUtils;", "", "<init>", "()V", "getMiddleTrimmedString", "", "tokenizer", "Lcom/intellij/ml/llm/tokenizer/Tokenizer;", "original", "prefixLimit", "", "suffixLimit", "intellij.ml.llm.jupyter.common"})
public final class JupyterTrimUtils {
    @NotNull
    public static final JupyterTrimUtils INSTANCE = new JupyterTrimUtils();

    private JupyterTrimUtils() {
    }

    @NotNull
    public final String getMiddleTrimmedString(@NotNull Tokenizer tokenizer, @NotNull String original, int prefixLimit, int suffixLimit) {
        Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        int fullLen = tokenizer.count(original);
        if (prefixLimit + suffixLimit >= fullLen) {
            return original;
        }
        String prefix = tokenizer.trim(original, prefixLimit, null);
        String suffix = tokenizer.trimEnd(original, suffixLimit, null);
        return prefix + "\n...\n" + suffix;
    }
}

