/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.logicalStructure.attachment;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.logical.model.LogicalStructureAssembledModel;
import com.intellij.ml.llm.context.ContextEntityPrivacy;
import com.intellij.ml.llm.context.ContextEntitySource;
import com.intellij.ml.llm.core.chat.attachments.ChatAttachment;
import com.intellij.ml.llm.core.chat.ui.chat.context.attachments.ContextAttachmentBase;
import com.intellij.ml.llm.logicalStructure.attachment.LogicalStructureContextAttachmentSource;
import com.intellij.ml.llm.logicalStructure.attachment.LogicalStructureYamlChatAttachment;
import com.intellij.ml.llm.logicalStructure.mapper.LogicalStructureYamlMapper;
import com.intellij.ml.llm.logicalStructure.privacy.LogicalStructureYamlPrivacyWrapper;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.observable.properties.AtomicProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u0000 22\u00020\u0001:\u00012B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010*\u001a\u00020+H\u0096@\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u0014\u0010\u001b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u0014\u0010\u001d\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000eR\u0014\u0010\u001f\u001a\u00020 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0012\u00a8\u00063"}, d2={"Lcom/intellij/ml/llm/logicalStructure/attachment/LogicalStructureYamlContextAttachment;", "Lcom/intellij/ml/llm/core/chat/ui/chat/context/attachments/ContextAttachmentBase;", "project", "Lcom/intellij/openapi/project/Project;", "text", "Lcom/intellij/ml/llm/privacy/PSString;", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ml/llm/privacy/PSString;)V", "getText", "()Lcom/intellij/ml/llm/privacy/PSString;", "id", "", "getId", "()Ljava/lang/String;", "name", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "getName", "()Lcom/intellij/openapi/observable/properties/ObservableProperty;", "virtualFile", "Lcom/intellij/testFramework/LightVirtualFile;", "getVirtualFile", "()Lcom/intellij/testFramework/LightVirtualFile;", "virtualFile$delegate", "Lkotlin/Lazy;", "hint", "getHint", "tooltipText", "getTooltipText", "popupPresentationText", "getPopupPresentationText", "privacy", "Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "getPrivacy", "()Lcom/intellij/ml/llm/context/ContextEntityPrivacy;", "attachedBy", "Lcom/intellij/ml/llm/context/ContextEntitySource;", "getAttachedBy", "()Lcom/intellij/ml/llm/context/ContextEntitySource;", "icon", "Ljavax/swing/Icon;", "getIcon", "createChatAttachment", "Lcom/intellij/ml/llm/core/chat/attachments/ChatAttachment;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "performAction", "", "isInMessage", "", "toString", "Companion", "intellij.ml.llm.logicalStructure"})
public final class LogicalStructureYamlContextAttachment
extends ContextAttachmentBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PSString text;
    @NotNull
    private final String id;
    @NotNull
    private final ObservableProperty<String> name;
    @NotNull
    private final Lazy virtualFile$delegate;
    @Nullable
    private final ObservableProperty<String> hint;
    @NotNull
    private final String tooltipText;
    @NotNull
    private final String popupPresentationText;
    @NotNull
    private final ContextEntityPrivacy privacy;
    @NotNull
    private final ContextEntitySource attachedBy;
    @NotNull
    private final ObservableProperty<Icon> icon;
    @NotNull
    private static final PSString ATTACHMENT_NAME = ConstantsKt.getPrivacyConst((String)"Project logical structure");
    @NotNull
    private static final String SOURCE_ID = "LOGICAL_STRUCTURE";

    public LogicalStructureYamlContextAttachment(@NotNull Project project2, @NotNull PSString text2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.project = project2;
        this.text = text2;
        this.id = SOURCE_ID;
        this.name = (ObservableProperty)new AtomicProperty((Object)ATTACHMENT_NAME.unwrap());
        this.virtualFile$delegate = LazyKt.lazy(() -> LogicalStructureYamlContextAttachment.virtualFile_delegate$lambda$0(this));
        this.tooltipText = "Project logical structure.";
        this.popupPresentationText = "";
        this.privacy = ContextEntityPrivacy.Unrelated.INSTANCE;
        this.attachedBy = (ContextEntitySource)((Object)LogicalStructureContextAttachmentSource.INSTANCE);
        this.icon = (ObservableProperty)new AtomicProperty((Object)AllIcons.General.Tree);
    }

    @NotNull
    public PSString getText() {
        return this.text;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ObservableProperty<String> getName() {
        return this.name;
    }

    private final LightVirtualFile getVirtualFile() {
        Lazy lazy = this.virtualFile$delegate;
        return (LightVirtualFile)lazy.getValue();
    }

    @Nullable
    public ObservableProperty<String> getHint() {
        return this.hint;
    }

    @NotNull
    public String getTooltipText() {
        return this.tooltipText;
    }

    @NotNull
    public String getPopupPresentationText() {
        return this.popupPresentationText;
    }

    @NotNull
    public ContextEntityPrivacy getPrivacy() {
        return this.privacy;
    }

    @NotNull
    public ContextEntitySource getAttachedBy() {
        return this.attachedBy;
    }

    @NotNull
    public ObservableProperty<Icon> getIcon() {
        return this.icon;
    }

    @Nullable
    public Object createChatAttachment(@NotNull Continuation<? super ChatAttachment> $completion) {
        return new LogicalStructureYamlChatAttachment(this.project, this.getText());
    }

    public void performAction(boolean isInMessage) {
        if (this.getVirtualFile().isValid()) {
            FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)this.getVirtualFile(), true);
        }
    }

    @NotNull
    public String toString() {
        return (String)ATTACHMENT_NAME.unwrap();
    }

    private static final LightVirtualFile virtualFile_delegate$lambda$0(LogicalStructureYamlContextAttachment this$0) {
        return new LightVirtualFile((String)ATTACHMENT_NAME.unwrap(), (CharSequence)this$0.getText());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0007J\u001e\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0010H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/logicalStructure/attachment/LogicalStructureYamlContextAttachment$Companion;", "", "<init>", "()V", "ATTACHMENT_NAME", "Lcom/intellij/ml/llm/privacy/PSString;", "getATTACHMENT_NAME", "()Lcom/intellij/ml/llm/privacy/PSString;", "SOURCE_ID", "", "create", "Lcom/intellij/ml/llm/logicalStructure/attachment/LogicalStructureYamlContextAttachment;", "logicalStructureModel", "Lcom/intellij/ide/structureView/logical/model/LogicalStructureAssembledModel;", "convertToYaml", "items", "", "intellij.ml.llm.logicalStructure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PSString getATTACHMENT_NAME() {
            return ATTACHMENT_NAME;
        }

        @RequiresReadLock
        @Nullable
        public final LogicalStructureYamlContextAttachment create(@NotNull LogicalStructureAssembledModel<?> logicalStructureModel) {
            Intrinsics.checkNotNullParameter(logicalStructureModel, (String)"logicalStructureModel");
            Map<String, Object> logicalMap = LogicalStructureYamlMapper.Companion.map(logicalStructureModel);
            String string = this.convertToYaml(logicalMap);
            if (string == null) {
                return null;
            }
            String yaml = string;
            PSString yamlSafe = new LogicalStructureYamlPrivacyWrapper(logicalStructureModel.getProject(), yaml).getYaml();
            return new LogicalStructureYamlContextAttachment(logicalStructureModel.getProject(), yamlSafe);
        }

        private final String convertToYaml(Map<String, ? extends Object> items2) {
            return new ObjectMapper((JsonFactory)new YAMLFactory()).writerWithDefaultPrettyPrinter().writeValueAsString(items2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

