/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client;

import com.intellij.ml.llm.mcp.client.McpLogEntryKt;
import com.intellij.ml.llm.mcp.client.McpLogEntryType;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\bH\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/ml/llm/mcp/client/McpTeeOutputStream;", "Ljava/io/OutputStream;", "outputStream", "logWriter", "Ljava/io/BufferedWriter;", "<init>", "(Ljava/io/OutputStream;Ljava/io/BufferedWriter;)V", "write", "", "b", "", "", "off", "len", "flush", "close", "intellij.ml.llm.mcp"})
public final class McpTeeOutputStream
extends OutputStream {
    @NotNull
    private final OutputStream outputStream;
    @NotNull
    private final BufferedWriter logWriter;

    public McpTeeOutputStream(@NotNull OutputStream outputStream, @NotNull BufferedWriter logWriter) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        Intrinsics.checkNotNullParameter((Object)logWriter, (String)"logWriter");
        this.outputStream = outputStream;
        this.logWriter = logWriter;
    }

    @Override
    public void write(int b) throws IOException {
        this.outputStream.write(b);
        McpLogEntryKt.writeLogEntry(this.logWriter, String.valueOf((char)b), McpLogEntryType.CLIENT);
    }

    @Override
    public void write(@NotNull byte[] b) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        this.outputStream.write(b, off, len);
        McpLogEntryKt.writeLogEntry(this.logWriter, new String(b, off, len, Charsets.UTF_8), McpLogEntryType.CLIENT);
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
        this.logWriter.flush();
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

