/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.mcp.client.settings;

import com.google.gson.GsonBuilder;
import com.intellij.codeInsight.actions.FileInEditorProcessor;
import com.intellij.codeInsight.actions.LayoutCodeOptions;
import com.intellij.codeInsight.actions.ReformatCodeRunOptions;
import com.intellij.codeInsight.actions.TextRangeType;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.ml.llm.mcp.client.settings.McpServerBean;
import com.intellij.ml.llm.mcp.client.settings.McpServerCommand;
import com.intellij.ml.llm.mcp.client.settings.McpServerConfigurationSource;
import com.intellij.ml.llm.mcp.client.settings.McpServerEditPanel;
import com.intellij.ml.llm.mcp.client.settings.McpServersBean;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B$\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0014J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0015J\b\u0010\u0017\u001a\u00020\u0005H\u0015J\n\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0002J\b\u0010\u0019\u001a\u00020\bH\u0002J\f\u0010\u001a\u001a\u00020\u0005*\u00020\u001bH\u0002J\f\u0010\u001c\u001a\u00020\u001b*\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/mcp/client/settings/McpServerEditDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "serverCommand", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/ml/llm/mcp/client/settings/McpServerCommand;)V", "content", "Lcom/intellij/ml/llm/mcp/client/settings/McpServerEditPanel;", "initFields", "", "command", "initEditor", "initListeners", "doOKAction", "isOKActionEnabled", "", "createCenterPanel", "Ljavax/swing/JComponent;", "getDimensionServiceKey", "jsonContentAsCommand", "fieldsAsCommand", "asJson", "Lcom/intellij/ml/llm/mcp/client/settings/McpServersBean;", "asBean", "intellij.ml.llm.mcp"})
@SourceDebugExtension(value={"SMAP\nMcpServerEditDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 McpServerEditDialog.kt\ncom/intellij/ml/llm/mcp/client/settings/McpServerEditDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class McpServerEditDialog
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final McpServerCommand serverCommand;
    @NotNull
    private final McpServerEditPanel content;

    public McpServerEditDialog(@NotNull Project project2, @NotNull String title, @NotNull McpServerCommand serverCommand) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)serverCommand, (String)"serverCommand");
        super(project2, true);
        this.project = project2;
        this.serverCommand = serverCommand;
        this.content = new McpServerEditPanel(this.project);
        Disposer.register((Disposable)this.getDisposable(), () -> McpServerEditDialog._init_$lambda$0(this));
        this.setTitle(title);
        this.initListeners();
        this.init();
        this.content.getProgramField().addBrowseFolderListener(this.project, FileChooserDescriptorFactory.singleFile());
        this.content.getWorkingDirField().addBrowseFolderListener(this.project, FileChooserDescriptorFactory.singleDir());
        if (this.content.isJson()) {
            this.initEditor(this.serverCommand);
        } else {
            this.initFields(this.serverCommand);
        }
    }

    private final void initFields(McpServerCommand command) {
        this.content.getNameField().setText(command.getName());
        this.content.getProgramField().setText(command.getProgramPath());
        this.content.getArgumentsField().setText(command.getArguments());
        this.content.getWorkingDirField().setText(command.getWorkingDirectory());
        this.content.getEnvComponent().setEnvData(command.getEnvData());
    }

    private final void initEditor(McpServerCommand command) {
        this.content.getWorkingDirField().setText(command.getWorkingDirectory());
        ApplicationManager.getApplication().runWriteAction(() -> McpServerEditDialog.initEditor$lambda$0(this, command));
    }

    private final void initListeners() {
        this.content.getEditor().getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ McpServerEditDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void documentChanged(DocumentEvent event2) {
                Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
                McpServerEditDialog.access$initValidation(this.this$0);
            }
        });
        this.content.getSwitcher().addActionListener(arg_0 -> McpServerEditDialog.initListeners$lambda$0(this, arg_0));
    }

    protected void doOKAction() {
        McpServerCommand command;
        McpServerCommand mcpServerCommand = command = this.content.isJson() ? this.jsonContentAsCommand() : this.fieldsAsCommand();
        if (command != null) {
            command.setEnabled(this.serverCommand.getEnabled());
            this.serverCommand.copyFrom(command);
        }
        super.doOKAction();
    }

    public boolean isOKActionEnabled() {
        if (this.content.isJson() && this.jsonContentAsCommand() == null) {
            return false;
        }
        return super.isOKActionEnabled();
    }

    @Nullable
    @NotNull
    protected JComponent createCenterPanel() {
        return (JComponent)this.content.getPanel();
    }

    @Nullable
    @NotNull
    protected String getDimensionServiceKey() {
        return "llm.McpServerEditDialog";
    }

    private final McpServerCommand jsonContentAsCommand() {
        McpServerCommand mcpServerCommand;
        McpServerCommand mcpServerCommand2 = this.content.getEditorCommand();
        if (mcpServerCommand2 != null) {
            McpServerCommand mcpServerCommand3;
            McpServerCommand it = mcpServerCommand2;
            boolean bl = false;
            McpServerCommand $this$jsonContentAsCommand_u24lambda_u241 = mcpServerCommand3 = new McpServerCommand(it);
            boolean bl2 = false;
            String string = this.content.getWorkingDirField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            $this$jsonContentAsCommand_u24lambda_u241.setWorkingDirectory(string);
            mcpServerCommand = mcpServerCommand3;
        } else {
            mcpServerCommand = null;
        }
        return mcpServerCommand;
    }

    private final McpServerCommand fieldsAsCommand() {
        String string = this.content.getNameField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = this.content.getProgramField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = this.content.getArgumentsField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        String string4 = this.content.getWorkingDirField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        EnvironmentVariablesData environmentVariablesData = this.content.getEnvComponent().getEnvData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getEnvData(...)");
        return new McpServerCommand(string, string2, string3, string4, environmentVariablesData, true, McpServerConfigurationSource.USER);
    }

    private final String asJson(McpServersBean $this$asJson) {
        String string = new GsonBuilder().setPrettyPrinting().create().toJson((Object)$this$asJson);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        return string;
    }

    private final McpServersBean asBean(McpServerCommand $this$asBean) {
        Map env = Intrinsics.areEqual((Object)$this$asBean.getEnvData(), (Object)EnvironmentVariablesData.DEFAULT) ? null : $this$asBean.getEnvData().getEnvs();
        String string = $this$asBean.getProgramPath();
        String[] stringArray = ParametersListUtil.parseToArray((String)$this$asBean.getArguments());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"parseToArray(...)");
        McpServerBean bean = new McpServerBean(string, ArraysKt.asList((Object[])stringArray), env);
        return new McpServersBean(MapsKt.mapOf((Pair)TuplesKt.to((Object)$this$asBean.getName(), (Object)bean)));
    }

    private static final void _init_$lambda$0(McpServerEditDialog this$0) {
        EditorFactory.getInstance().releaseEditor((Editor)this$0.content.getEditor());
    }

    private static final void initEditor$lambda$0(McpServerEditDialog this$0, McpServerCommand $command) {
        DocumentEx documentEx = this$0.content.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document2 = documentEx;
        document2.setText((CharSequence)this$0.asJson(this$0.asBean($command)));
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument((Document)document2);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this$0.project).getPsiFile((Document)document2);
        Intrinsics.checkNotNull((Object)psiFile);
        PsiFile file = psiFile;
        new FileInEditorProcessor(file, (Editor)this$0.content.getEditor(), (LayoutCodeOptions)new ReformatCodeRunOptions(TextRangeType.WHOLE_FILE)).processCode();
        PsiDocumentManager.getInstance((Project)this$0.project).commitDocument((Document)document2);
    }

    private static final void initListeners$lambda$0(McpServerEditDialog this$0, ActionEvent it) {
        if (this$0.content.isJson()) {
            this$0.initEditor(this$0.fieldsAsCommand());
        } else {
            McpServerCommand command = this$0.jsonContentAsCommand();
            if (command != null) {
                this$0.initFields(command);
            }
        }
        this$0.initValidation();
    }

    public static final /* synthetic */ void access$initValidation(McpServerEditDialog $this) {
        $this.initValidation();
    }
}

