/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.diagnostics;

import com.intellij.codeWithMe.ClientId;
import com.intellij.lang.Language;
import com.intellij.ml.diagnostics.DiagnosticEvent;
import com.intellij.ml.diagnostics.DiagnosticEventBus;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditActionContent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditBackendProviderSelected;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditComputed;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditContextComposed;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffAccepted;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffContent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditDiffShown;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEvent;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditEventPayload;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditFrontendProviderSelected;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditJumpAccepted;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditJumpShown;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditModelResponse;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditPerformanceMetrics;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditPromptComposed;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditProviderPerformanceMetrics;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionEventsReporter;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionFinished;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditSessionInvalidState;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditStepsDescription;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditStepsRawDescription;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditTargetFile;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.NextEditTriggered;
import com.intellij.ml.llm.nextEdits.backend.logs.NextEditSessionTracker;
import com.intellij.ml.llm.nextEdits.backend.logs.NextEditTraceCollector;
import com.intellij.ml.llm.nextEdits.backend.provider.NextEditBackendProviderId;
import com.intellij.ml.llm.nextEdits.common.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.common.NextEditStepViewType;
import com.intellij.ml.llm.nextEdits.common.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.common.pipeline.NextEditIterationFilterDescriptor;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditFrontendProviderId;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditSuggestionSimilarityId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.util.TextRange;
import java.time.Clock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.time.Duration;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u0093\u00012\u00020\u0001:\u0002\u0093\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0002J\u0010\u0010A\u001a\u00020>2\u0006\u0010B\u001a\u00020'H\u0016J\b\u0010C\u001a\u00020>H\u0016J\u0010\u0010D\u001a\u00020>2\u0006\u0010E\u001a\u00020)H\u0016J\u0010\u0010F\u001a\u00020>2\u0006\u0010E\u001a\u00020+H\u0016J\u0010\u0010G\u001a\u00020>2\u0006\u0010H\u001a\u00020-H\u0016J\u0010\u0010I\u001a\u00020>2\u0006\u0010J\u001a\u00020-H\u0016J\u0017\u0010K\u001a\u00020>2\u0006\u0010L\u001a\u00020MH\u0016\u00a2\u0006\u0004\bN\u0010OJ\u0017\u0010P\u001a\u00020>2\u0006\u0010Q\u001a\u00020MH\u0016\u00a2\u0006\u0004\bR\u0010OJ\u0017\u0010S\u001a\u00020>2\u0006\u0010T\u001a\u00020MH\u0016\u00a2\u0006\u0004\bU\u0010OJ\u0017\u0010V\u001a\u00020>2\u0006\u0010W\u001a\u00020MH\u0016\u00a2\u0006\u0004\bX\u0010OJ\u0010\u0010Y\u001a\u00020>2\u0006\u0010J\u001a\u00020-H\u0016J\u0010\u0010Z\u001a\u00020>2\u0006\u0010[\u001a\u00020-H\u0016J \u0010\\\u001a\u00020>2\u0006\u0010]\u001a\u00020-2\u0006\u0010^\u001a\u00020-2\u0006\u0010_\u001a\u00020`H\u0016J0\u0010a\u001a\u00020>2\u0006\u0010b\u001a\u00020<2\u0006\u0010\u0018\u001a\u00020<2\u0006\u0010\u0019\u001a\u00020<2\u0006\u0010\u001c\u001a\u00020<2\u0006\u0010\u001d\u001a\u00020<H\u0016J\b\u0010c\u001a\u00020>H\u0016J\b\u0010d\u001a\u00020>H\u0016J(\u0010e\u001a\u00020>2\u0006\u0010f\u001a\u00020<2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u00020<2\u0006\u0010j\u001a\u00020<H\u0016J\u0018\u0010k\u001a\u00020>2\u0006\u0010f\u001a\u00020<2\u0006\u0010g\u001a\u00020hH\u0002J\u0080\u0001\u0010l\u001a\u00020>2\u0006\u0010m\u001a\u00020<2\u0006\u0010n\u001a\u00020<2\u0006\u0010o\u001a\u00020<2\u0006\u0010p\u001a\u00020<2\u0006\u0010q\u001a\u00020<2\u0006\u0010r\u001a\u00020<2\u0006\u0010s\u001a\u00020<2\u0006\u0010t\u001a\u00020<2\u0006\u0010u\u001a\u00020<2\u0006\u0010\u0016\u001a\u00020<2\u0006\u0010\u0017\u001a\u00020<2\u0006\u0010\u001a\u001a\u00020<2\u0006\u0010\u001b\u001a\u00020<2\u0006\u0010v\u001a\u00020-2\u0006\u0010w\u001a\u00020-H\u0016J4\u0010x\u001a\u00020>2\u0006\u0010y\u001a\u00020<2\u0006\u0010z\u001a\u00020<2\u0006\u0010{\u001a\u00020-2\u0012\u0010|\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0}H\u0016J\u0019\u0010~\u001a\u00020>2\u0006\u0010\u007f\u001a\u00020<2\u0007\u0010\u0080\u0001\u001a\u00020<H\u0016J\u001d\u0010\u0081\u0001\u001a\u00020>2\b\u0010\u0082\u0001\u001a\u00030\u0083\u00012\n\u0010\u0084\u0001\u001a\u0005\u0018\u00010\u0085\u0001J\n\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0002J\t\u0010\u0088\u0001\u001a\u00020>H\u0002J\t\u0010\u0089\u0001\u001a\u00020>H\u0002J#\u0010\u008a\u0001\u001a\u00020>2\b\u0010\u008b\u0001\u001a\u00030\u0087\u00012\u000e\u0010\u008c\u0001\u001a\t\u0012\u0004\u0012\u00020-0\u008d\u0001H\u0002J\t\u0010\u008e\u0001\u001a\u00020>H\u0016J\t\u0010\u008f\u0001\u001a\u00020>H\u0016J\t\u0010\u0090\u0001\u001a\u00020>H\u0016J\t\u0010\u0091\u0001\u001a\u00020>H\u0016J\u0011\u0010\u0092\u0001\u001a\u00020>2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\"0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010(\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010+0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010,\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00103\u001a\b\u0012\u0004\u0012\u00020504X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u00020704X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00108\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u00109\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010-0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010:\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020<\u0018\u00010;0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0094\u0001"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl;", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporter;", "language", "Lcom/intellij/lang/Language;", "clock", "Ljava/time/Clock;", "<init>", "(Lcom/intellij/lang/Language;Ljava/time/Clock;)V", "requestId", "", "created", "timeToShow", "Ljava/util/concurrent/atomic/AtomicReference;", "shownAt", "shownDuration", "suppressedDurationByInline", "suppressedDurationByLookup", "suppressedStartTimeByInline", "suppressedStartTimeByLookup", "totalDiffs", "Ljava/util/concurrent/atomic/AtomicInteger;", "shownDiffs", "insertedLength", "deletedLength", "totalInsertLength", "totalDeleteLength", "insertedLinesNumber", "deletedLinesNumber", "totalInsertedLinesNumber", "totalDeletedLinesNumber", "acceptedDiffs", "shownJumps", "acceptedJumps", "filterReason", "Lcom/intellij/ml/llm/nextEdits/common/pipeline/NextEditIterationFilterDescriptor;", "jumpShown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "diffShown", "triggerReason", "Lcom/intellij/ml/llm/nextEdits/common/NextEditTriggerReason;", "frontendProviderId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditFrontendProviderId;", "backendProviderId", "Lcom/intellij/ml/llm/nextEdits/backend/provider/NextEditBackendProviderId;", "taskId", "", "performanceMetrics", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditProviderPerformanceMetrics;", "stepsRawDescription", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditStepsRawDescription;", "invalid", "acceptedDiffsContents", "", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditDiffContent;", "acceptedActionsContents", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditActionContent;", "requestContextJson", "rawModelOutput", "editableRegion", "Lkotlin/Pair;", "", "fire", "", "nextEditSessionMessage", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditEventPayload;", "onTriggered", "trigger", "onProviderStarting", "onFrontendProviderSelected", "providerId", "onBackendProviderSelected", "setTaskId", "taskID", "onContextComposed", "prompt", "setRequestWaitingTime", "requestWaitingTime", "Lkotlin/time/Duration;", "setRequestWaitingTime-LRDsOJo", "(J)V", "setContextCollectionTime", "contextCollectionTime", "setContextCollectionTime-LRDsOJo", "setClientExecutionTime", "clientExecutionTime", "setClientExecutionTime-LRDsOJo", "setIterationFilterTime", "iterationFilterTime", "setIterationFilterTime-LRDsOJo", "onPromptComposed", "onClientResponse", "string", "onTargetFile", "before", "after", "suggestionId", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditSuggestionSimilarityId;", "onDiffComputed", "diffsCount", "onJumpShown", "onJumpAccepted", "onStepShown", "stepIndex", "viewType", "Lcom/intellij/ml/llm/nextEdits/common/NextEditStepViewType;", "startOffset", "endOffset", "recordStepViewType", "onDiffAccepted", "diffIndex", "startOffset1", "endOffset1", "startOffset2", "endOffset2", "startLine1", "endLine1", "startLine2", "endLine2", "oldText", "newText", "onActionAccepted", "startLine", "endLine", "actionId", "actionLogParams", "", "setEditableRegion", "start", "end", "onSessionFinished", "finishType", "Lcom/intellij/ml/llm/nextEdits/common/NextEditSessionFinishType;", "editorId", "Lcom/intellij/openapi/editor/impl/EditorId;", "isVisible", "", "tryStartShowTime", "tryIncrementShowDuration", "checkValidity", "condition", "lazyMessage", "Lkotlin/Function0;", "onSuppressedByInline", "onSuppressedByLookup", "onUnsuppressedByInline", "onUnsuppressedByLookup", "onFilteredSuggestion", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditSessionEventsReporterImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSessionEventsReporterImpl.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,456:1\n42#2,3:457\n*S KotlinDebug\n*F\n+ 1 NextEditSessionEventsReporterImpl.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl\n*L\n354#1:457,3\n*E\n"})
public final class NextEditSessionEventsReporterImpl
implements NextEditSessionEventsReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final Clock clock;
    private final long requestId;
    private final long created;
    @NotNull
    private final AtomicReference<Long> timeToShow;
    @NotNull
    private final AtomicReference<Long> shownAt;
    @NotNull
    private final AtomicReference<Long> shownDuration;
    @NotNull
    private final AtomicReference<Long> suppressedDurationByInline;
    @NotNull
    private final AtomicReference<Long> suppressedDurationByLookup;
    @NotNull
    private final AtomicReference<Long> suppressedStartTimeByInline;
    @NotNull
    private final AtomicReference<Long> suppressedStartTimeByLookup;
    @NotNull
    private final AtomicInteger totalDiffs;
    @NotNull
    private final AtomicInteger shownDiffs;
    @NotNull
    private final AtomicInteger insertedLength;
    @NotNull
    private final AtomicInteger deletedLength;
    @NotNull
    private final AtomicInteger totalInsertLength;
    @NotNull
    private final AtomicInteger totalDeleteLength;
    @NotNull
    private final AtomicInteger insertedLinesNumber;
    @NotNull
    private final AtomicInteger deletedLinesNumber;
    @NotNull
    private final AtomicInteger totalInsertedLinesNumber;
    @NotNull
    private final AtomicInteger totalDeletedLinesNumber;
    @NotNull
    private final AtomicInteger acceptedDiffs;
    @NotNull
    private final AtomicInteger shownJumps;
    @NotNull
    private final AtomicInteger acceptedJumps;
    @NotNull
    private final AtomicReference<NextEditIterationFilterDescriptor> filterReason;
    @NotNull
    private final AtomicBoolean jumpShown;
    @NotNull
    private final AtomicBoolean diffShown;
    @NotNull
    private final AtomicReference<NextEditTriggerReason> triggerReason;
    @NotNull
    private final AtomicReference<NextEditFrontendProviderId> frontendProviderId;
    @NotNull
    private final AtomicReference<NextEditBackendProviderId> backendProviderId;
    @NotNull
    private final AtomicReference<String> taskId;
    @NotNull
    private final NextEditProviderPerformanceMetrics performanceMetrics;
    @NotNull
    private final NextEditStepsRawDescription stepsRawDescription;
    @NotNull
    private final AtomicBoolean invalid;
    @NotNull
    private final List<NextEditDiffContent> acceptedDiffsContents;
    @NotNull
    private final List<NextEditActionContent> acceptedActionsContents;
    @NotNull
    private final AtomicReference<String> requestContextJson;
    @NotNull
    private final AtomicReference<String> rawModelOutput;
    @NotNull
    private final AtomicReference<Pair<Integer, Integer>> editableRegion;

    private NextEditSessionEventsReporterImpl(Language language, Clock clock) {
        this.language = language;
        this.clock = clock;
        this.requestId = Random.Default.nextLong();
        this.created = this.clock.millis();
        this.timeToShow = new AtomicReference<Object>(null);
        this.shownAt = new AtomicReference<Object>(null);
        this.shownDuration = new AtomicReference<Long>(0L);
        this.suppressedDurationByInline = new AtomicReference<Long>(0L);
        this.suppressedDurationByLookup = new AtomicReference<Long>(0L);
        this.suppressedStartTimeByInline = new AtomicReference<Object>(null);
        this.suppressedStartTimeByLookup = new AtomicReference<Object>(null);
        this.totalDiffs = new AtomicInteger(0);
        this.shownDiffs = new AtomicInteger(0);
        this.insertedLength = new AtomicInteger(0);
        this.deletedLength = new AtomicInteger(0);
        this.totalInsertLength = new AtomicInteger(0);
        this.totalDeleteLength = new AtomicInteger(0);
        this.insertedLinesNumber = new AtomicInteger(0);
        this.deletedLinesNumber = new AtomicInteger(0);
        this.totalInsertedLinesNumber = new AtomicInteger(0);
        this.totalDeletedLinesNumber = new AtomicInteger(0);
        this.acceptedDiffs = new AtomicInteger(0);
        this.shownJumps = new AtomicInteger(0);
        this.acceptedJumps = new AtomicInteger(0);
        this.filterReason = new AtomicReference<Object>(null);
        this.jumpShown = new AtomicBoolean(false);
        this.diffShown = new AtomicBoolean(false);
        this.triggerReason = new AtomicReference<NextEditTriggerReason>(NextEditTriggerReason.UNKNOWN);
        this.frontendProviderId = new AtomicReference<Object>(null);
        this.backendProviderId = new AtomicReference<Object>(null);
        this.taskId = new AtomicReference<Object>(null);
        this.performanceMetrics = new NextEditProviderPerformanceMetrics(null, null, null, null, 15, null);
        this.stepsRawDescription = new NextEditStepsRawDescription(null, 1, null);
        this.invalid = new AtomicBoolean(false);
        this.acceptedDiffsContents = new ArrayList();
        this.acceptedActionsContents = new ArrayList();
        this.requestContextJson = new AtomicReference<Object>(null);
        this.rawModelOutput = new AtomicReference<Object>(null);
        this.editableRegion = new AtomicReference<Object>(null);
    }

    private final void fire(NextEditEventPayload nextEditSessionMessage) {
        DiagnosticEventBus.Companion.getInstance().fire(() -> NextEditSessionEventsReporterImpl.fire$lambda$0(this, nextEditSessionMessage));
    }

    @Override
    public void onTriggered(@NotNull NextEditTriggerReason trigger) {
        Intrinsics.checkNotNullParameter((Object)((Object)trigger), (String)"trigger");
        this.triggerReason.set(trigger);
        this.fire(new NextEditTriggered(trigger));
    }

    @Override
    public void onProviderStarting() {
        this.frontendProviderId.set(null);
        this.backendProviderId.set(null);
        this.performanceMetrics.reset();
    }

    @Override
    public void onFrontendProviderSelected(@NotNull NextEditFrontendProviderId providerId) {
        Intrinsics.checkNotNullParameter((Object)((Object)providerId), (String)"providerId");
        this.checkValidity(this.frontendProviderId.get() == null, (Function0<String>)((Function0)() -> NextEditSessionEventsReporterImpl.onFrontendProviderSelected$lambda$0(this, providerId)));
        this.frontendProviderId.set(providerId);
        this.fire(new NextEditFrontendProviderSelected(providerId));
    }

    @Override
    public void onBackendProviderSelected(@NotNull NextEditBackendProviderId providerId) {
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        this.checkValidity(this.backendProviderId.get() == null, (Function0<String>)((Function0)() -> NextEditSessionEventsReporterImpl.onBackendProviderSelected$lambda$0(this, providerId)));
        this.backendProviderId.set(providerId);
        this.fire(new NextEditBackendProviderSelected(providerId));
    }

    @Override
    public void setTaskId(@NotNull String taskID) {
        Intrinsics.checkNotNullParameter((Object)taskID, (String)"taskID");
        this.taskId.set(taskID);
    }

    @Override
    public void onContextComposed(@NotNull String prompt2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        this.requestContextJson.set(prompt2);
        this.fire(new NextEditContextComposed(prompt2));
    }

    @Override
    public void setRequestWaitingTime-LRDsOJo(long l2) {
        this.performanceMetrics.getRequestWaitingTime().set(Duration.getInWholeMilliseconds-impl((long)l2));
    }

    @Override
    public void setContextCollectionTime-LRDsOJo(long l2) {
        this.performanceMetrics.getContextCollectionTime().set(Duration.getInWholeMilliseconds-impl((long)l2));
    }

    @Override
    public void setClientExecutionTime-LRDsOJo(long l2) {
        this.performanceMetrics.getClientExecutionTime().set(Duration.getInWholeMilliseconds-impl((long)l2));
    }

    @Override
    public void setIterationFilterTime-LRDsOJo(long l2) {
        this.performanceMetrics.getIterationFilterTime().set(Duration.getInWholeMilliseconds-impl((long)l2));
    }

    @Override
    public void onPromptComposed(@NotNull String prompt2) {
        Intrinsics.checkNotNullParameter((Object)prompt2, (String)"prompt");
        this.fire(new NextEditPromptComposed(prompt2));
    }

    @Override
    public void onClientResponse(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        this.rawModelOutput.set(string);
        this.fire(new NextEditModelResponse(string));
    }

    @Override
    public void onTargetFile(@NotNull String before, @NotNull String after, @NotNull NextEditSuggestionSimilarityId suggestionId) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        Intrinsics.checkNotNullParameter((Object)suggestionId, (String)"suggestionId");
        this.fire(new NextEditTargetFile(before, after, suggestionId));
    }

    @Override
    public void onDiffComputed(int diffsCount, int totalInsertLength, int totalDeleteLength, int totalInsertedLinesNumber, int totalDeletedLinesNumber) {
        this.totalInsertLength.set(totalInsertLength);
        this.totalDeleteLength.set(totalDeleteLength);
        this.totalInsertedLinesNumber.set(totalInsertedLinesNumber);
        this.totalDeletedLinesNumber.set(totalDeletedLinesNumber);
        this.totalDiffs.set(diffsCount);
        this.fire(new NextEditComputed(diffsCount, totalInsertLength, totalDeleteLength, totalInsertedLinesNumber, totalDeletedLinesNumber));
    }

    @Override
    public void onJumpShown() {
        if (this.timeToShow.get() == null) {
            this.timeToShow.set(this.clock.millis() - this.created);
        }
        this.tryStartShowTime();
        if (!this.jumpShown.get()) {
            this.shownJumps.incrementAndGet();
            this.fire(NextEditJumpShown.INSTANCE);
            this.jumpShown.set(true);
        }
    }

    @Override
    public void onJumpAccepted() {
        this.checkValidity(this.jumpShown.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onJumpAccepted$lambda$0));
        this.tryIncrementShowDuration();
        this.acceptedJumps.incrementAndGet();
        this.fire(NextEditJumpAccepted.INSTANCE);
        this.jumpShown.set(false);
    }

    @Override
    public void onStepShown(int stepIndex, @NotNull NextEditStepViewType viewType, int startOffset, int endOffset) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        this.recordStepViewType(stepIndex, viewType);
        if (this.timeToShow.get() == null) {
            this.timeToShow.set(this.clock.millis() - this.created);
        }
        this.tryStartShowTime();
        if (!this.diffShown.get()) {
            this.shownDiffs.incrementAndGet();
            this.checkValidity(this.shownDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onStepShown$lambda$0));
            this.fire(new NextEditDiffShown(startOffset, endOffset));
            this.diffShown.set(true);
        }
    }

    private final void recordStepViewType(int stepIndex, NextEditStepViewType viewType) {
        List<NextEditStepViewType> stepsType = this.stepsRawDescription.getShownStepsViewType();
        while (stepsType.size() <= stepIndex) {
            stepsType.add(NextEditStepViewType.UNKNOWN);
        }
        stepsType.set(stepIndex, viewType);
    }

    @Override
    public void onDiffAccepted(int diffIndex, int startOffset1, int endOffset1, int startOffset2, int endOffset2, int startLine1, int endLine1, int startLine2, int endLine2, int insertedLength, int deletedLength, int insertedLinesNumber, int deletedLinesNumber, @NotNull String oldText, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)oldText, (String)"oldText");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        this.acceptedDiffs.incrementAndGet();
        this.checkValidity(this.acceptedDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onDiffAccepted$lambda$0));
        this.checkValidity(this.diffShown.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onDiffAccepted$lambda$1));
        this.tryIncrementShowDuration();
        this.acceptedDiffsContents.add(new NextEditDiffContent(oldText, newText, startLine1, endLine1, startLine2, endLine2));
        this.fire(new NextEditDiffAccepted(diffIndex, this.totalDiffs.get(), startOffset1, endOffset1, startOffset2, endOffset2, insertedLength, deletedLength));
        this.insertedLength.addAndGet(insertedLength);
        this.deletedLength.addAndGet(deletedLength);
        this.insertedLinesNumber.addAndGet(insertedLinesNumber);
        this.deletedLinesNumber.addAndGet(deletedLinesNumber);
        this.diffShown.set(false);
        this.jumpShown.set(false);
    }

    @Override
    public void onActionAccepted(int startLine, int endLine, @NotNull String actionId, @NotNull Map<String, String> actionLogParams) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        Intrinsics.checkNotNullParameter(actionLogParams, (String)"actionLogParams");
        this.acceptedDiffs.incrementAndGet();
        this.checkValidity(this.acceptedDiffs.get() <= this.totalDiffs.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onActionAccepted$lambda$0));
        this.checkValidity(this.diffShown.get(), (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onActionAccepted$lambda$1));
        this.tryIncrementShowDuration();
        this.acceptedActionsContents.add(new NextEditActionContent(actionId, actionLogParams, startLine, endLine));
        this.fire(new NextEditActionContent(actionId, actionLogParams, startLine, endLine));
        this.diffShown.set(false);
        this.jumpShown.set(false);
    }

    @Override
    public void setEditableRegion(int start2, int end) {
        this.editableRegion.set((Pair<Integer, Integer>)TuplesKt.to((Object)start2, (Object)end));
    }

    public final void onSessionFinished(@NotNull NextEditSessionFinishType finishType, @Nullable EditorId editorId) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
            this.tryIncrementShowDuration();
            Language language = this.language;
            NextEditTriggerReason nextEditTriggerReason = this.triggerReason.get();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)nextEditTriggerReason), (String)"get(...)");
            NextEditTriggerReason nextEditTriggerReason2 = nextEditTriggerReason;
            Pair<Integer, Integer> pair = this.frontendProviderId.get();
            NextEditBackendProviderId nextEditBackendProviderId = this.backendProviderId.get();
            String string = this.taskId.get();
            NextEditIterationFilterDescriptor nextEditIterationFilterDescriptor = this.filterReason.get();
            int n = this.acceptedDiffs.get();
            int n2 = this.shownDiffs.get();
            int n3 = this.totalDiffs.get();
            int n4 = this.acceptedJumps.get();
            int n5 = this.shownJumps.get();
            Long l2 = this.timeToShow.get();
            Long l3 = this.shownDuration.get();
            Long l4 = this.suppressedDurationByInline.get();
            Intrinsics.checkNotNullExpressionValue((Object)l4, (String)"get(...)");
            long l5 = ((Number)l4).longValue();
            Long l6 = this.suppressedDurationByLookup.get();
            Intrinsics.checkNotNullExpressionValue((Object)l6, (String)"get(...)");
            long l7 = ((Number)l6).longValue();
            NextEditPerformanceMetrics nextEditPerformanceMetrics = new NextEditPerformanceMetrics(this.performanceMetrics.getRequestWaitingTime().get(), this.performanceMetrics.getContextCollectionTime().get(), this.performanceMetrics.getClientExecutionTime().get(), this.performanceMetrics.getIterationFilterTime().get(), this.clock.millis() - this.created);
            NextEditStepsDescription nextEditStepsDescription = new NextEditStepsDescription(this.stepsRawDescription.getShownStepsViewType());
            boolean bl = this.invalid.get();
            int n6 = this.insertedLength.get();
            int n7 = this.deletedLength.get();
            int n8 = this.totalInsertLength.get();
            int n9 = this.totalDeleteLength.get();
            int n10 = this.insertedLinesNumber.get();
            int n11 = this.deletedLinesNumber.get();
            int n12 = this.totalInsertedLinesNumber.get();
            int n13 = this.totalDeletedLinesNumber.get();
            List<NextEditDiffContent> list = this.acceptedDiffsContents;
            List<NextEditActionContent> list2 = this.acceptedActionsContents;
            String string2 = this.requestContextJson.get();
            String string3 = this.rawModelOutput.get();
            this.fire(new NextEditSessionFinished(language, nextEditTriggerReason2, (NextEditFrontendProviderId)pair, nextEditBackendProviderId, string, finishType, nextEditIterationFilterDescriptor, n, n2, n3, n4, n5, l2, l3, l5, l7, nextEditPerformanceMetrics, nextEditStepsDescription, bl, n6, n7, n8, n9, n10, n11, n12, n13, list, string2, string3, list2));
            if (!NextEditTraceCollector.INSTANCE.getAlwaysCollectedStates().contains((Object)finishType) && (!NextEditTraceCollector.INSTANCE.getSampledStates().contains((Object)finishType) || !NextEditTraceCollector.INSTANCE.sample(this.requestId))) break block3;
            Pair<Integer, Integer> pair2 = this.editableRegion.get();
            if (pair2 != null) {
                Editor editor2;
                pair = pair2;
                boolean bl2 = false;
                int start2 = ((Number)pair.component1()).intValue();
                int end = ((Number)pair.component2()).intValue();
                EditorId editorId2 = editorId;
                Object object = editor2 = editorId2 != null ? EditorIdKt.findEditorOrNull((EditorId)editorId2) : null;
                if (editor2 != null) {
                    TextRange textRange = new TextRange(Math.min(start2, editor2.getDocument().getTextLength()), Math.min(end, editor2.getDocument().getTextLength()));
                    RangeMarker rangeMarker = editor2.getDocument().createRangeMarker(textRange);
                    Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
                    RangeMarker rangeMarker2 = rangeMarker;
                    boolean $i$f$service = false;
                    Class<NextEditSessionTracker> serviceClass$iv = NextEditSessionTracker.class;
                    Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (object2 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                    }
                    ((NextEditSessionTracker)object2).track(this.requestId, editor2, finishType, rangeMarker2);
                }
            }
        }
    }

    private final boolean isVisible() {
        return this.suppressedStartTimeByInline.get() == null && this.suppressedStartTimeByLookup.get() == null;
    }

    private final void tryStartShowTime() {
        if (!this.isVisible()) {
            return;
        }
        this.shownAt.set(this.clock.millis());
    }

    private final void tryIncrementShowDuration() {
        if (this.shownAt.get() != null && this.isVisible()) {
            Long l2 = this.shownAt.get();
            Intrinsics.checkNotNull((Object)l2);
            long shown = ((Number)l2).longValue();
            this.shownDuration.set(((Number)this.shownDuration.get()).longValue() + this.clock.millis() - shown);
            this.shownAt.set(null);
        }
    }

    private final void checkValidity(boolean condition, Function0<String> lazyMessage) {
        if (!condition) {
            this.fire(new NextEditSessionInvalidState((String)lazyMessage.invoke()));
            this.invalid.set(true);
        }
    }

    @Override
    public void onSuppressedByInline() {
        this.tryIncrementShowDuration();
        this.suppressedStartTimeByInline.set(this.clock.millis());
    }

    @Override
    public void onSuppressedByLookup() {
        this.tryIncrementShowDuration();
        this.suppressedStartTimeByLookup.set(this.clock.millis());
    }

    @Override
    public void onUnsuppressedByInline() {
        Long suppressionStartTime = this.suppressedStartTimeByInline.get();
        this.checkValidity(suppressionStartTime != null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onUnsuppressedByInline$lambda$0));
        Long l2 = suppressionStartTime;
        this.suppressedDurationByInline.set(((Number)this.suppressedDurationByInline.get()).longValue() + this.clock.millis() - (l2 != null ? l2 : 0L));
        this.suppressedStartTimeByInline.set(null);
        this.tryStartShowTime();
    }

    @Override
    public void onUnsuppressedByLookup() {
        Long suppressionStartTime = this.suppressedStartTimeByLookup.get();
        this.checkValidity(suppressionStartTime != null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onUnsuppressedByLookup$lambda$0));
        Long l2 = suppressionStartTime;
        this.suppressedDurationByLookup.set(((Number)this.suppressedDurationByLookup.get()).longValue() + this.clock.millis() - (l2 != null ? l2 : 0L));
        this.suppressedStartTimeByLookup.set(null);
        this.tryStartShowTime();
    }

    @Override
    public void onFilteredSuggestion(@NotNull NextEditIterationFilterDescriptor filterReason) {
        Intrinsics.checkNotNullParameter((Object)((Object)filterReason), (String)"filterReason");
        this.checkValidity(this.filterReason.get() == null, (Function0<String>)((Function0)NextEditSessionEventsReporterImpl::onFilteredSuggestion$lambda$0));
        this.filterReason.set(filterReason);
    }

    private static final DiagnosticEvent fire$lambda$0(NextEditSessionEventsReporterImpl this$0, NextEditEventPayload $nextEditSessionMessage) {
        return (DiagnosticEvent)new NextEditEvent(this$0.requestId, $nextEditSessionMessage);
    }

    private static final String onFrontendProviderSelected$lambda$0(NextEditSessionEventsReporterImpl this$0, NextEditFrontendProviderId $providerId) {
        return "Provider is already set: was " + (Object)((Object)this$0.frontendProviderId.get()) + ", new " + $providerId;
    }

    private static final String onBackendProviderSelected$lambda$0(NextEditSessionEventsReporterImpl this$0, NextEditBackendProviderId $providerId) {
        return "Provider is already set: was " + this$0.backendProviderId.get() + ", new " + $providerId;
    }

    private static final String onJumpAccepted$lambda$0() {
        return "Accepted jump was not shown";
    }

    private static final String onStepShown$lambda$0() {
        return "Shown more diffs than total";
    }

    private static final String onDiffAccepted$lambda$0() {
        return "Accepted more diffs than total";
    }

    private static final String onDiffAccepted$lambda$1() {
        return "Accepted diff was not shown";
    }

    private static final String onActionAccepted$lambda$0() {
        return "Accepted more diffs than total";
    }

    private static final String onActionAccepted$lambda$1() {
        return "Accepted diff was not shown";
    }

    private static final String onUnsuppressedByInline$lambda$0() {
        return "Suppress by inline was not called before unsuppress";
    }

    private static final String onUnsuppressedByLookup$lambda$0() {
        return "Suppress by lookup was not called before unsuppress";
    }

    private static final String onFilteredSuggestion$lambda$0() {
        return "Filter reason is already set";
    }

    public /* synthetic */ NextEditSessionEventsReporterImpl(Language language, Clock clock, DefaultConstructorMarker $constructor_marker) {
        this(language, clock);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/NextEditSessionEventsReporterImpl;", "language", "Lcom/intellij/lang/Language;", "clock", "Ljava/time/Clock;", "intellij.ml.llm.nextEdits.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditSessionEventsReporterImpl of(@NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Clock clock = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"systemUTC(...)");
            return new NextEditSessionEventsReporterImpl(language, clock, null);
        }

        @TestOnly
        @NotNull
        public final NextEditSessionEventsReporterImpl of(@NotNull Language language, @NotNull Clock clock) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            return new NextEditSessionEventsReporterImpl(language, clock, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

