/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.history.impl;

import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.diagnostics.DiagnosticsLoggerKt;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.history.NextEditFileChange;
import com.intellij.ml.llm.nextEdits.backend.history.impl.NextEditFileChangesBatcher;
import com.intellij.ml.llm.nextEdits.backend.history.impl.NextEditFileHistoryDocument;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditFilePath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.EDT;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0016J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0002J\b\u0010\u001a\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl;", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileChangesBatcher;", "<init>", "()V", "state", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State;", "isInBatch", "", "startBatch", "", "tryEndBatch", "", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileChangesBatcher$Update;", "initializeFileIfNeeded", "path", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditFilePath;", "document", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryDocument;", "addChange", "change", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Init;", "updateModificationStamp", "newModificationStamp", "", "clear", "softAssertEdt", "invalidateCurrentBatch", "State", "Companion", "intellij.ml.llm.nextEdits.backend"})
@SourceDebugExtension(value={"SMAP\nNextEditFileChangesBatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditFileChangesBatcher.kt\ncom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl\n+ 2 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,252:1\n25#2:253\n13#3:254\n*S KotlinDebug\n*F\n+ 1 NextEditFileChangesBatcher.kt\ncom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl\n*L\n246#1:253\n246#1:254\n*E\n"})
final class NextEditFileHistoryBatcherImpl
implements NextEditFileChangesBatcher {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private State state = State.Idle.INSTANCE;
    @NotNull
    private static final Logger LOG;
    private static final int MAX_CHANGES_NUMBER = 1000;
    private static final int MAX_PATHS_NUMBER = 10;

    @Override
    public boolean isInBatch() {
        boolean bl;
        State state2 = this.state;
        if (state2 instanceof State.InProgress) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public void startBatch() {
        State state2 = this.state;
        if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            State.InProgress newState = new State.InProgress();
            newState.increaseDepth();
            this.state = newState;
        } else if (state2 instanceof State.InProgress) {
            ((State.InProgress)state2).increaseDepth();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<NextEditFileChangesBatcher.Update> tryEndBatch() {
        Object v0;
        State state2 = this.state;
        if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Trying to finish batch when it's not started", null, (int)2, null);
            v0 = null;
        } else if (state2 instanceof State.InProgress) {
            ((State.InProgress)state2).decreaseDepth();
            if (((State.InProgress)state2).isDepthBalanced()) {
                void var2_2;
                List<NextEditFileChangesBatcher.Update> result2 = ((State.InProgress)state2).getUpdates();
                ((State.InProgress)state2).invalidate();
                this.state = State.Idle.INSTANCE;
                v0 = var2_2;
            } else {
                v0 = null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return v0;
    }

    @Override
    public void initializeFileIfNeeded(@NotNull NextEditFilePath path, @NotNull NextEditFileHistoryDocument document2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        this.softAssertEdt();
        State state2 = this.state;
        if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Trying to initialize file when batch is not started", null, (int)2, null);
        } else if (state2 instanceof State.InProgress) {
            ((State.InProgress)state2).initializeFile(path, document2);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void addChange(@NotNull NextEditFilePath path, @NotNull NextEditFileChange.Init change) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        this.softAssertEdt();
        State state2 = this.state;
        if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Trying to add change when batch is not started", null, (int)2, null);
        } else if (state2 instanceof State.InProgress) {
            ((State.InProgress)state2).addChange(path, change);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void updateModificationStamp(@NotNull NextEditFilePath path, long newModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        State state2 = this.state;
        if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Trying to update modification stamp when batch is not started", null, (int)2, null);
        } else if (state2 instanceof State.InProgress) {
            ((State.InProgress)state2).addStampUpdate(path, newModificationStamp);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void clear() {
        if (this.isInBatch()) {
            this.invalidateCurrentBatch();
        }
        while (this.isInBatch()) {
            this.tryEndBatch();
        }
    }

    private final void softAssertEdt() {
        if (!EDT.isCurrentThreadEdt()) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"[Next Edit] File history batcher: must be called on EDT", null, (int)2, null);
        }
    }

    private final void invalidateCurrentBatch() {
        this.softAssertEdt();
        State state2 = this.state;
        if (Intrinsics.areEqual((Object)state2, (Object)State.Idle.INSTANCE)) {
            DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Trying to invalidate batch when it's not started", null, (int)2, null);
        } else if (state2 instanceof State.InProgress) {
            ((State.InProgress)state2).invalidate();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "MAX_CHANGES_NUMBER", "", "MAX_PATHS_NUMBER", "intellij.ml.llm.nextEdits.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State;", "", "Idle", "InProgress", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State$Idle;", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State$InProgress;", "intellij.ml.llm.nextEdits.backend"})
    private static sealed interface State {

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State$Idle;", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State;", "<init>", "()V", "intellij.ml.llm.nextEdits.backend"})
        public static final class Idle
        implements State {
            @NotNull
            public static final Idle INSTANCE = new Idle();

            private Idle() {
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\nJ\u0016\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\bJ\u0016\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020\u001bJ\u0006\u0010$\u001a\u00020\u001bJ\u0006\u0010%\u001a\u00020\u0010J\u0006\u0010&\u001a\u00020\u001bJ\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State$InProgress;", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State;", "<init>", "()V", "myChanges", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditFilePath;", "", "Lcom/intellij/ml/llm/nextEdits/backend/history/NextEditFileChange$Init;", "pathToInitialContent", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryDocument;", "brokenPaths", "", "myDepth", "", "myIsInvalid", "", "mySize", "isInvalid", "()Z", "size", "getSize", "()I", "getUpdates", "", "Lcom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileChangesBatcher$Update;", "initializeFile", "", "path", "document", "addChange", "change", "addStampUpdate", "newStamp", "", "increaseDepth", "decreaseDepth", "isDepthBalanced", "invalidate", "invalidatePath", "intellij.ml.llm.nextEdits.backend"})
        @SourceDebugExtension(value={"SMAP\nNextEditFileChangesBatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditFileChangesBatcher.kt\ncom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State$InProgress\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,252:1\n136#2,9:253\n216#2:262\n217#2:264\n145#2:265\n1#3:263\n382#4,7:266\n*S KotlinDebug\n*F\n+ 1 NextEditFileChangesBatcher.kt\ncom/intellij/ml/llm/nextEdits/backend/history/impl/NextEditFileHistoryBatcherImpl$State$InProgress\n*L\n167#1:253,9\n167#1:262\n167#1:264\n167#1:265\n167#1:263\n188#1:266,7\n*E\n"})
        public static final class InProgress
        implements State {
            @NotNull
            private final Map<NextEditFilePath, List<NextEditFileChange.Init>> myChanges = new LinkedHashMap();
            @NotNull
            private final Map<NextEditFilePath, NextEditFileHistoryDocument> pathToInitialContent = new LinkedHashMap();
            @NotNull
            private final Set<NextEditFilePath> brokenPaths = new LinkedHashSet();
            private int myDepth;
            private boolean myIsInvalid;
            private int mySize;

            public final boolean isInvalid() {
                return this.myIsInvalid;
            }

            public final int getSize() {
                return this.mySize;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<NextEditFileChangesBatcher.Update> getUpdates() {
                void $this$mapNotNullTo$iv$iv;
                Map<NextEditFilePath, NextEditFileHistoryDocument> $this$mapNotNull$iv = this.pathToInitialContent;
                boolean $i$f$mapNotNull = false;
                Map<NextEditFilePath, NextEditFileHistoryDocument> map2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    NextEditFileChangesBatcher.Update it$iv$iv;
                    List<NextEditFileChange.Init> changes2;
                    Map.Entry element$iv$iv$iv;
                    Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry entry = element$iv$iv;
                    boolean bl2 = false;
                    NextEditFilePath path = (NextEditFilePath)entry.getKey();
                    NextEditFileHistoryDocument initialContent = (NextEditFileHistoryDocument)entry.getValue();
                    if ((this.brokenPaths.contains(path) ? null : (this.myChanges.get(path) == null ? null : new NextEditFileChangesBatcher.Update(path, initialContent, changes2))) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }

            public final void initializeFile(@NotNull NextEditFilePath path, @NotNull NextEditFileHistoryDocument document2) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
                if (this.isInvalid() || this.brokenPaths.contains(path) || this.pathToInitialContent.containsKey(path)) {
                    return;
                }
                this.pathToInitialContent.put(path, document2);
            }

            /*
             * WARNING - void declaration
             */
            public final void addChange(@NotNull NextEditFilePath path, @NotNull NextEditFileChange.Init change) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                if (this.isInvalid() || this.brokenPaths.contains(path) || this.pathToInitialContent.get(path) == null) {
                    return;
                }
                Map<NextEditFilePath, List<NextEditFileChange.Init>> map2 = this.myChanges;
                NextEditFilePath key$iv = path;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                List pathChanges = (List)object;
                NextEditFileChange.Init init = (NextEditFileChange.Init)CollectionsKt.lastOrNull((List)pathChanges);
                Long lastStamp = init != null ? Long.valueOf(init.getNewModificationStamp()) : null;
                long expectedStamp = change.getOldModificationStamp();
                if (lastStamp != null) {
                    long l2 = expectedStamp;
                    if (lastStamp != l2) {
                        this.invalidatePath(path);
                        return;
                    }
                }
                ((Collection)pathChanges).add(change);
                int n = this.mySize;
                this.mySize = n + 1;
                if (this.mySize > 1000 || this.myChanges.size() > 10) {
                    DiagnosticsLoggerKt.debug((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), InProgress::addChange$lambda$1);
                    this.invalidate();
                }
            }

            public final void addStampUpdate(@NotNull NextEditFilePath path, long newStamp) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                List<NextEditFileChange.Init> list = this.myChanges.get(path);
                if (list == null) {
                    return;
                }
                List<NextEditFileChange.Init> pathChanges = list;
                if (pathChanges.isEmpty()) {
                    return;
                }
                NextEditFileChange.Init lastChange = (NextEditFileChange.Init)CollectionsKt.last(pathChanges);
                pathChanges.set(CollectionsKt.getLastIndex(pathChanges), NextEditFileChange.Init.copy$default(lastChange, 0, null, null, newStamp, 0L, 0L, 0, 0, 0, 503, null));
            }

            public final void increaseDepth() {
                int n = this.myDepth;
                this.myDepth = n + 1;
            }

            public final void decreaseDepth() {
                int n = this.myDepth;
                this.myDepth = n + -1;
                if (this.myDepth < 0) {
                    DiagnosticsLogger.error$default((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(LOG), (String)"Batch depth is less than 0", null, (int)2, null);
                    this.myDepth = 0;
                }
            }

            public final boolean isDepthBalanced() {
                return this.myDepth == 0;
            }

            public final void invalidate() {
                this.myIsInvalid = true;
                this.myChanges.clear();
                this.brokenPaths.clear();
                this.pathToInitialContent.clear();
                this.myDepth = 0;
                this.mySize = 0;
            }

            private final void invalidatePath(NextEditFilePath path) {
                List<NextEditFileChange.Init> list = this.myChanges.get(path);
                this.mySize -= list != null ? list.size() : 0;
                this.myChanges.remove(path);
                this.brokenPaths.remove(path);
                this.pathToInitialContent.remove(path);
            }

            private static final String addChange$lambda$1() {
                return "File history batcher: too many changes. Batch will be invalidated.";
            }
        }
    }
}

