/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.caches;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.diagnostics.DiagnosticsLogger;
import com.intellij.ml.diagnostics.DiagnosticsLoggerKt;
import com.intellij.ml.llm.nextEdits.backend.diagnostics.BackendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.backend.diff.TextDiffUtils;
import com.intellij.ml.llm.nextEdits.backend.provider.caches.PartialHunkMatcher;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditContext;
import com.intellij.ml.llm.nextEdits.backend.provider.suggestion.NextProposalEditsKt;
import com.intellij.ml.llm.nextEdits.common.diff.Hunk;
import com.intellij.ml.llm.nextEdits.common.diff.TextDiff;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditProposal;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\f\u001a\u00020\rH\u0007J\u0006\u0010\u0011\u001a\u00020\u000bJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0007R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "cache", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntry;", "put", "", "context", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;", "proposal", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;", "tryGet", "invalidate", "debugItems", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$DebugItem;", "CacheEntry", "DebugItem", "Companion", "intellij.ml.llm.nextEdits.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache\n+ 2 BackendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/backend/diagnostics/BackendNextEditDiagnosticsLoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n25#2:98\n13#3:99\n1#4:100\n295#5:101\n1761#5,3:102\n296#5:105\n1563#5:106\n1634#5,3:107\n*S KotlinDebug\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache\n*L\n26#1:98\n26#1:99\n57#1:101\n58#1:102,3\n57#1:105\n85#1:106\n85#1:107,3\n*E\n"})
public final class NextEditCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger LOG;
    @NotNull
    private final Set<CacheEntry> cache;
    private static final long CACHE_SIZE = 10L;

    /*
     * WARNING - void declaration
     */
    public NextEditCache() {
        void it;
        NextEditCache $this$thisNextEditLogger$iv = this;
        boolean $i$f$thisNextEditLogger = false;
        boolean $i$f$logger22 = false;
        Logger logger = Logger.getInstance(NextEditCache.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.LOG = BackendNextEditDiagnosticsLogger.constructor-impl(logger);
        ConcurrentMap $i$f$logger22 = Caffeine.newBuilder().maximumSize(10L).build().asMap();
        NextEditCache nextEditCache = this;
        boolean bl = false;
        Set set = Collections.newSetFromMap((Map)it);
        Intrinsics.checkNotNullExpressionValue(set, (String)"let(...)");
        nextEditCache.cache = set;
    }

    public final void put(@NotNull NextEditContext context2, @NotNull NextEditProposal.Rewrite proposal2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
        this.cache.add(new CacheEntry(context2, proposal2));
    }

    @RequiresBackgroundThread
    @Nullable
    public final NextEditProposal.Rewrite tryGet(@NotNull NextEditContext context2) {
        Object v1;
        block6: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            ThreadingAssertions.assertBackgroundThread();
            Iterable $this$firstOrNull$iv = this.cache;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block5: {
                    CacheEntry cacheEntry = (CacheEntry)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = cacheEntry.getDiff().getHunks();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            Hunk cacheHunk = (Hunk)element$iv2;
                            boolean bl3 = false;
                            if (!PartialHunkMatcher.INSTANCE.isMatch(cacheEntry.getCurrentFile().getContent(), CollectionsKt.emptyList(), cacheHunk, context2)) continue;
                            bl = true;
                            break block5;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block6;
            }
            v1 = null;
        }
        CacheEntry cacheEntry = v1;
        if (cacheEntry == null) {
            return null;
        }
        CacheEntry matchedEntry = cacheEntry;
        NextEditProposal.Rewrite initialProposal = matchedEntry.getProposal();
        DiagnosticsLoggerKt.debug((DiagnosticsLogger)BackendNextEditDiagnosticsLogger.box-impl(this.LOG), () -> NextEditCache.tryGet$lambda$1(matchedEntry));
        TextDiff diff2 = TextDiffUtils.INSTANCE.diff(context2.getCurrentFile().getContent(), matchedEntry.getAfter());
        return NextProposalEditsKt.fromDiff(NextEditProposal.Rewrite.Companion, diff2, initialProposal.getActionHintPresentation(), initialProposal.getPriority(), initialProposal.getForcedIntrusionMode(), initialProposal.getSimilarityId(), initialProposal.getSuggestionKind());
    }

    public final void invalidate() {
        this.cache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public final List<DebugItem> debugItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.cache;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CacheEntry cacheEntry = (CacheEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DebugItem(it.getCurrentFile().getPath().toString(), it.getDiff()));
        }
        return (List)destination$iv$iv;
    }

    private static final String tryGet$lambda$1(CacheEntry $matchedEntry) {
        return "Cache hit for " + $matchedEntry.getCurrentFile().getPath();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$CacheEntry;", "", "context", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;", "proposal", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;)V", "getContext", "()Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;", "getProposal", "()Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditProposal$Rewrite;", "currentFile", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;", "getCurrentFile", "()Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;", "currentFile$delegate", "Lkotlin/Lazy;", "after", "", "getAfter", "()Ljava/lang/String;", "after$delegate", "diff", "Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "getDiff", "()Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "intellij.ml.llm.nextEdits.backend"})
    private static final class CacheEntry {
        @NotNull
        private final NextEditContext context;
        @NotNull
        private final NextEditProposal.Rewrite proposal;
        @NotNull
        private final Lazy currentFile$delegate;
        @NotNull
        private final Lazy after$delegate;

        public CacheEntry(@NotNull NextEditContext context2, @NotNull NextEditProposal.Rewrite proposal2) {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)proposal2, (String)"proposal");
            this.context = context2;
            this.proposal = proposal2;
            this.currentFile$delegate = LazyKt.lazy(() -> CacheEntry.currentFile_delegate$lambda$0(this));
            this.after$delegate = LazyKt.lazy(() -> CacheEntry.after_delegate$lambda$0(this));
        }

        @NotNull
        public final NextEditContext getContext() {
            return this.context;
        }

        @NotNull
        public final NextEditProposal.Rewrite getProposal() {
            return this.proposal;
        }

        @NotNull
        public final NextEditContext.File getCurrentFile() {
            Lazy lazy = this.currentFile$delegate;
            return (NextEditContext.File)lazy.getValue();
        }

        @NotNull
        public final String getAfter() {
            Lazy lazy = this.after$delegate;
            return (String)lazy.getValue();
        }

        @NotNull
        public final TextDiff getDiff() {
            return this.proposal.getDiff();
        }

        private static final NextEditContext.File currentFile_delegate$lambda$0(CacheEntry this$0) {
            return this$0.context.getCurrentFile();
        }

        private static final String after_delegate$lambda$0(CacheEntry this$0) {
            return TextDiffUtils.INSTANCE.merge(this$0.getCurrentFile().getContent(), this$0.getDiff());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache;", "project", "Lcom/intellij/openapi/project/Project;", "CACHE_SIZE", "", "intellij.ml.llm.nextEdits.backend"})
    @SourceDebugExtension(value={"SMAP\nNextEditCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,97:1\n30#2,2:98\n*S KotlinDebug\n*F\n+ 1 NextEditCache.kt\ncom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$Companion\n*L\n89#1:98,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NextEditCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<NextEditCache> serviceClass$iv = NextEditCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NextEditCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/caches/NextEditCache$DebugItem;", "", "filePath", "", "hunks", "Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "<init>", "(Ljava/lang/String;Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;)V", "getFilePath", "()Ljava/lang/String;", "getHunks", "()Lcom/intellij/ml/llm/nextEdits/common/diff/TextDiff;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.ml.llm.nextEdits.backend"})
    @ApiStatus.Internal
    public static final class DebugItem {
        @NotNull
        private final String filePath;
        @NotNull
        private final TextDiff hunks;

        public DebugItem(@NotNull String filePath, @NotNull TextDiff hunks) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)hunks, (String)"hunks");
            this.filePath = filePath;
            this.hunks = hunks;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final TextDiff getHunks() {
            return this.hunks;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final TextDiff component2() {
            return this.hunks;
        }

        @NotNull
        public final DebugItem copy(@NotNull String filePath, @NotNull TextDiff hunks) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)hunks, (String)"hunks");
            return new DebugItem(filePath, hunks);
        }

        public static /* synthetic */ DebugItem copy$default(DebugItem debugItem, String string, TextDiff textDiff, int n, Object object) {
            if ((n & 1) != 0) {
                string = debugItem.filePath;
            }
            if ((n & 2) != 0) {
                textDiff = debugItem.hunks;
            }
            return debugItem.copy(string, textDiff);
        }

        @NotNull
        public String toString() {
            return "DebugItem(filePath=" + this.filePath + ", hunks=" + this.hunks + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + this.hunks.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DebugItem)) {
                return false;
            }
            DebugItem debugItem = (DebugItem)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)debugItem.filePath)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hunks, (Object)debugItem.hunks);
        }
    }
}

