/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.provider.context;

import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditContext;
import com.intellij.ml.llm.nextEdits.backend.provider.context.NextEditFilePath;
import com.intellij.ml.llm.nextEdits.common.diff.Hunk;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditHistoryBasedContext;", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext;", "currentFile", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;", "caretOffset", "", "history", "", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditHistoryBasedContext$FileChange;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;ILjava/util/List;)V", "getCurrentFile", "()Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditContext$File;", "getCaretOffset", "()I", "getHistory", "()Ljava/util/List;", "FileChange", "intellij.ml.llm.nextEdits.backend"})
public class NextEditHistoryBasedContext
implements NextEditContext {
    @NotNull
    private final NextEditContext.File currentFile;
    private final int caretOffset;
    @NotNull
    private final List<FileChange> history;

    public NextEditHistoryBasedContext(@NotNull NextEditContext.File currentFile, int caretOffset, @NotNull List<FileChange> history) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.currentFile = currentFile;
        this.caretOffset = caretOffset;
        this.history = history;
    }

    @Override
    @NotNull
    public NextEditContext.File getCurrentFile() {
        return this.currentFile;
    }

    @Override
    public int getCaretOffset() {
        return this.caretOffset;
    }

    @NotNull
    public final List<FileChange> getHistory() {
        return this.history;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditHistoryBasedContext$FileChange;", "", "path", "Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditFilePath;", "hunk", "Lcom/intellij/ml/llm/nextEdits/common/diff/Hunk;", "timestamp", "", "<init>", "(Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditFilePath;Lcom/intellij/ml/llm/nextEdits/common/diff/Hunk;J)V", "getPath", "()Lcom/intellij/ml/llm/nextEdits/backend/provider/context/NextEditFilePath;", "getHunk", "()Lcom/intellij/ml/llm/nextEdits/common/diff/Hunk;", "getTimestamp", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.ml.llm.nextEdits.backend"})
    public static final class FileChange {
        @NotNull
        private final NextEditFilePath path;
        @NotNull
        private final Hunk hunk;
        private final long timestamp;

        public FileChange(@NotNull NextEditFilePath path, @NotNull Hunk hunk, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
            this.path = path;
            this.hunk = hunk;
            this.timestamp = timestamp;
        }

        @NotNull
        public final NextEditFilePath getPath() {
            return this.path;
        }

        @NotNull
        public final Hunk getHunk() {
            return this.hunk;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final NextEditFilePath component1() {
            return this.path;
        }

        @NotNull
        public final Hunk component2() {
            return this.hunk;
        }

        public final long component3() {
            return this.timestamp;
        }

        @NotNull
        public final FileChange copy(@NotNull NextEditFilePath path, @NotNull Hunk hunk, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)hunk, (String)"hunk");
            return new FileChange(path, hunk, timestamp);
        }

        public static /* synthetic */ FileChange copy$default(FileChange fileChange, NextEditFilePath nextEditFilePath, Hunk hunk, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                nextEditFilePath = fileChange.path;
            }
            if ((n & 2) != 0) {
                hunk = fileChange.hunk;
            }
            if ((n & 4) != 0) {
                l2 = fileChange.timestamp;
            }
            return fileChange.copy(nextEditFilePath, hunk, l2);
        }

        @NotNull
        public String toString() {
            return "FileChange(path=" + this.path + ", hunk=" + this.hunk + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            int result2 = this.path.hashCode();
            result2 = result2 * 31 + this.hunk.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FileChange)) {
                return false;
            }
            FileChange fileChange = (FileChange)other;
            if (!Intrinsics.areEqual((Object)this.path, (Object)fileChange.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hunk, (Object)fileChange.hunk)) {
                return false;
            }
            return this.timestamp == fileChange.timestamp;
        }
    }
}

