/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.backend.util;

import com.intellij.ml.llm.nextEdits.backend.settings.lang.UniversalLanguageNextEditSettings;
import com.intellij.ml.llm.privacy.PrivacyPathCheckerKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u0005*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/nextEdits/backend/util/IgnoredUtils;", "", "<init>", "()V", "isPrivacyIgnored", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "allowedExtensions", "", "", "forbiddenExtensions", "isDockerfile", "(Lcom/intellij/openapi/vfs/VirtualFile;)Z", "isNotSupportedFile", "isIgnored", "intellij.ml.llm.nextEdits.backend"})
public final class IgnoredUtils {
    @NotNull
    public static final IgnoredUtils INSTANCE = new IgnoredUtils();
    @NotNull
    private static final Set<String> allowedExtensions;
    @NotNull
    private static final Set<String> forbiddenExtensions;

    private IgnoredUtils() {
    }

    private final boolean isPrivacyIgnored(VirtualFile virtualFile2, Project project2) {
        return PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile2);
    }

    private final boolean isDockerfile(VirtualFile $this$isDockerfile) {
        String string = $this$isDockerfile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return StringsKt.endsWith$default((String)string, (String)"Dockerfile", (boolean)false, (int)2, null);
    }

    private final boolean isNotSupportedFile(VirtualFile virtualFile2) {
        String string;
        block7: {
            block6: {
                if (this.isDockerfile(virtualFile2)) {
                    return false;
                }
                string = virtualFile2.getExtension();
                if (string == null) break block6;
                String string2 = string.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                string = string2;
                if (string2 != null) break block7;
            }
            return true;
        }
        String extension = string;
        if (forbiddenExtensions.contains(extension)) {
            return true;
        }
        if (UniversalLanguageNextEditSettings.Companion.isEnabled()) {
            return false;
        }
        return !allowedExtensions.contains(extension);
    }

    public final boolean isIgnored(@NotNull VirtualFile virtualFile2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (this.isPrivacyIgnored(virtualFile2, project2)) {
            return true;
        }
        return this.isNotSupportedFile(virtualFile2);
    }

    static {
        Object[] objectArray = new String[]{"java", "kt", "py", "ipynb", "json", "yaml", "yml", "md", "go", "js", "ts", "jsx", "tsx", "vue", "svelte", "astro", "html", "css", "scss", "less", "styl", "cpp", "c", "hpp", "h", "php", "php3", "php4", "php5", "phps", "php7", "phpt", "pht", "cs", "csx", "rb", "erb", "rs", "xml", "dockerfile"};
        allowedExtensions = SetsKt.setOf((Object[])objectArray);
        objectArray = new String[]{"key", "pem", "crt", "pfx", "p12", "asc", "gpg", "jks", "keystore", "env", "vault", "passwd", "cred", "credentials", "conf", "ini", "bak", "backup", "token", "session", "rdp", "kdbx", "dsn", "lic", "exe", "dll", "zip", "tar", "gz", "bz2", "dmp"};
        forbiddenExtensions = SetsKt.setOf((Object[])objectArray);
    }
}

