/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.common;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0014\u0010\u000b\u001a\u00020\f*\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/common/PsiFileUtils;", "", "<init>", "()V", "getPsiFile", "Lcom/intellij/psi/PsiFile;", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "editorDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLanguage", "Lcom/intellij/lang/Language;", "offset", "", "intellij.ml.llm.nextEdits.common"})
@ApiStatus.Internal
public final class PsiFileUtils {
    @NotNull
    public static final PsiFileUtils INSTANCE = new PsiFileUtils();

    private PsiFileUtils() {
    }

    @RequiresReadLock
    @Nullable
    public final PsiFile getPsiFile(@NotNull Editor $this$getPsiFile, @NotNull Project project2, @NotNull DataContext editorDataContext) {
        Intrinsics.checkNotNullParameter((Object)$this$getPsiFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editorDataContext, (String)"editorDataContext");
        ThreadingAssertions.assertReadAccess();
        ThreadingAssertions.assertBackgroundThread();
        PsiFile psiFile = (PsiFile)editorDataContext.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            psiFile = PsiDocumentManager.getInstance((Project)project2).getCachedPsiFile($this$getPsiFile.getDocument());
        }
        return psiFile;
    }

    @RequiresReadLock
    @NotNull
    public final Language getLanguage(@NotNull PsiFile $this$getLanguage, int offset) {
        Intrinsics.checkNotNullParameter((Object)$this$getLanguage, (String)"<this>");
        ThreadingAssertions.assertReadAccess();
        PsiFile psiFile = PsiUtilBase.getPsiFileAtOffset((PsiFile)$this$getLanguage, (int)offset);
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            Language language = $this$getLanguage.getLanguage();
            psiFile = language;
            Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        }
        return psiFile;
    }
}

