/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.request;

import com.intellij.lang.Language;
import com.intellij.ml.llm.nextEdits.common.NextEditTriggerReason;
import com.intellij.ml.llm.nextEdits.common.provider.NextEditRequestId;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u00014BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\b\u0010$\u001a\u00020%H\u0007J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\t\u0010(\u001a\u00020\u0007H\u00c6\u0003J\t\u0010)\u001a\u00020\tH\u00c6\u0003J\t\u0010*\u001a\u00020\u000bH\u00c6\u0003J\t\u0010+\u001a\u00020\rH\u00c6\u0003J\t\u0010,\u001a\u00020\u000fH\u00c6\u0003J\t\u0010-\u001a\u00020\u0011H\u00c6\u0003JY\u0010.\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u00c6\u0001J\u0013\u0010/\u001a\u00020%2\b\u00100\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00101\u001a\u00020\tH\u00d6\u0001J\t\u00102\u001a\u000203H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest;", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "language", "Lcom/intellij/lang/Language;", "caretOffset", "", "snapshot", "Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest$LightweightEditorSnapshot;", "timestamp", "", "triggerReason", "Lcom/intellij/ml/llm/nextEdits/common/NextEditTriggerReason;", "id", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditRequestId;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;Lcom/intellij/lang/Language;ILcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest$LightweightEditorSnapshot;JLcom/intellij/ml/llm/nextEdits/common/NextEditTriggerReason;Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditRequestId;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "getLanguage", "()Lcom/intellij/lang/Language;", "getCaretOffset", "()I", "getSnapshot", "()Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest$LightweightEditorSnapshot;", "getTimestamp", "()J", "getTriggerReason", "()Lcom/intellij/ml/llm/nextEdits/common/NextEditTriggerReason;", "getId", "()Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditRequestId;", "isValid", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "other", "hashCode", "toString", "", "LightweightEditorSnapshot", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditRequest {
    @NotNull
    private final Editor editor;
    @NotNull
    private final PsiFile psiFile;
    @NotNull
    private final Language language;
    private final int caretOffset;
    @NotNull
    private final LightweightEditorSnapshot snapshot;
    private final long timestamp;
    @NotNull
    private final NextEditTriggerReason triggerReason;
    @NotNull
    private final NextEditRequestId id;

    public NextEditRequest(@NotNull Editor editor2, @NotNull PsiFile psiFile, @NotNull Language language, int caretOffset, @NotNull LightweightEditorSnapshot snapshot, long timestamp, @NotNull NextEditTriggerReason triggerReason, @NotNull NextEditRequestId id) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)((Object)triggerReason), (String)"triggerReason");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.editor = editor2;
        this.psiFile = psiFile;
        this.language = language;
        this.caretOffset = caretOffset;
        this.snapshot = snapshot;
        this.timestamp = timestamp;
        this.triggerReason = triggerReason;
        this.id = id;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    public final int getCaretOffset() {
        return this.caretOffset;
    }

    @NotNull
    public final LightweightEditorSnapshot getSnapshot() {
        return this.snapshot;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final NextEditTriggerReason getTriggerReason() {
        return this.triggerReason;
    }

    @NotNull
    public final NextEditRequestId getId() {
        return this.id;
    }

    @RequiresReadLock
    public final boolean isValid() {
        if (this.editor.isDisposed()) {
            return false;
        }
        if (this.editor.getCaretModel().getCaretCount() != 1) {
            return false;
        }
        LogicalPosition logicalPosition = this.editor.getCaretModel().getLogicalPosition();
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
        LogicalPosition currentCaretPosition = logicalPosition;
        long modificationStamp = this.editor.getDocument().getModificationStamp();
        return this.snapshot.getModificationStamp() == modificationStamp && this.snapshot.getCaretPosition().line == currentCaretPosition.line;
    }

    @NotNull
    public final Editor component1() {
        return this.editor;
    }

    @NotNull
    public final PsiFile component2() {
        return this.psiFile;
    }

    @NotNull
    public final Language component3() {
        return this.language;
    }

    public final int component4() {
        return this.caretOffset;
    }

    @NotNull
    public final LightweightEditorSnapshot component5() {
        return this.snapshot;
    }

    public final long component6() {
        return this.timestamp;
    }

    @NotNull
    public final NextEditTriggerReason component7() {
        return this.triggerReason;
    }

    @NotNull
    public final NextEditRequestId component8() {
        return this.id;
    }

    @NotNull
    public final NextEditRequest copy(@NotNull Editor editor2, @NotNull PsiFile psiFile, @NotNull Language language, int caretOffset, @NotNull LightweightEditorSnapshot snapshot, long timestamp, @NotNull NextEditTriggerReason triggerReason, @NotNull NextEditRequestId id) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Intrinsics.checkNotNullParameter((Object)((Object)triggerReason), (String)"triggerReason");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new NextEditRequest(editor2, psiFile, language, caretOffset, snapshot, timestamp, triggerReason, id);
    }

    public static /* synthetic */ NextEditRequest copy$default(NextEditRequest nextEditRequest, Editor editor2, PsiFile psiFile, Language language, int n, LightweightEditorSnapshot lightweightEditorSnapshot, long l2, NextEditTriggerReason nextEditTriggerReason, NextEditRequestId nextEditRequestId, int n2, Object object) {
        if ((n2 & 1) != 0) {
            editor2 = nextEditRequest.editor;
        }
        if ((n2 & 2) != 0) {
            psiFile = nextEditRequest.psiFile;
        }
        if ((n2 & 4) != 0) {
            language = nextEditRequest.language;
        }
        if ((n2 & 8) != 0) {
            n = nextEditRequest.caretOffset;
        }
        if ((n2 & 0x10) != 0) {
            lightweightEditorSnapshot = nextEditRequest.snapshot;
        }
        if ((n2 & 0x20) != 0) {
            l2 = nextEditRequest.timestamp;
        }
        if ((n2 & 0x40) != 0) {
            nextEditTriggerReason = nextEditRequest.triggerReason;
        }
        if ((n2 & 0x80) != 0) {
            nextEditRequestId = nextEditRequest.id;
        }
        return nextEditRequest.copy(editor2, psiFile, language, n, lightweightEditorSnapshot, l2, nextEditTriggerReason, nextEditRequestId);
    }

    @NotNull
    public String toString() {
        return "NextEditRequest(editor=" + this.editor + ", psiFile=" + this.psiFile + ", language=" + this.language + ", caretOffset=" + this.caretOffset + ", snapshot=" + this.snapshot + ", timestamp=" + this.timestamp + ", triggerReason=" + this.triggerReason + ", id=" + this.id + ")";
    }

    public int hashCode() {
        int result2 = this.editor.hashCode();
        result2 = result2 * 31 + this.psiFile.hashCode();
        result2 = result2 * 31 + this.language.hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.caretOffset);
        result2 = result2 * 31 + this.snapshot.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.timestamp);
        result2 = result2 * 31 + this.triggerReason.hashCode();
        result2 = result2 * 31 + this.id.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NextEditRequest)) {
            return false;
        }
        NextEditRequest nextEditRequest = (NextEditRequest)other;
        if (!Intrinsics.areEqual((Object)this.editor, (Object)nextEditRequest.editor)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.psiFile, (Object)nextEditRequest.psiFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.language, (Object)nextEditRequest.language)) {
            return false;
        }
        if (this.caretOffset != nextEditRequest.caretOffset) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.snapshot, (Object)nextEditRequest.snapshot)) {
            return false;
        }
        if (this.timestamp != nextEditRequest.timestamp) {
            return false;
        }
        if (this.triggerReason != nextEditRequest.triggerReason) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.id, (Object)nextEditRequest.id);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/request/NextEditRequest$LightweightEditorSnapshot;", "", "modificationStamp", "", "caretPosition", "Lcom/intellij/openapi/editor/LogicalPosition;", "<init>", "(JLcom/intellij/openapi/editor/LogicalPosition;)V", "getModificationStamp", "()J", "getCaretPosition", "()Lcom/intellij/openapi/editor/LogicalPosition;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class LightweightEditorSnapshot {
        private final long modificationStamp;
        @NotNull
        private final LogicalPosition caretPosition;

        public LightweightEditorSnapshot(long modificationStamp, @NotNull LogicalPosition caretPosition) {
            Intrinsics.checkNotNullParameter((Object)caretPosition, (String)"caretPosition");
            this.modificationStamp = modificationStamp;
            this.caretPosition = caretPosition;
        }

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final LogicalPosition getCaretPosition() {
            return this.caretPosition;
        }
    }
}

