/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.session;

import com.intellij.ml.llm.nextEdits.common.NextEditSessionFinishType;
import com.intellij.ml.llm.nextEdits.common.settings.NextEditBehaviourSettings;
import com.intellij.ml.llm.nextEdits.frontend.listeners.CaretEventType;
import com.intellij.ml.llm.nextEdits.frontend.logs.FrontendNextEditEventsReporter;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSession;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionListener;
import com.intellij.ml.llm.nextEdits.frontend.session.NextEditSessionProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u0004\u0018\u00010\nJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u0013J\u0015\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u0017J%\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0001\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;)V", "session", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSession;", "getSession", "finishSession", "", "finishType", "Lcom/intellij/ml/llm/nextEdits/common/NextEditSessionFinishType;", "onDocumentEvent", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "onDocumentEvent$intellij_ml_llm_nextEdits_frontend", "onCaretEvent", "type", "Lcom/intellij/ml/llm/nextEdits/frontend/listeners/CaretEventType;", "onCaretEvent$intellij_ml_llm_nextEdits_frontend", "tryToStartNewSession", "", "sessionProgress", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionProgress;", "reporter", "Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;", "behaviourSettings", "Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;", "tryToStartNewSession$intellij_ml_llm_nextEdits_frontend", "dispose", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
public final class NextEditSessionManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private AtomicReference<NextEditSession> session;
    @NotNull
    private static final Key<NextEditSessionManager> KEY = new Key("next.edit.session.manager");

    private NextEditSessionManager(Editor editor2, Project project2) {
        this.editor = editor2;
        this.project = project2;
        this.session = new AtomicReference<Object>(null);
    }

    @Nullable
    public final NextEditSession getSession() {
        return this.session.get();
    }

    @RequiresEdt
    public final void finishSession(@NotNull NextEditSessionFinishType finishType) {
        Intrinsics.checkNotNullParameter((Object)((Object)finishType), (String)"finishType");
        ThreadingAssertions.assertEventDispatchThread();
        NextEditSession nextEditSession = this.session.get();
        if (nextEditSession == null) {
            return;
        }
        NextEditSession currentSession = nextEditSession;
        currentSession.reportSessionFinished(finishType);
        Disposer.dispose((Disposable)currentSession);
        this.session.compareAndSet(currentSession, null);
        ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterSessionFinished(this.editor, currentSession, finishType);
    }

    @RequiresEdt
    public final void onDocumentEvent$intellij_ml_llm_nextEdits_frontend(@NotNull DocumentEvent event2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSession nextEditSession = this.session.get();
            if (nextEditSession == null) break block0;
            nextEditSession.onDocumentEvent(event2);
        }
    }

    @RequiresEdt
    public final void onCaretEvent$intellij_ml_llm_nextEdits_frontend(@NotNull CaretEventType type2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSession nextEditSession = this.session.get();
            if (nextEditSession == null) break block0;
            nextEditSession.onCaretEvent(type2);
        }
    }

    @RequiresEdt
    public final boolean tryToStartNewSession$intellij_ml_llm_nextEdits_frontend(@NotNull NextEditSessionProgress sessionProgress, @NotNull FrontendNextEditEventsReporter reporter, @NotNull NextEditBehaviourSettings behaviourSettings) {
        NextEditSession newSession;
        Intrinsics.checkNotNullParameter((Object)sessionProgress, (String)"sessionProgress");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)behaviourSettings, (String)"behaviourSettings");
        ThreadingAssertions.assertEventDispatchThread();
        NextEditSession currentSession = this.session.get();
        if (currentSession != null) {
            if (!currentSession.canBeDestroyed()) {
                return false;
            }
            this.finishSession(NextEditSessionFinishType.NEW_SESSION);
        }
        if (this.session.compareAndSet(null, newSession = new NextEditSession(this.editor, this.project, sessionProgress, reporter, behaviourSettings, (Function1<? super NextEditSessionFinishType, Unit>)((Function1)arg_0 -> NextEditSessionManager.tryToStartNewSession$lambda$0(this, arg_0))))) {
            ((NextEditSessionListener)this.project.getMessageBus().syncPublisher(NextEditSessionListener.Companion.getTOPIC())).afterSessionStarted(this.editor, newSession);
        } else {
            Disposer.dispose((Disposable)newSession);
        }
        return true;
    }

    public void dispose() {
        this.finishSession(NextEditSessionFinishType.MANAGER_DISPOSED);
    }

    private static final Unit tryToStartNewSession$lambda$0(NextEditSessionManager this$0, NextEditSessionFinishType it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        this$0.finishSession(it);
        return Unit.INSTANCE;
    }

    public /* synthetic */ NextEditSessionManager(Editor editor2, Project project2, DefaultConstructorMarker $constructor_marker) {
        this(editor2, project2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionManager$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionManager;", "install", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "uninstall", "getInstance", "intellij.ml.llm.nextEdits.frontend"})
    @SourceDebugExtension(value={"SMAP\nNextEditSessionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditSessionManager.kt\ncom/intellij/ml/llm/nextEdits/frontend/session/NextEditSessionManager$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,115:1\n1#2:116\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @RequiresEdt
        public final void install(@NotNull Editor editor2, @NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSessionManager manager = new NextEditSessionManager(editor2, project2, null);
            editor2.putUserData(KEY, (Object)manager);
            EditorUtil.disposeWithEditor((Editor)editor2, () -> Companion.install$lambda$0(editor2));
        }

        @RequiresEdt
        public final void uninstall(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            ThreadingAssertions.assertEventDispatchThread();
            NextEditSessionManager nextEditSessionManager = (NextEditSessionManager)editor2.getUserData(KEY);
            if (nextEditSessionManager != null) {
                NextEditSessionManager it = nextEditSessionManager;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
            editor2.putUserData(KEY, null);
        }

        @Nullable
        public final NextEditSessionManager getInstance(@NotNull Editor editor2) {
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            return (NextEditSessionManager)editor2.getUserData(KEY);
        }

        private static final void install$lambda$0(Editor $editor) {
            Companion.uninstall($editor);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

