/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.session.step.controller;

import com.intellij.ml.llm.nextEdits.common.diff.NextEditLineFragment;
import com.intellij.ml.llm.nextEdits.common.provider.ActionHintPresentation;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.feedback.NextEditSurveyStateComponent;
import com.intellij.ml.llm.nextEdits.frontend.session.Promise;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.SuppressSessionGuardPurpose;
import com.intellij.ml.llm.nextEdits.frontend.session.highlight.NextEditHighlightingInfo;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditGeneralDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditStepController;
import com.intellij.ml.llm.nextEdits.frontend.ui.refresh.NextEditViewRefreshReason;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditEditorUtil;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditGeneralDiffDisplayer;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditStepDisplayer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditGeneralDiffController;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditDiffController$Base;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;", "diff", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "highlighting", "Lcom/intellij/ml/llm/nextEdits/frontend/session/Promise;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/highlight/NextEditHighlightingInfo;", "actionHintPresentation", "Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;", "<init>", "(Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;Lcom/intellij/openapi/fileTypes/FileType;Lcom/intellij/ml/llm/nextEdits/frontend/session/Promise;Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;)V", "getDisplayer", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditStepDisplayer;", "handleAfterAccept", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "makeVisible", "getSuppressHandlerType", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditStepController$SuppressHandlerType;", "suppressPurpose", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/SuppressSessionGuardPurpose;", "shouldRefreshOn", "", "reason", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshReason;", "getOffsetToJump", "", "onRepresentationUpdated", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditStepController$RepresentationUpdateHandler;", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditGeneralDiffController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditGeneralDiffController.kt\ncom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditGeneralDiffController\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,107:1\n158#2,6:108\n119#3:114\n*S KotlinDebug\n*F\n+ 1 NextEditGeneralDiffController.kt\ncom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditGeneralDiffController\n*L\n92#1:108,6\n104#1:114\n*E\n"})
public final class NextEditGeneralDiffController
extends NextEditDiffController.Base<NextEditGeneralDiffModel> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final FileType fileType;
    @NotNull
    private final Promise<NextEditHighlightingInfo> highlighting;
    @Nullable
    private final ActionHintPresentation actionHintPresentation;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    public NextEditGeneralDiffController(@NotNull NextEditGeneralDiffModel diff2, @NotNull FileType fileType2, @NotNull Promise<NextEditHighlightingInfo> highlighting2, @Nullable ActionHintPresentation actionHintPresentation) {
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Intrinsics.checkNotNullParameter(highlighting2, (String)"highlighting");
        super((NextEditDiffModel)diff2);
        this.fileType = fileType2;
        this.highlighting = highlighting2;
        this.actionHintPresentation = actionHintPresentation;
    }

    @Override
    @NotNull
    public NextEditStepDisplayer getDisplayer() {
        return new NextEditGeneralDiffDisplayer((NextEditGeneralDiffModel)this.getDiff(), this.fileType, NextEditHighlightingInfo.Companion.orEmpty(this.highlighting.getIfReady()), this.actionHintPresentation);
    }

    @Override
    protected void handleAfterAccept(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        NextEditSurveyStateComponent.Companion.getInstance().fireGeneralReplaceAccepted();
        NextEditLineFragment fragment = ((NextEditGeneralDiffModel)this.getDiff()).getOrigin().getFragment();
        if (fragment.getStartOffset2() == fragment.getEndOffset2()) {
            return;
        }
        int jumpOffset = Math.min(fragment.getEndOffset2(), editor2.getDocument().getTextLength());
        if (editor2.getDocument().getCharsSequence().charAt(jumpOffset - 1) == '\n') {
            --jumpOffset;
        }
        editor2.getCaretModel().moveToOffset(jumpOffset);
        NextEditEditorUtil.INSTANCE.makeVisible(editor2, jumpOffset);
    }

    @Override
    public void makeVisible(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ThreadingAssertions.assertEventDispatchThread();
        NextEditLineFragment fragment = ((NextEditGeneralDiffModel)this.getDiff()).getOrigin().getFragment();
        NextEditEditorUtil.INSTANCE.makeVisible(editor2, new TextRange(fragment.getStartOffset1(), fragment.getEndOffset1()));
    }

    @Override
    @NotNull
    public NextEditStepController.SuppressHandlerType getSuppressHandlerType(@NotNull Editor editor2, @NotNull Project project2, @NotNull SuppressSessionGuardPurpose suppressPurpose) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)suppressPurpose), (String)"suppressPurpose");
        return switch (WhenMappings.$EnumSwitchMapping$0[suppressPurpose.ordinal()]) {
            case 1 -> NextEditStepController.SuppressHandlerType.SUPPRESS;
            case 2 -> NextEditStepController.SuppressHandlerType.SUPPRESS;
            case 3 -> NextEditStepController.SuppressHandlerType.SUPPRESS;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean shouldRefreshOn(@NotNull Editor editor2, @NotNull Project project2, @NotNull NextEditViewRefreshReason reason) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        NextEditViewRefreshReason nextEditViewRefreshReason = reason;
        if (Intrinsics.areEqual((Object)nextEditViewRefreshReason, (Object)NextEditViewRefreshReason.BlockInlaysChanged.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)nextEditViewRefreshReason, (Object)NextEditViewRefreshReason.FontChanged.INSTANCE)) {
            bl = true;
        } else if (Intrinsics.areEqual((Object)nextEditViewRefreshReason, (Object)NextEditViewRefreshReason.FoldingChanged.INSTANCE)) {
            bl = true;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public int getOffsetToJump(@NotNull Editor editor2, @NotNull Project project2) {
        int firstNonWhitespaceIndex;
        int startOffset;
        block5: {
            int n;
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            startOffset = ((NextEditGeneralDiffModel)this.getDiff()).getOrigin().getFragment().getStartOffset1();
            int endOffset = ((NextEditGeneralDiffModel)this.getDiff()).getOrigin().getFragment().getEndOffset1();
            TextRange editRange = new TextRange(startOffset, endOffset);
            if (editRange.contains(editor2.getCaretModel().getOffset())) {
                return editor2.getCaretModel().getOffset();
            }
            if (editor2.getDocument().getTextLength() < startOffset) {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Incorrect state of general diff: start offset is out of bounds.", null, 2, null);
                return super.getOffsetToJump(editor2, project2);
            }
            if (editor2.getDocument().getTextLength() < endOffset) {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Incorrect state of general diff: end offset is out of bounds.", null, 2, null);
                return super.getOffsetToJump(editor2, project2);
            }
            String string = editor2.getDocument().getText(editRange);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String text2 = string;
            CharSequence $this$indexOfFirst$iv = text2;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block5;
            }
            n = firstNonWhitespaceIndex = -1;
        }
        if (firstNonWhitespaceIndex == -1) {
            return super.getOffsetToJump(editor2, project2);
        }
        return startOffset + firstNonWhitespaceIndex;
    }

    @Override
    @NotNull
    public NextEditStepController.RepresentationUpdateHandler onRepresentationUpdated(@NotNull Editor editor2, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return NextEditStepController.RepresentationUpdateHandler.RERENDER;
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(Companion.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditGeneralDiffController$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SuppressSessionGuardPurpose.values().length];
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_COMPUTING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.INLINE_COMPLETION_SHOWING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SuppressSessionGuardPurpose.LOOKUP_WINDOW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

