/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.plaf.LayerUI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/LayerWithRoundedBorders;", "Ljavax/swing/plaf/LayerUI;", "Ljavax/swing/JComponent;", "color", "Ljava/awt/Color;", "arc", "", "thickness", "<init>", "(Ljava/awt/Color;II)V", "paint", "", "g", "Ljava/awt/Graphics;", "c", "doPaintBorder", "Ljava/awt/Graphics2D;", "intellij.ml.llm.nextEdits.frontend"})
final class LayerWithRoundedBorders
extends LayerUI<JComponent> {
    @Nullable
    private final Color color;
    private final int arc;
    private final int thickness;

    public LayerWithRoundedBorders(@Nullable Color color, int arc, int thickness) {
        this.color = color;
        this.arc = arc;
        this.thickness = thickness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics g, @NotNull JComponent c) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (!(g instanceof Graphics2D) || this.color == null) {
            super.paint(g, c);
            return;
        }
        super.paint(g, c);
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            this.doPaintBorder(g2, c);
        }
        finally {
            g2.dispose();
        }
    }

    private final void doPaintBorder(Graphics2D g, JComponent c) {
        double thicknessDouble = this.thickness;
        double arcDouble = this.arc;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        RoundRectangle2D.Double clip2 = new RoundRectangle2D.Double(thicknessDouble / (double)2, thicknessDouble / (double)2, (double)c.getWidth() - thicknessDouble, (double)c.getHeight() - thicknessDouble, arcDouble, arcDouble);
        g.setStroke(new BasicStroke(this.thickness, 2, 0));
        g.setColor(this.color);
        g.draw(clip2);
    }
}

