/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.diff;

import com.intellij.ml.llm.nextEdits.common.diff.NextEditDiff;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0002\u0016\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;", "", "text", "", "highlightings", "", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting;", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getText", "()Ljava/lang/String;", "getHighlightings", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "Highlighting", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
public final class EnrichedNextEditDiffPresentation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final List<Highlighting> highlightings;

    public EnrichedNextEditDiffPresentation(@NotNull String text2, @NotNull List<? extends Highlighting> highlightings) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        this.text = text2;
        this.highlightings = highlightings;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Highlighting> getHighlightings() {
        return this.highlightings;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final List<Highlighting> component2() {
        return this.highlightings;
    }

    @NotNull
    public final EnrichedNextEditDiffPresentation copy(@NotNull String text2, @NotNull List<? extends Highlighting> highlightings) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter(highlightings, (String)"highlightings");
        return new EnrichedNextEditDiffPresentation(text2, highlightings);
    }

    public static /* synthetic */ EnrichedNextEditDiffPresentation copy$default(EnrichedNextEditDiffPresentation enrichedNextEditDiffPresentation, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = enrichedNextEditDiffPresentation.text;
        }
        if ((n & 2) != 0) {
            list = enrichedNextEditDiffPresentation.highlightings;
        }
        return enrichedNextEditDiffPresentation.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "EnrichedNextEditDiffPresentation(text=" + this.text + ", highlightings=" + this.highlightings + ")";
    }

    public int hashCode() {
        int result2 = this.text.hashCode();
        result2 = result2 * 31 + ((Object)this.highlightings).hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnrichedNextEditDiffPresentation)) {
            return false;
        }
        EnrichedNextEditDiffPresentation enrichedNextEditDiffPresentation = (EnrichedNextEditDiffPresentation)other;
        if (!Intrinsics.areEqual((Object)this.text, (Object)enrichedNextEditDiffPresentation.text)) {
            return false;
        }
        return Intrinsics.areEqual(this.highlightings, enrichedNextEditDiffPresentation.highlightings);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation;", "contentUpdate", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff$ContentUpdate;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EnrichedNextEditDiffPresentation of(@NotNull NextEditDiff.ContentUpdate contentUpdate) {
            Intrinsics.checkNotNullParameter((Object)contentUpdate, (String)"contentUpdate");
            String text2 = contentUpdate.getAfter();
            int offsetShift = 0;
            List highlightings = new ArrayList();
            for (NextEditDiff.Change change : contentUpdate.getChanges()) {
                NextEditDiff.Change change2 = change;
                if (change2 instanceof NextEditDiff.Change.Delete) {
                    String deletedText;
                    int offset = offsetShift + ((NextEditDiff.Change.Delete)change).getStartOffset();
                    Intrinsics.checkNotNullExpressionValue((Object)contentUpdate.getBefore().substring(((NextEditDiff.Change.Delete)change).getStartOffset(), ((NextEditDiff.Change.Delete)change).getEndOffset()), (String)"substring(...)");
                    if (!StringsKt.contains$default((CharSequence)deletedText, (char)'\n', (boolean)false, (int)2, null)) {
                        ((Collection)highlightings).add(new Highlighting.Deletion(offset, Highlighting.Deletion.Type.INLINE));
                    } else if (((NextEditDiff.Change.Delete)change).getEndOffset() == contentUpdate.getBefore().length()) {
                        ((Collection)highlightings).add(new Highlighting.Deletion(offset, Highlighting.Deletion.Type.LINE_BELOW));
                    } else {
                        ((Collection)highlightings).add(new Highlighting.Deletion(offset, Highlighting.Deletion.Type.LINE_ABOVE));
                    }
                    offsetShift -= deletedText.length();
                    continue;
                }
                if (change2 instanceof NextEditDiff.Change.Insert) {
                    ((Collection)highlightings).add(new Highlighting.Addition(((NextEditDiff.Change.Insert)change).getStartOffset() + offsetShift, ((NextEditDiff.Change.Insert)change).getStartOffset() + ((NextEditDiff.Change.Insert)change).getNewContent().length() + offsetShift));
                    offsetShift += ((NextEditDiff.Change.Insert)change).getNewContent().length();
                    continue;
                }
                if (change2 instanceof NextEditDiff.Change.Replace) {
                    ((Collection)highlightings).add(new Highlighting.Modification(((NextEditDiff.Change.Replace)change).getStartOffset() + offsetShift, ((NextEditDiff.Change.Replace)change).getStartOffset() + ((NextEditDiff.Change.Replace)change).getNewContent().length() + offsetShift));
                    offsetShift += ((NextEditDiff.Change.Replace)change).getNewContent().length() - (((NextEditDiff.Change.Replace)change).getEndOffset() - ((NextEditDiff.Change.Replace)change).getStartOffset());
                    continue;
                }
                throw new NoWhenBranchMatchedException();
            }
            return new EnrichedNextEditDiffPresentation(text2, highlightings);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0004\u0006\u0007\b\tR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\n\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting;", "", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Ranged", "Addition", "Deletion", "Modification", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Deletion;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Ranged;", "intellij.ml.llm.nextEdits.frontend"})
    public static sealed interface Highlighting {
        @NotNull
        public TextAttributesKey getAttributesKey();

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Addition;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Ranged;", "startOffset", "", "endOffset", "<init>", "(II)V", "getStartOffset", "()I", "getEndOffset", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.ml.llm.nextEdits.frontend"})
        public static final class Addition
        implements Ranged {
            private final int startOffset;
            private final int endOffset;

            public Addition(int startOffset, int endOffset) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }

            @Override
            public int getStartOffset() {
                return this.startOffset;
            }

            @Override
            public int getEndOffset() {
                return this.endOffset;
            }

            @Override
            @NotNull
            public TextAttributesKey getAttributesKey() {
                TextAttributesKey textAttributesKey = DiffColors.DIFF_INSERTED;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_INSERTED");
                return textAttributesKey;
            }

            public final int component1() {
                return this.startOffset;
            }

            public final int component2() {
                return this.endOffset;
            }

            @NotNull
            public final Addition copy(int startOffset, int endOffset) {
                return new Addition(startOffset, endOffset);
            }

            public static /* synthetic */ Addition copy$default(Addition addition, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = addition.startOffset;
                }
                if ((n3 & 2) != 0) {
                    n2 = addition.endOffset;
                }
                return addition.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Addition(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.startOffset);
                result2 = result2 * 31 + Integer.hashCode(this.endOffset);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Addition)) {
                    return false;
                }
                Addition addition = (Addition)other;
                if (this.startOffset != addition.startOffset) {
                    return false;
                }
                return this.endOffset == addition.endOffset;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001aB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Deletion;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting;", "offset", "", "type", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Deletion$Type;", "<init>", "(ILcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Deletion$Type;)V", "getOffset", "()I", "getType", "()Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Deletion$Type;", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "Type", "intellij.ml.llm.nextEdits.frontend"})
        public static final class Deletion
        implements Highlighting {
            private final int offset;
            @NotNull
            private final Type type;

            public Deletion(int offset, @NotNull Type type2) {
                Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
                this.offset = offset;
                this.type = type2;
            }

            public final int getOffset() {
                return this.offset;
            }

            @NotNull
            public final Type getType() {
                return this.type;
            }

            @Override
            @NotNull
            public TextAttributesKey getAttributesKey() {
                TextAttributesKey textAttributesKey = DiffColors.DIFF_DELETED;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_DELETED");
                return textAttributesKey;
            }

            public final int component1() {
                return this.offset;
            }

            @NotNull
            public final Type component2() {
                return this.type;
            }

            @NotNull
            public final Deletion copy(int offset, @NotNull Type type2) {
                Intrinsics.checkNotNullParameter((Object)((Object)type2), (String)"type");
                return new Deletion(offset, type2);
            }

            public static /* synthetic */ Deletion copy$default(Deletion deletion, int n, Type type2, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = deletion.offset;
                }
                if ((n2 & 2) != 0) {
                    type2 = deletion.type;
                }
                return deletion.copy(n, type2);
            }

            @NotNull
            public String toString() {
                return "Deletion(offset=" + this.offset + ", type=" + this.type + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.offset);
                result2 = result2 * 31 + this.type.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Deletion)) {
                    return false;
                }
                Deletion deletion = (Deletion)other;
                if (this.offset != deletion.offset) {
                    return false;
                }
                return this.type == deletion.type;
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Deletion$Type;", "", "<init>", "(Ljava/lang/String;I)V", "LINE_ABOVE", "LINE_BELOW", "INLINE", "intellij.ml.llm.nextEdits.frontend"})
            public static final class Type
            extends Enum<Type> {
                public static final /* enum */ Type LINE_ABOVE = new Type();
                public static final /* enum */ Type LINE_BELOW = new Type();
                public static final /* enum */ Type INLINE = new Type();
                private static final /* synthetic */ Type[] $VALUES;
                private static final /* synthetic */ EnumEntries $ENTRIES;

                public static Type[] values() {
                    return (Type[])$VALUES.clone();
                }

                public static Type valueOf(String value2) {
                    return Enum.valueOf(Type.class, value2);
                }

                @NotNull
                public static EnumEntries<Type> getEntries() {
                    return $ENTRIES;
                }

                static {
                    $VALUES = typeArray = new Type[]{Type.LINE_ABOVE, Type.LINE_BELOW, Type.INLINE};
                    $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Modification;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Ranged;", "startOffset", "", "endOffset", "<init>", "(II)V", "getStartOffset", "()I", "getEndOffset", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getAttributesKey", "()Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "intellij.ml.llm.nextEdits.frontend"})
        public static final class Modification
        implements Ranged {
            private final int startOffset;
            private final int endOffset;

            public Modification(int startOffset, int endOffset) {
                this.startOffset = startOffset;
                this.endOffset = endOffset;
            }

            @Override
            public int getStartOffset() {
                return this.startOffset;
            }

            @Override
            public int getEndOffset() {
                return this.endOffset;
            }

            @Override
            @NotNull
            public TextAttributesKey getAttributesKey() {
                TextAttributesKey textAttributesKey = DiffColors.DIFF_MODIFIED;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_MODIFIED");
                return textAttributesKey;
            }

            public final int component1() {
                return this.startOffset;
            }

            public final int component2() {
                return this.endOffset;
            }

            @NotNull
            public final Modification copy(int startOffset, int endOffset) {
                return new Modification(startOffset, endOffset);
            }

            public static /* synthetic */ Modification copy$default(Modification modification, int n, int n2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = modification.startOffset;
                }
                if ((n3 & 2) != 0) {
                    n2 = modification.endOffset;
                }
                return modification.copy(n, n2);
            }

            @NotNull
            public String toString() {
                return "Modification(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.startOffset);
                result2 = result2 * 31 + Integer.hashCode(this.endOffset);
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Modification)) {
                    return false;
                }
                Modification modification = (Modification)other;
                if (this.startOffset != modification.startOffset) {
                    return false;
                }
                return this.endOffset == modification.endOffset;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005\u0082\u0001\u0002\b\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Ranged;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting;", "startOffset", "", "getStartOffset", "()I", "endOffset", "getEndOffset", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Addition;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/EnrichedNextEditDiffPresentation$Highlighting$Modification;", "intellij.ml.llm.nextEdits.frontend"})
        public static sealed interface Ranged
        extends Highlighting
        permits Addition, Modification {
            public int getStartOffset();

            public int getEndOffset();
        }
    }
}

