/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.diff;

import com.intellij.ml.llm.nextEdits.common.provider.ActionHintPresentation;
import com.intellij.ml.llm.nextEdits.frontend.FrontendNextEditBundle;
import com.intellij.ml.llm.nextEdits.frontend.editor.NextEditRenderingCustomizer;
import com.intellij.ml.llm.nextEdits.frontend.ui.NextEditColors;
import com.intellij.ml.llm.nextEdits.frontend.ui.NextEditRoundedPanelKt;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.EnrichedNextEditDiffPresentation;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.NextEditStepView;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditInlineShortcutInlaysKt;
import com.intellij.ml.llm.nextEdits.frontend.ui.inlay.NextEditShortcutHint;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.GridAutofitPanel;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditComponentFactory;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditEditorUtil;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditRenderingUtils;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.OverEditorPanelFactory;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditShortcutHintType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J \u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0019\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010\"\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/NextEditDiffSingleModifyView;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/NextEditStepView;", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "startOffset", "", "textAfterModification", "", "initialWordLength", "actionHintPresentation", "Lcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileTypes/FileType;ILjava/lang/String;ILcom/intellij/ml/llm/nextEdits/common/provider/ActionHintPresentation;)V", "show", "", "hintType", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditShortcutHintType;", "dispose", "renderViewPanel", "topLeftOffset", "minimalWidthInPixels", "getDistanceInPixels", "endOffset", "getEnterArrowComponent", "Ljavax/swing/JComponent;", "createViewPanel", "disposable", "Lcom/intellij/openapi/Disposable;", "getNewFragmentComponent", "createShortcutSidebarPanel", "renderEmptyLineBelowIfNeeded", "intellij.ml.llm.nextEdits.frontend"})
public final class NextEditDiffSingleModifyView
implements NextEditStepView {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final FileType fileType;
    private final int startOffset;
    @NotNull
    private final String textAfterModification;
    private final int initialWordLength;
    @Nullable
    private final ActionHintPresentation actionHintPresentation;

    public NextEditDiffSingleModifyView(@NotNull Editor editor2, @NotNull Project project2, @NotNull FileType fileType2, int startOffset, @NotNull String textAfterModification, int initialWordLength, @Nullable ActionHintPresentation actionHintPresentation) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileType2, (String)"fileType");
        Intrinsics.checkNotNullParameter((Object)textAfterModification, (String)"textAfterModification");
        this.editor = editor2;
        this.project = project2;
        this.fileType = fileType2;
        this.startOffset = startOffset;
        this.textAfterModification = textAfterModification;
        this.initialWordLength = initialWordLength;
        this.actionHintPresentation = actionHintPresentation;
    }

    public /* synthetic */ NextEditDiffSingleModifyView(Editor editor2, Project project2, FileType fileType2, int n, String string, int n2, ActionHintPresentation actionHintPresentation, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x40) != 0) {
            actionHintPresentation = null;
        }
        this(editor2, project2, fileType2, n, string, n2, actionHintPresentation);
    }

    @Override
    public void show(@NotNull NextEditShortcutHintType hintType) {
        Intrinsics.checkNotNullParameter((Object)((Object)hintType), (String)"hintType");
        int line = this.editor.getDocument().getLineNumber(this.startOffset);
        int startLineOffset = this.editor.getDocument().getLineStartOffset(line);
        int topLeftOffset = Math.max(startLineOffset, this.startOffset - 1);
        int minimalWidthInPixels = this.getDistanceInPixels(topLeftOffset, this.startOffset + this.initialWordLength) + EditorUtil.getPlainSpaceWidth((Editor)this.editor) * 2;
        this.renderViewPanel(topLeftOffset, minimalWidthInPixels, hintType);
        this.renderEmptyLineBelowIfNeeded();
    }

    public void dispose() {
    }

    private final void renderViewPanel(int topLeftOffset, int minimalWidthInPixels, NextEditShortcutHintType hintType) {
        JComponent viewPanel = this.createViewPanel(minimalWidthInPixels, this);
        JComponent shortcutSidebarPanel = this.createShortcutSidebarPanel(hintType, this);
        Object[] objectArray = new JComponent[]{viewPanel, shortcutSidebarPanel};
        GridAutofitPanel panel2 = new GridAutofitPanel(CollectionsKt.listOf((Object)CollectionsKt.listOfNotNull((Object[])objectArray)));
        panel2.getAccessibleContext().setAccessibleName(FrontendNextEditBundle.message("next.edit.accessible.context.diff.panel", new Object[0]));
        OverEditorPanelFactory panelFactory = new OverEditorPanelFactory(this.editor, this);
        panelFactory.withinBatch((Function0<Unit>)((Function0)() -> NextEditDiffSingleModifyView.renderViewPanel$lambda$0(panelFactory, panel2, topLeftOffset)));
        NextEditRenderingUtils.INSTANCE.drawBackground(this.editor, NextEditColors.BackgroundColor.RED, this.startOffset, this.startOffset + this.initialWordLength, false, this);
    }

    private final int getDistanceInPixels(int startOffset, int endOffset) {
        return this.editor.offsetToXY((int)endOffset).x - this.editor.offsetToXY((int)startOffset).x;
    }

    private final JComponent getEnterArrowComponent() {
        JLabel jLabel;
        String arrow = "\u2937";
        JLabel label = jLabel = new JLabel();
        boolean bl = false;
        label.setText(" " + arrow + " ");
        label.setFont(UIUtil.getFontWithFallbackIfNeeded((Font)NextEditEditorUtil.INSTANCE.getFont(this.editor), (String)arrow));
        Object object = this.editor.getColorsScheme().getAttributes(HighlighterColors.TEXT);
        if (object == null || (object = object.getForegroundColor()) == null) {
            object = label.getForeground();
        }
        label.setForeground((Color)object);
        label.setBackground(this.editor.getColorsScheme().getDefaultBackground());
        return jLabel;
    }

    private final JComponent createViewPanel(int minimalWidthInPixels, Disposable disposable) {
        JComponent topComponent = NextEditComponentFactory.INSTANCE.createEmptyPanel(this.editor, minimalWidthInPixels, 1);
        JComponent enterArrowComponent = this.getEnterArrowComponent();
        JComponent newFragmentComponent = this.getNewFragmentComponent(disposable);
        Object[] objectArray = new List[2];
        objectArray[0] = CollectionsKt.listOf((Object)topComponent);
        Object[] objectArray2 = new JComponent[]{enterArrowComponent, newFragmentComponent};
        objectArray[1] = CollectionsKt.listOf((Object[])objectArray2);
        GridAutofitPanel panel2 = new GridAutofitPanel(CollectionsKt.listOf((Object[])objectArray));
        Color borderColor = this.editor.getColorsScheme().getColor(NextEditColors.INSTANCE.getDIFF_PANEL_BORDER());
        return NextEditRoundedPanelKt.makeRounded$default(panel2, borderColor, 0, 0, 6, null);
    }

    private final JComponent getNewFragmentComponent(Disposable disposable) {
        EnrichedNextEditDiffPresentation.Highlighting.Addition addition = new EnrichedNextEditDiffPresentation.Highlighting.Addition(0, this.textAfterModification.length());
        EditorEx newFragmentEditor = NextEditComponentFactory.createEditor$default(NextEditComponentFactory.INSTANCE, disposable, new EnrichedNextEditDiffPresentation(this.textAfterModification, CollectionsKt.listOf((Object)addition)), this.project, this.fileType, NextEditEditorUtil.INSTANCE.getFontSize(this.editor), 0, null, null, 128, null);
        TextAttributes textAttributes = newFragmentEditor.getColorsScheme().getAttributes(addition.getAttributesKey());
        Color color = textAttributes != null ? textAttributes.getBackgroundColor() : null;
        newFragmentEditor.getInlayModel().addInlineElement(this.textAfterModification.length(), new EditorCustomElementRenderer(newFragmentEditor, color){
            final /* synthetic */ EditorEx $newFragmentEditor;
            final /* synthetic */ Color $color;
            {
                this.$newFragmentEditor = $newFragmentEditor;
                this.$color = $color;
            }

            public int calcWidthInPixels(Inlay<?> inlay) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                return EditorUtil.getPlainSpaceWidth((Editor)((Editor)this.$newFragmentEditor)) / 3;
            }

            public void paint(Inlay<?> inlay, Graphics2D g, Rectangle2D targetRegion, TextAttributes textAttributes) {
                Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                Intrinsics.checkNotNullParameter((Object)targetRegion, (String)"targetRegion");
                Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                Color color = this.$color;
                if (color == null) {
                    return;
                }
                g.setColor(color);
                g.fill(targetRegion);
            }
        });
        JComponent jComponent = newFragmentEditor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        return jComponent;
    }

    private final JComponent createShortcutSidebarPanel(NextEditShortcutHintType hintType, Disposable disposable) {
        if (hintType == NextEditShortcutHintType.NONE) {
            return null;
        }
        JComponent topComponent = NextEditComponentFactory.INSTANCE.createEmptyPanel(this.editor, 0, 1);
        EditorEx shortcutEditor = NextEditComponentFactory.INSTANCE.createEmptyEditor(disposable, this.project, NextEditEditorUtil.INSTANCE.getFontSize(this.editor), NextEditRenderingCustomizer.Companion.getOrDefault(this.editor).getEditorBackgroundColor(this.editor));
        NextEditShortcutHint shortcutHint = switch (WhenMappings.$EnumSwitchMapping$0[hintType.ordinal()]) {
            case 1 -> new NextEditShortcutHint.ApplyDiff.Replace(this.actionHintPresentation);
            case 2 -> new NextEditShortcutHint.Jump(this.actionHintPresentation);
            case 3 -> throw new IllegalStateException("Not reachable".toString());
            default -> throw new NoWhenBranchMatchedException();
        };
        NextEditInlineShortcutInlaysKt.renderShortcutHint((Editor)shortcutEditor, 0, shortcutHint);
        Object[] objectArray = new List[]{CollectionsKt.listOf((Object)topComponent), CollectionsKt.listOf((Object)shortcutEditor.getContentComponent())};
        GridAutofitPanel panel2 = new GridAutofitPanel(CollectionsKt.listOf((Object[])objectArray));
        return panel2;
    }

    private final void renderEmptyLineBelowIfNeeded() {
        int currentLine = this.editor.getDocument().getLineNumber(this.startOffset);
        int nextLine = currentLine + 1;
        if (nextLine >= this.editor.getDocument().getLineCount()) {
            return;
        }
        int currentVisualStartX = this.editor.offsetToXY((int)this.startOffset).x;
        int nextLineVisualEndX = this.editor.offsetToXY((int)this.editor.getDocument().getLineEndOffset((int)nextLine)).x;
        if (currentVisualStartX >= nextLineVisualEndX) {
            return;
        }
        NextEditRenderingUtils.INSTANCE.renderVisualEmptyLinesUnder(this.editor, this.startOffset, 1, this);
    }

    private static final Unit renderViewPanel$lambda$0(OverEditorPanelFactory $panelFactory, GridAutofitPanel $panel, int $topLeftOffset) {
        OverEditorPanelFactory.attachPanelToOffset$default($panelFactory, $panel, $topLeftOffset, 0, 4, null);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NextEditShortcutHintType.values().length];
            try {
                nArray[NextEditShortcutHintType.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditShortcutHintType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditShortcutHintType.NONE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

