/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.diff.general;

import com.intellij.ml.llm.nextEdits.common.diff.NextEditDiff;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditGeneralDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.ui.util.NextEditHighlightRange;
import com.intellij.openapi.diff.DiffColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u00020\u0007*\u00020\bJ&\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u001d\u001a\u00020\u001c*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J$\u0010\u001e\u001a\u00020\u001f*\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\"\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditGeneralViewUtils;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "numberOfLeadingWhitespaces", "", "", "getCommonUntouchedIndentInDocument", "document", "Lcom/intellij/openapi/editor/Document;", "startLine", "endLine", "diff", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/NextEditGeneralDiffModel;", "getHighlightRangesInOriginalDocument", "", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/util/NextEditHighlightRange;", "getHighlightRangesInOriginalTextFrom", "change", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff$Change;", "origin", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff;", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "findChangesThatIntersect", "range", "Lcom/intellij/openapi/util/TextRange;", "absoluteRange", "doesRemoveLine", "", "Lcom/intellij/ml/llm/nextEdits/common/diff/NextEditDiff$Change$Delete;", "lineRange", "validateLineNumbers", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditGeneralViewUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditGeneralViewUtils.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditGeneralViewUtils\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,222:1\n158#2,6:223\n1#3:229\n1761#4,3:230\n1374#4:233\n1460#4,5:234\n774#4:239\n865#4,2:240\n119#5:242\n*S KotlinDebug\n*F\n+ 1 NextEditGeneralViewUtils.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/diff/general/NextEditGeneralViewUtils\n*L\n19#1:223,6\n64#1:230,3\n104#1:233\n104#1:234,5\n168#1:239\n168#1:240,2\n16#1:242\n*E\n"})
public final class NextEditGeneralViewUtils {
    @NotNull
    public static final NextEditGeneralViewUtils INSTANCE;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    private NextEditGeneralViewUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final int numberOfLeadingWhitespaces(@NotNull String $this$numberOfLeadingWhitespaces) {
        void var3_3;
        int n;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$numberOfLeadingWhitespaces, (String)"<this>");
            CharSequence $this$indexOfFirst$iv = $this$numberOfLeadingWhitespaces;
            boolean $i$f$indexOfFirst = false;
            int n2 = $this$indexOfFirst$iv.length();
            for (int index$iv = 0; index$iv < n2; ++index$iv) {
                char it = $this$indexOfFirst$iv.charAt(index$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                n = index$iv;
                break block1;
            }
            n = -1;
        }
        int it = n;
        boolean bl = false;
        return it == -1 ? $this$numberOfLeadingWhitespaces.length() : var3_3;
    }

    public final int getCommonUntouchedIndentInDocument(@NotNull Document document2, int startLine, int endLine, @NotNull NextEditGeneralDiffModel diff2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        if (!this.validateLineNumbers(document2, startLine, endLine)) {
            return 0;
        }
        int result2 = Integer.MAX_VALUE;
        int diffStartOffset = diff2.getOrigin().getFragment().getStartOffset1();
        int lineNumber = startLine;
        if (lineNumber <= endLine) {
            while (result2 > 0) {
                String line;
                int lineStartOffset = document2.getLineStartOffset(lineNumber);
                int lineEndOffset = document2.getLineEndOffset(lineNumber);
                TextRange lineRange = new TextRange(lineStartOffset, lineEndOffset);
                Intrinsics.checkNotNullExpressionValue((Object)document2.getText(lineRange), (String)"getText(...)");
                List<NextEditDiff.Change> intersectingWithLineChanges = this.findChangesThatIntersect(lineRange, diff2);
                if (!StringsKt.isBlank((CharSequence)line) || !intersectingWithLineChanges.isEmpty()) {
                    boolean isLineRemoved;
                    int indent;
                    block14: {
                        indent = this.numberOfLeadingWhitespaces(line);
                        Iterable $this$any$iv = intersectingWithLineChanges;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            v0 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                NextEditDiff.Change it = (NextEditDiff.Change)element$iv;
                                boolean bl = false;
                                if (!(it instanceof NextEditDiff.Change.Delete && INSTANCE.doesRemoveLine((NextEditDiff.Change.Delete)it, lineRange, diff2.getOrigin(), document2))) continue;
                                v0 = true;
                                break block14;
                            }
                            v0 = isLineRemoved = false;
                        }
                    }
                    if (isLineRemoved) {
                        if (!StringsKt.isBlank((CharSequence)line)) {
                            result2 = Math.min(result2, indent);
                        }
                    } else {
                        TextRange indentRange;
                        Intrinsics.checkNotNullExpressionValue((Object)TextRange.from((int)lineStartOffset, (int)indent), (String)"from(...)");
                        List<NextEditDiff.Change> intersectingWithIndentChanges = this.findChangesThatIntersect(indentRange, diff2);
                        if (intersectingWithIndentChanges.isEmpty()) {
                            result2 = Math.min(result2, indent);
                        } else {
                            Iterator iterator = ((Iterable)intersectingWithIndentChanges).iterator();
                            if (!iterator.hasNext()) {
                                throw new NoSuchElementException();
                            }
                            NextEditDiff.Change it = (NextEditDiff.Change)iterator.next();
                            boolean bl = false;
                            int n = it.getStartOffset();
                            while (iterator.hasNext()) {
                                NextEditDiff.Change it2 = (NextEditDiff.Change)iterator.next();
                                $i$a$-minOf-NextEditGeneralViewUtils$getCommonUntouchedIndentInDocument$firstIntersectStartOffset$1 = false;
                                int n2 = it2.getStartOffset();
                                if (n <= n2) continue;
                                n = n2;
                            }
                            int firstIntersectStartOffset = n + diffStartOffset;
                            result2 = Math.min(result2, Math.max(firstIntersectStartOffset - lineStartOffset, 0));
                        }
                    }
                }
                if (lineNumber == endLine) break;
                ++lineNumber;
            }
        }
        Integer n = RangesKt.coerceAtLeast((int)result2, (int)0);
        int it = ((Number)n).intValue();
        boolean bl = false;
        Integer n3 = it != Integer.MAX_VALUE ? n : null;
        return n3 != null ? n3 : 0;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<NextEditHighlightRange> getHighlightRangesInOriginalDocument(@NotNull NextEditGeneralDiffModel diff2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)diff2, (String)"diff");
        Iterable $this$flatMap$iv = diff2.getOrigin().getContentUpdate().getChanges();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List<NextEditHighlightRange> list;
            NextEditDiff.Change it = (NextEditDiff.Change)element$iv$iv;
            boolean bl = false;
            NextEditDiff.Change change = it;
            if (change instanceof NextEditDiff.Change.Delete) {
                NextEditDiff nextEditDiff = diff2.getOrigin();
                TextAttributesKey textAttributesKey = DiffColors.DIFF_DELETED;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_DELETED");
                list = INSTANCE.getHighlightRangesInOriginalTextFrom(it, nextEditDiff, textAttributesKey);
            } else if (change instanceof NextEditDiff.Change.Replace) {
                NextEditDiff nextEditDiff = diff2.getOrigin();
                TextAttributesKey textAttributesKey = DiffColors.DIFF_MODIFIED;
                Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"DIFF_MODIFIED");
                list = INSTANCE.getHighlightRangesInOriginalTextFrom(it, nextEditDiff, textAttributesKey);
            } else if (change instanceof NextEditDiff.Change.Insert) {
                list = CollectionsKt.emptyList();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final List<NextEditHighlightRange> getHighlightRangesInOriginalTextFrom(NextEditDiff.Change change, NextEditDiff origin, TextAttributesKey attributesKey) {
        List result2 = new ArrayList();
        int absoluteChangeStartOffset = origin.getFragment().getStartOffset1() + change.getStartOffset();
        String string = origin.getContentUpdate().getBefore().substring(change.getStartOffset(), change.getEndOffset());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String changedText = string;
        int currentOffsetInText = 0;
        while (currentOffsetInText < changedText.length()) {
            int it = StringsKt.indexOf$default((CharSequence)changedText, (char)'\n', (int)currentOffsetInText, (boolean)false, (int)4, null);
            boolean bl = false;
            int startOffset = absoluteChangeStartOffset + currentOffsetInText;
            int newLineIndex = it == -1 ? changedText.length() : it;
            int endOffset = absoluteChangeStartOffset + newLineIndex;
            if (startOffset == endOffset || newLineIndex < changedText.length()) {
                ((Collection)result2).add(new NextEditHighlightRange.Line(startOffset, attributesKey));
            } else {
                ((Collection)result2).add(new NextEditHighlightRange.Range(startOffset, endOffset, attributesKey));
            }
            currentOffsetInText = newLineIndex + 1;
        }
        if (change.getEndOffset() == origin.getContentUpdate().getBefore().length() && StringsKt.endsWith$default((String)changedText, (String)"\n", (boolean)false, (int)2, null)) {
            ((Collection)result2).add(new NextEditHighlightRange.Line(absoluteChangeStartOffset + change.getEndOffset() - change.getStartOffset(), attributesKey));
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<NextEditDiff.Change> findChangesThatIntersect(TextRange range, NextEditGeneralDiffModel diff2) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = diff2.getOrigin().getContentUpdate().getChanges();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NextEditDiff.Change change = (NextEditDiff.Change)element$iv$iv;
            boolean bl = false;
            TextRange changeRange = INSTANCE.absoluteRange(change, diff2.getOrigin());
            if (!(changeRange.contains(range) || range.contains(changeRange) ? true : (changeRange.getEndOffset() == range.getStartOffset() ? false : (range.getEndOffset() == changeRange.getStartOffset() ? false : INSTANCE.absoluteRange(change, diff2.getOrigin()).intersects(range))))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final TextRange absoluteRange(NextEditDiff.Change $this$absoluteRange, NextEditDiff origin) {
        int diffStart = origin.getFragment().getStartOffset1();
        TextRange textRange = TextRange.create((int)($this$absoluteRange.getStartOffset() + diffStart), (int)($this$absoluteRange.getEndOffset() + diffStart));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    private final boolean doesRemoveLine(NextEditDiff.Change.Delete $this$doesRemoveLine, TextRange lineRange, NextEditDiff origin, Document document2) {
        if ($this$doesRemoveLine.getEndOffset() != origin.getContentUpdate().getBefore().length()) {
            TextRange textRange = lineRange.getEndOffset() < document2.getTextLength() ? lineRange.grown(1) : lineRange;
            Intrinsics.checkNotNull((Object)textRange);
            TextRange extendedLineRange = textRange;
            return this.absoluteRange($this$doesRemoveLine, origin).contains(extendedLineRange);
        }
        TextRange extendedLineRange = lineRange.getStartOffset() > 0 ? new TextRange(lineRange.getStartOffset() - 1, lineRange.getEndOffset()) : lineRange;
        return this.absoluteRange($this$doesRemoveLine, origin).contains(extendedLineRange);
    }

    private final boolean validateLineNumbers(Document document2, int startLine, int endLine) {
        if (startLine < 0) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Invalid start line: " + startLine, null, 2, null);
            return false;
        }
        if (endLine >= document2.getLineCount()) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Invalid end line: " + endLine + ". Document lines count: " + document2.getLineCount(), null, 2, null);
            return false;
        }
        if (startLine > endLine) {
            FrontendNextEditDiagnosticsLogger.error$default(LOG, "Invalid range: startLine=" + startLine + ", endLine=" + endLine, null, 2, null);
            return false;
        }
        return true;
    }

    static {
        NextEditGeneralViewUtils $this$thisNextEditLogger$iv = INSTANCE = new NextEditGeneralViewUtils();
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(NextEditGeneralViewUtils.class);
    }
}

