/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.display;

import com.intellij.ml.llm.nextEdits.common.provider.NextEditDisplayIntrusionMode;
import com.intellij.ml.llm.nextEdits.common.settings.NextEditBehaviourSettings;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.editor.NextEditMagicWand;
import com.intellij.ml.llm.nextEdits.frontend.logs.FrontendNextEditEventsReporter;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.DocumentChangeGuardPurpose;
import com.intellij.ml.llm.nextEdits.frontend.session.guarder.Guarder;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditAdditionDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditDeletionDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditGeneralDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditSessionStep;
import com.intellij.ml.llm.nextEdits.frontend.session.step.NextEditSimpleReplaceDiffModel;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditActionControllerImpl;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditDeletionDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditGeneralDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditSimpleReplaceDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.NextEditStepController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.addition.NextEditAdditionDiffController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.addition.NextEditCompletionController;
import com.intellij.ml.llm.nextEdits.frontend.session.step.controller.addition.NextEditGreenAdditionDiffController;
import com.intellij.ml.llm.nextEdits.frontend.ui.diff.NextEditJumpView;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditBeforeDisplayInitializer;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditDisplayParameters;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditDisplayState;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditSuppressHighlightingOfElementUnderCaretInitializer;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.NextEditUnfoldTextBeforeDisplay;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditShortcutHintType;
import com.intellij.ml.llm.nextEdits.frontend.ui.view.NextEditStepDisplayer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.concurrency.ThreadingAssertions;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 =2\u00020\u0001:\u0002<=B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\nJ\u0006\u0010!\u001a\u00020\nJ\u0006\u0010\"\u001a\u00020\u0019J\b\u0010#\u001a\u00020\nH\u0002J \u0010$\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010(\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010)\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020&2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202H\u0002J\u0010\u00103\u001a\u00020&2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u00104\u001a\u00020\u0019H\u0002J*\u00105\u001a\u0002H6\"\u0004\b\u0000\u001062\u0006\u00107\u001a\u0002H62\f\u00108\u001a\b\u0012\u0004\u0012\u0002H609H\u0082\b\u00a2\u0006\u0002\u0010:J\b\u0010;\u001a\u00020\nH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000e\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager;", "Lcom/intellij/openapi/Disposable;", "ignoreDocumentChangesGuarder", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/Guarder;", "Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/DocumentChangeGuardPurpose;", "behavioursSettings", "Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;", "onDisplayStateChanged", "Lkotlin/Function1;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayState;", "", "<init>", "(Lcom/intellij/ml/llm/nextEdits/frontend/session/guarder/Guarder;Lcom/intellij/ml/llm/nextEdits/common/settings/NextEditBehaviourSettings;Lkotlin/jvm/functions/Function1;)V", "newState", "displayState", "getDisplayState", "()Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayState;", "setDisplayState", "(Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayState;)V", "phase", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager$Phase;", "beforeDisplayInitializers", "", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditBeforeDisplayInitializer;", "display", "", "displayParameters", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayParameters;", "intrusionMode", "Lcom/intellij/ml/llm/nextEdits/common/provider/NextEditDisplayIntrusionMode;", "reporter", "Lcom/intellij/ml/llm/nextEdits/frontend/logs/FrontendNextEditEventsReporter;", "undisplay", "suppress", "isDisplayInProgress", "doUndisplay", "displayJumpView", "stepController", "Lcom/intellij/ml/llm/nextEdits/frontend/session/step/controller/NextEditStepController;", "displayStepView", "tryDisplayNonIntrusiveDiffViewElseJumpView", "doDisplayStepView", "displayer", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditStepDisplayer;", "getShortcutHintType", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/view/NextEditShortcutHintType;", "controller", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "getStepController", "assertNoActiveRendering", "withUpdatingPhase", "T", "defaultValue", "action", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "dispose", "Phase", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@SourceDebugExtension(value={"SMAP\nNextEditDisplayManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditDisplayManager.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager\n+ 2 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,274:1\n238#1,10:275\n238#1,10:285\n238#1,10:295\n119#2:305\n*S KotlinDebug\n*F\n+ 1 NextEditDisplayManager.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager\n*L\n65#1:275,10\n86#1:285,10\n90#1:295,10\n271#1:305\n*E\n"})
public final class NextEditDisplayManager
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder;
    @NotNull
    private final NextEditBehaviourSettings behavioursSettings;
    @NotNull
    private final Function1<NextEditDisplayState, Unit> onDisplayStateChanged;
    @NotNull
    private NextEditDisplayState displayState;
    @NotNull
    private Phase phase;
    @NotNull
    private final List<NextEditBeforeDisplayInitializer> beforeDisplayInitializers;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    public NextEditDisplayManager(@NotNull Guarder<DocumentChangeGuardPurpose> ignoreDocumentChangesGuarder, @NotNull NextEditBehaviourSettings behavioursSettings, @NotNull Function1<? super NextEditDisplayState, Unit> onDisplayStateChanged) {
        Intrinsics.checkNotNullParameter(ignoreDocumentChangesGuarder, (String)"ignoreDocumentChangesGuarder");
        Intrinsics.checkNotNullParameter((Object)behavioursSettings, (String)"behavioursSettings");
        Intrinsics.checkNotNullParameter(onDisplayStateChanged, (String)"onDisplayStateChanged");
        this.ignoreDocumentChangesGuarder = ignoreDocumentChangesGuarder;
        this.behavioursSettings = behavioursSettings;
        this.onDisplayStateChanged = onDisplayStateChanged;
        this.displayState = NextEditDisplayState.Empty.INSTANCE;
        this.phase = Phase.IDLE;
        Object[] objectArray = new NextEditBeforeDisplayInitializer[]{NextEditUnfoldTextBeforeDisplay.INSTANCE, NextEditSuppressHighlightingOfElementUnderCaretInitializer.INSTANCE};
        this.beforeDisplayInitializers = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final NextEditDisplayState getDisplayState() {
        return this.displayState;
    }

    private final void setDisplayState(NextEditDisplayState newState) {
        ThreadingAssertions.assertEventDispatchThread();
        if (!Intrinsics.areEqual((Object)newState, (Object)this.displayState)) {
            this.onDisplayStateChanged.invoke((Object)newState);
            this.displayState = newState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean display(@NotNull NextEditDisplayParameters displayParameters, @NotNull NextEditDisplayIntrusionMode intrusionMode, @NotNull FrontendNextEditEventsReporter reporter) {
        boolean bl;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)displayParameters, (String)"displayParameters");
        Intrinsics.checkNotNullParameter((Object)((Object)intrusionMode), (String)"intrusionMode");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        NextEditDisplayManager nextEditDisplayManager = this;
        boolean defaultValue$iv = false;
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (!super.assertNoActiveRendering()) {
            bl = defaultValue$iv;
        } else {
            this_$iv.phase = Phase.UPDATING;
            try {
                boolean bl2 = false;
                this.doUndisplay();
                this.setDisplayState(switch (WhenMappings.$EnumSwitchMapping$0[intrusionMode.ordinal()]) {
                    case 1 -> this.displayStepView(displayParameters, reporter);
                    case 2 -> this.tryDisplayNonIntrusiveDiffViewElseJumpView(displayParameters, reporter);
                    case 3 -> {
                        NextEditStepController stepController = this.getStepController(displayParameters);
                        yield this.displayJumpView(displayParameters, stepController, reporter);
                    }
                    default -> throw new NoWhenBranchMatchedException();
                });
                boolean bl3 = !(this.displayState instanceof NextEditDisplayState.Empty);
                bl = bl3;
            }
            finally {
                this_$iv.phase = Phase.IDLE;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void undisplay() {
        void this_$iv;
        NextEditDisplayManager nextEditDisplayManager = this;
        Unit defaultValue$iv = Unit.INSTANCE;
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (super.assertNoActiveRendering()) {
            this_$iv.phase = Phase.UPDATING;
            try {
                boolean bl = false;
                this.doUndisplay();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.phase = Phase.IDLE;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void suppress() {
        void this_$iv;
        NextEditDisplayManager nextEditDisplayManager = this;
        Unit defaultValue$iv = Unit.INSTANCE;
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (super.assertNoActiveRendering()) {
            this_$iv.phase = Phase.UPDATING;
            try {
                boolean bl = false;
                if (!(this.displayState instanceof NextEditDisplayState.Suppressed)) {
                    this.displayState.dispose();
                    this.setDisplayState(NextEditDisplayState.Suppressed.INSTANCE);
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv.phase = Phase.IDLE;
            }
        }
    }

    public final boolean isDisplayInProgress() {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.phase.ordinal()]) {
            case 1 -> true;
            case 2 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void doUndisplay() {
        this.displayState.dispose();
        this.setDisplayState(NextEditDisplayState.Empty.INSTANCE);
    }

    private final NextEditDisplayState displayJumpView(NextEditDisplayParameters displayParameters, NextEditStepController stepController, FrontendNextEditEventsReporter reporter) {
        TextRange editRange = new TextRange(displayParameters.getStartOffset(), Math.max(displayParameters.getEndOffset() - 1, displayParameters.getStartOffset()));
        NextEditJumpView jumpView = new NextEditJumpView(displayParameters.getEditor(), editRange, displayParameters.getActionHintPresentation());
        jumpView.show();
        reporter.onJumpShown();
        NextEditMagicWand.Companion.getInstance().display(displayParameters.getEditor(), this.behavioursSettings.isIndicatorEnabled(), jumpView);
        return new NextEditDisplayState.JumpShown(stepController, jumpView);
    }

    private final NextEditDisplayState displayStepView(NextEditDisplayParameters displayParameters, FrontendNextEditEventsReporter reporter) {
        NextEditStepController stepController = this.getStepController(displayParameters);
        return this.doDisplayStepView(stepController, stepController.getDisplayer(), displayParameters, reporter);
    }

    private final NextEditDisplayState tryDisplayNonIntrusiveDiffViewElseJumpView(NextEditDisplayParameters displayParameters, FrontendNextEditEventsReporter reporter) {
        NextEditStepController stepController = this.getStepController(displayParameters);
        NextEditStepDisplayer displayer = stepController.getDisplayer();
        if (displayer.isIntrusive(displayParameters.getEditor(), displayParameters.getProject())) {
            return this.displayJumpView(displayParameters, stepController, reporter);
        }
        return this.doDisplayStepView(stepController, displayer, displayParameters, reporter);
    }

    private final NextEditDisplayState doDisplayStepView(NextEditStepController stepController, NextEditStepDisplayer displayer, NextEditDisplayParameters displayParameters, FrontendNextEditEventsReporter reporter) {
        Disposable disposable = Disposer.newDisposable((String)"[Next Edit] Step view");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable viewDisposable = disposable;
        for (NextEditBeforeDisplayInitializer initializer : this.beforeDisplayInitializers) {
            initializer.initialize(displayParameters, viewDisposable);
        }
        try {
            NextEditShortcutHintType hintType = this.getShortcutHintType(stepController, displayParameters.getEditor(), displayParameters.getProject());
            displayer.show(displayParameters.getEditor(), displayParameters.getProject(), hintType, viewDisposable);
            reporter.onStepShown(displayParameters.getStep().getIndex(), displayer.getViewType(), displayParameters.getStartOffset(), displayParameters.getEndOffset());
            NextEditMagicWand.Companion.getInstance().display(displayParameters.getEditor(), this.behavioursSettings.isIndicatorEnabled(), viewDisposable);
            return new NextEditDisplayState.StepShown(stepController, viewDisposable);
        }
        catch (Throwable e) {
            Disposer.dispose((Disposable)viewDisposable);
            throw e;
        }
    }

    private final NextEditShortcutHintType getShortcutHintType(NextEditStepController controller2, Editor editor2, Project project2) {
        return switch (WhenMappings.$EnumSwitchMapping$2[controller2.getKeyHandlerType(editor2, project2).ordinal()]) {
            case 1 -> NextEditShortcutHintType.ACCEPT;
            case 2 -> NextEditShortcutHintType.JUMP;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final NextEditStepController getStepController(NextEditDisplayParameters displayParameters) {
        NextEditStepController nextEditStepController;
        NextEditSessionStep step2 = displayParameters.getStep();
        if (step2 instanceof NextEditSessionStep.Action) {
            nextEditStepController = new NextEditActionControllerImpl(((NextEditSessionStep.Action)step2).getModel());
        } else if (step2 instanceof NextEditSessionStep.Diff) {
            NextEditDiffController nextEditDiffController;
            NextEditDiffModel diffModel = ((NextEditSessionStep.Diff)displayParameters.getStep()).getModel();
            if (diffModel instanceof NextEditAdditionDiffModel) {
                nextEditDiffController = NextEditAdditionDiffController.Companion.isCompletionApplicable(displayParameters.getEditor(), (NextEditAdditionDiffModel)diffModel) ? (NextEditAdditionDiffController)new NextEditCompletionController((NextEditAdditionDiffModel)diffModel, ((NextEditSessionStep.Diff)step2).getHighlighting(), this.ignoreDocumentChangesGuarder, this.behavioursSettings, displayParameters.getActionHintPresentation()) : (NextEditAdditionDiffController)new NextEditGreenAdditionDiffController((NextEditAdditionDiffModel)diffModel, ((NextEditSessionStep.Diff)step2).getHighlighting(), displayParameters.getActionHintPresentation());
            } else if (diffModel instanceof NextEditDeletionDiffModel) {
                nextEditDiffController = new NextEditDeletionDiffController((NextEditDeletionDiffModel)diffModel, displayParameters.getActionHintPresentation());
            } else if (diffModel instanceof NextEditGeneralDiffModel) {
                nextEditDiffController = new NextEditGeneralDiffController((NextEditGeneralDiffModel)diffModel, ((NextEditSessionStep.Diff)step2).getFileType(), ((NextEditSessionStep.Diff)step2).getHighlighting(), displayParameters.getActionHintPresentation());
            } else if (diffModel instanceof NextEditSimpleReplaceDiffModel) {
                nextEditDiffController = new NextEditSimpleReplaceDiffController((NextEditSimpleReplaceDiffModel)diffModel, ((NextEditSessionStep.Diff)step2).getFileType());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            nextEditStepController = nextEditDiffController;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return nextEditStepController;
    }

    private final boolean assertNoActiveRendering() {
        return switch (WhenMappings.$EnumSwitchMapping$1[this.phase.ordinal()]) {
            case 1 -> {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Already rendering another diff. Cannot render a diff recursively.", null, 2, null);
                yield false;
            }
            case 2 -> true;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T withUpdatingPhase(T defaultValue, Function0<? extends T> action2) {
        boolean $i$f$withUpdatingPhase = false;
        ThreadingAssertions.assertEventDispatchThread();
        if (!this.assertNoActiveRendering()) {
            return defaultValue;
        }
        this.phase = Phase.UPDATING;
        try {
            Object object = action2.invoke();
            return (T)object;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.phase = Phase.IDLE;
            InlineMarker.finallyEnd((int)1);
        }
    }

    public void dispose() {
        this.undisplay();
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(Companion.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/NextEditDisplayManager$Phase;", "", "<init>", "(Ljava/lang/String;I)V", "UPDATING", "IDLE", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Phase
    extends Enum<Phase> {
        public static final /* enum */ Phase UPDATING = new Phase();
        public static final /* enum */ Phase IDLE = new Phase();
        private static final /* synthetic */ Phase[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value2) {
            return Enum.valueOf(Phase.class, value2);
        }

        @NotNull
        public static EnumEntries<Phase> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.UPDATING, Phase.IDLE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[NextEditDisplayIntrusionMode.values().length];
            try {
                nArray[NextEditDisplayIntrusionMode.STEP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditDisplayIntrusionMode.NON_INTRUSIVE_STEP_OR_JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditDisplayIntrusionMode.JUMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Phase.values().length];
            try {
                nArray[Phase.UPDATING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Phase.IDLE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[NextEditStepController.KeyHandlerType.values().length];
            try {
                nArray[NextEditStepController.KeyHandlerType.ACCEPT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NextEditStepController.KeyHandlerType.JUMP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

