/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.display.highlighting;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterUpdater;
import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.highlighting.NextEditElementUnderCaretHighlightingSuppressor;
import com.intellij.ml.llm.nextEdits.frontend.ui.display.highlighting.NextEdtFrameScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\f\u0010\u0016\u001a\u00020\u0013*\u00020\u0015H\u0002R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor;", "", "<init>", "()V", "BACKGROUND_CHANGED_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor$ChangedState;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "suppress", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposable", "Lcom/intellij/openapi/Disposable;", "suppress$intellij_ml_llm_nextEdits_frontend", "isSuppressed", "", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isElementUnderCaretHighlighter", "Suppressor", "ChangedState", "intellij.ml.llm.nextEdits.frontend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nNextEditElementUnderCaretHighlightingSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditElementUnderCaretHighlightingSuppressor.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,262:1\n13805#2,2:263\n119#3:265\n*S KotlinDebug\n*F\n+ 1 NextEditElementUnderCaretHighlightingSuppressor.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor\n*L\n55#1:263,2\n29#1:265\n*E\n"})
public final class NextEditElementUnderCaretHighlightingSuppressor {
    @NotNull
    public static final NextEditElementUnderCaretHighlightingSuppressor INSTANCE = new NextEditElementUnderCaretHighlightingSuppressor();
    @NotNull
    private static final Key<ChangedState> BACKGROUND_CHANGED_KEY;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    private NextEditElementUnderCaretHighlightingSuppressor() {
    }

    @RequiresEdt
    public final void suppress$intellij_ml_llm_nextEdits_frontend(@NotNull Editor editor2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        ThreadingAssertions.assertEventDispatchThread();
        if (!Registry.Companion.is("llm.nextEdit.suppress.element.under.caret.highlighting")) {
            LOG.trace("Highlighting of element under caret will not be suppressed. Registry key is disabled.");
            return;
        }
        if (!(editor2 instanceof EditorEx)) {
            return;
        }
        MarkupModelEx markupModelEx = ((EditorEx)editor2).getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx markupModel = markupModelEx;
        NextEdtFrameScheduler scheduler = new NextEdtFrameScheduler();
        EditorColorsScheme editorColorsScheme = ((EditorEx)editor2).getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getColorsScheme(...)");
        Suppressor suppressor = new Suppressor(editorColorsScheme);
        RangeHighlighter[] rangeHighlighterArray = markupModel.getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] $this$forEach$iv = rangeHighlighterArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RangeHighlighter highlighter = (RangeHighlighter)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)highlighter);
            if (!INSTANCE.isElementUnderCaretHighlighter(highlighter)) continue;
            suppressor.suppress(highlighter);
        }
        MarkupModelListener listener2 = new MarkupModelListener(scheduler, suppressor){
            final /* synthetic */ NextEdtFrameScheduler $scheduler;
            final /* synthetic */ Suppressor $suppressor;
            {
                this.$scheduler = $scheduler;
                this.$suppressor = $suppressor;
            }

            public void afterAdded(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                if (NextEditElementUnderCaretHighlightingSuppressor.access$isElementUnderCaretHighlighter(NextEditElementUnderCaretHighlightingSuppressor.INSTANCE, (RangeHighlighter)highlighter)) {
                    this.$scheduler.schedule((Function0<Unit>)((Function0)() -> suppress.listener.1.afterAdded$lambda$0(this.$suppressor, highlighter)));
                }
            }

            public void afterRemoved(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                if (NextEditElementUnderCaretHighlightingSuppressor.access$isElementUnderCaretHighlighter(NextEditElementUnderCaretHighlightingSuppressor.INSTANCE, (RangeHighlighter)highlighter)) {
                    this.$scheduler.schedule((Function0<Unit>)((Function0)() -> suppress.listener.1.afterRemoved$lambda$1(this.$suppressor, highlighter)));
                }
            }

            public void attributesChanged(RangeHighlighterEx highlighter, boolean renderersChanged, boolean fontStyleChanged, boolean foregroundColorChanged) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                if (NextEditElementUnderCaretHighlightingSuppressor.access$isElementUnderCaretHighlighter(NextEditElementUnderCaretHighlightingSuppressor.INSTANCE, (RangeHighlighter)highlighter)) {
                    this.$scheduler.schedule((Function0<Unit>)((Function0)() -> suppress.listener.1.attributesChanged$lambda$2(this.$suppressor, highlighter)));
                }
            }

            private static final Unit afterAdded$lambda$0(Suppressor $suppressor, RangeHighlighterEx $highlighter) {
                $suppressor.suppress((RangeHighlighter)$highlighter);
                return Unit.INSTANCE;
            }

            private static final Unit afterRemoved$lambda$1(Suppressor $suppressor, RangeHighlighterEx $highlighter) {
                $suppressor.release((RangeHighlighter)$highlighter);
                return Unit.INSTANCE;
            }

            private static final Unit attributesChanged$lambda$2(Suppressor $suppressor, RangeHighlighterEx $highlighter) {
                $suppressor.attributesChanged((RangeHighlighter)$highlighter);
                return Unit.INSTANCE;
            }
        };
        markupModel.addMarkupModelListener(disposable, listener2);
        Disposer.register((Disposable)disposable, (Disposable)suppressor);
    }

    @TestOnly
    @RequiresEdt
    public final boolean isSuppressed(@NotNull Editor editor2, @NotNull RangeHighlighter highlighter) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        ThreadingAssertions.assertEventDispatchThread();
        if (highlighter.getUserData(BACKGROUND_CHANGED_KEY) == null) {
            return false;
        }
        TextAttributes textAttributes = highlighter.getTextAttributes(editor2.getColorsScheme());
        if ((textAttributes != null ? textAttributes.getBackgroundColor() : null) != null) {
            return false;
        }
        if (!this.isElementUnderCaretHighlighter(highlighter)) {
            boolean bl = false;
            String string = "Not an element under caret highlighter but suppressed.";
            throw new IllegalStateException(string.toString());
        }
        return true;
    }

    private final boolean isElementUnderCaretHighlighter(RangeHighlighter $this$isElementUnderCaretHighlighter) {
        Object object = $this$isElementUnderCaretHighlighter.getErrorStripeTooltip();
        HighlightInfo highlightInfo = object instanceof HighlightInfo ? (HighlightInfo)object : null;
        return Intrinsics.areEqual((Object)(highlightInfo != null ? highlightInfo.getToolId() : null), IdentifierHighlighterUpdater.class);
    }

    public static final /* synthetic */ boolean access$isElementUnderCaretHighlighter(NextEditElementUnderCaretHighlightingSuppressor $this, RangeHighlighter $receiver) {
        return $this.isElementUnderCaretHighlighter($receiver);
    }

    static {
        Key key = Key.create((String)"next.edit.element.under.caret.bg.changed");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BACKGROUND_CHANGED_KEY = key;
        NextEditElementUnderCaretHighlightingSuppressor $this$thisNextEditLogger$iv = INSTANCE;
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(NextEditElementUnderCaretHighlightingSuppressor.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor$ChangedState;", "", "forcedTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "<init>", "(Lcom/intellij/openapi/editor/markup/TextAttributes;)V", "getForcedTextAttributes", "()Lcom/intellij/openapi/editor/markup/TextAttributes;", "intellij.ml.llm.nextEdits.frontend"})
    private static final class ChangedState {
        @Nullable
        private final TextAttributes forcedTextAttributes;

        public ChangedState(@Nullable TextAttributes forcedTextAttributes) {
            this.forcedTextAttributes = forcedTextAttributes;
        }

        @Nullable
        public final TextAttributes getForcedTextAttributes() {
            return this.forcedTextAttributes;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bJ\b\u0010\u0010\u001a\u00020\fH\u0016J\u0017\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0082\bJ\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor$Suppressor;", "Lcom/intellij/openapi/Disposable;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "<init>", "(Lcom/intellij/openapi/editor/colors/EditorColorsScheme;)V", "trackedHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "isInternalUpdating", "", "suppress", "", "highlighter", "release", "attributesChanged", "dispose", "withUpdating", "action", "Lkotlin/Function0;", "doSuppressHighlighter", "doUnsuppressHighlighter", "doClearStoredState", "intellij.ml.llm.nextEdits.frontend"})
    @SourceDebugExtension(value={"SMAP\nNextEditElementUnderCaretHighlightingSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditElementUnderCaretHighlightingSuppressor.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor$Suppressor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,262:1\n174#1,2:266\n176#1,8:269\n174#1,2:277\n176#1,8:280\n1869#2,2:263\n1#3:265\n1#3:268\n1#3:279\n*S KotlinDebug\n*F\n+ 1 NextEditElementUnderCaretHighlightingSuppressor.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/display/highlighting/NextEditElementUnderCaretHighlightingSuppressor$Suppressor\n*L\n192#1:266,2\n192#1:269,8\n206#1:277,2\n206#1:280,8\n161#1:263,2\n192#1:268\n206#1:279\n*E\n"})
    private static final class Suppressor
    implements Disposable {
        @NotNull
        private final EditorColorsScheme colorsScheme;
        @NotNull
        private final Set<RangeHighlighter> trackedHighlighters;
        private boolean isInternalUpdating;

        public Suppressor(@NotNull EditorColorsScheme colorsScheme) {
            Intrinsics.checkNotNullParameter((Object)colorsScheme, (String)"colorsScheme");
            this.colorsScheme = colorsScheme;
            this.trackedHighlighters = new LinkedHashSet();
        }

        public final void suppress(@NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            ThreadingAssertions.assertEventDispatchThread();
            if (this.doSuppressHighlighter(highlighter, this.colorsScheme)) {
                this.trackedHighlighters.add(highlighter);
            }
        }

        public final void release(@NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            ThreadingAssertions.assertEventDispatchThread();
            this.trackedHighlighters.remove(highlighter);
            this.doUnsuppressHighlighter(highlighter);
        }

        public final void attributesChanged(@NotNull RangeHighlighter highlighter) {
            Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
            ThreadingAssertions.assertEventDispatchThread();
            if (this.isInternalUpdating) {
                return;
            }
            if (this.trackedHighlighters.contains(highlighter)) {
                this.doClearStoredState(highlighter);
                this.doSuppressHighlighter(highlighter, this.colorsScheme);
            }
        }

        public void dispose() {
            ThreadingAssertions.assertEventDispatchThread();
            List allHighlighters = CollectionsKt.toList((Iterable)this.trackedHighlighters);
            Iterable $this$forEach$iv = allHighlighters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                RangeHighlighter it = (RangeHighlighter)element$iv;
                boolean bl = false;
                this.release(it);
            }
            if (!((Collection)this.trackedHighlighters).isEmpty()) {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Some highlighters were not released: " + this.trackedHighlighters, null, 2, null);
                this.trackedHighlighters.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void withUpdating(Function0<Unit> action2) {
            boolean $i$f$withUpdating = false;
            ThreadingAssertions.assertEventDispatchThread();
            if (!(!this.isInternalUpdating)) {
                boolean bl = false;
                String string = "Already updating";
                throw new IllegalStateException(string.toString());
            }
            try {
                this.isInternalUpdating = true;
                action2.invoke();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                this.isInternalUpdating = false;
                InlineMarker.finallyEnd((int)1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean doSuppressHighlighter(RangeHighlighter highlighter, EditorColorsScheme colorsScheme) {
            if (!(highlighter instanceof RangeHighlighterEx) || highlighter.getUserData(BACKGROUND_CHANGED_KEY) != null) {
                return false;
            }
            TextAttributes textAttributes = highlighter.getTextAttributes(colorsScheme);
            if (textAttributes == null || (textAttributes = textAttributes.clone()) == null) {
                return false;
            }
            TextAttributes currentTextAttributes = textAttributes;
            ChangedState currentState = new ChangedState(((RangeHighlighterEx)highlighter).getForcedTextAttributes());
            currentTextAttributes.setBackgroundColor(null);
            Suppressor this_$iv = this;
            boolean $i$f$withUpdating = false;
            ThreadingAssertions.assertEventDispatchThread();
            if (!(!this_$iv.isInternalUpdating)) {
                boolean bl = false;
                String string = "Already updating";
                throw new IllegalStateException(string.toString());
            }
            try {
                this_$iv.isInternalUpdating = true;
                boolean bl = false;
                if (((RangeHighlighterEx)highlighter).isValid()) {
                    ((RangeHighlighterEx)highlighter).setTextAttributes(currentTextAttributes);
                }
            }
            finally {
                this_$iv.isInternalUpdating = false;
            }
            highlighter.putUserData(BACKGROUND_CHANGED_KEY, (Object)currentState);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void doUnsuppressHighlighter(RangeHighlighter highlighter) {
            ChangedState changedState = (ChangedState)highlighter.getUserData(BACKGROUND_CHANGED_KEY);
            if (!(highlighter instanceof RangeHighlighterEx) || changedState == null) {
                return;
            }
            Suppressor this_$iv = this;
            boolean $i$f$withUpdating = false;
            ThreadingAssertions.assertEventDispatchThread();
            if (!(!this_$iv.isInternalUpdating)) {
                boolean bl = false;
                String string = "Already updating";
                throw new IllegalStateException(string.toString());
            }
            try {
                this_$iv.isInternalUpdating = true;
                boolean bl = false;
                if (((RangeHighlighterEx)highlighter).isValid()) {
                    ((RangeHighlighterEx)highlighter).setTextAttributes(changedState.getForcedTextAttributes());
                }
            }
            finally {
                this_$iv.isInternalUpdating = false;
            }
            this.doClearStoredState(highlighter);
        }

        private final void doClearStoredState(RangeHighlighter highlighter) {
            highlighter.putUserData(BACKGROUND_CHANGED_KEY, null);
        }
    }
}

