/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.nextEdits.frontend.ui.refresh;

import com.intellij.ml.llm.nextEdits.frontend.diagnostics.FrontendNextEditDiagnosticsLogger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0003\u000e\u000f\u0010B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0007J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager;", "Lcom/intellij/openapi/Disposable;", "refresh", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "state", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager$State;", "refresher", "Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager$Refresher;", "scheduleRefresh", "dispose", "doSchedule", "State", "Refresher", "Companion", "intellij.ml.llm.nextEdits.frontend"})
@SourceDebugExtension(value={"SMAP\nNextEditViewRefreshManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NextEditViewRefreshManager.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager\n+ 2 FrontendNextEditDiagnosticsLogger.kt\ncom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLoggerKt\n*L\n1#1,83:1\n119#2:84\n*S KotlinDebug\n*F\n+ 1 NextEditViewRefreshManager.kt\ncom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager\n*L\n80#1:84\n*E\n"})
public final class NextEditViewRefreshManager
implements Disposable {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private State state;
    @NotNull
    private final Refresher refresher;
    @NotNull
    private static final FrontendNextEditDiagnosticsLogger LOG;

    public NextEditViewRefreshManager(@NotNull Function0<Unit> refresh2) {
        Intrinsics.checkNotNullParameter(refresh2, (String)"refresh");
        this.state = State.IDLE;
        this.refresher = new Refresher(refresh2);
    }

    @RequiresEdt
    public final void scheduleRefresh() {
        ThreadingAssertions.assertEventDispatchThread();
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.state = State.REFRESH_SCHEDULED;
                this.doSchedule();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                FrontendNextEditDiagnosticsLogger.error$default(LOG, "Cannot schedule a refresh while it is in progress.", null, 2, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.refresher);
    }

    private final void doSchedule() {
        ApplicationKt.getApplication().invokeLater(() -> NextEditViewRefreshManager.doSchedule$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void doSchedule$lambda$0(NextEditViewRefreshManager this$0) {
        this$0.state = State.REFRESHING;
        try {
            this$0.refresher.refresh();
        }
        finally {
            this$0.state = State.IDLE;
        }
    }

    static {
        Companion $this$thisNextEditLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisNextEditLogger = false;
        LOG = FrontendNextEditDiagnosticsLogger.Companion.get$intellij_ml_llm_nextEdits_frontend(Companion.class);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/ml/llm/nextEdits/frontend/diagnostics/FrontendNextEditDiagnosticsLogger;", "intellij.ml.llm.nextEdits.frontend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0002\u001a\u00020\u0004J\b\u0010\t\u001a\u00020\u0004H\u0016R(\u0010\u0002\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0004 \b*\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00030\u00030\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager$Refresher;", "Lcom/intellij/openapi/Disposable;", "refresh", "Lkotlin/Function0;", "", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "Ljava/util/concurrent/atomic/AtomicReference;", "kotlin.jvm.PlatformType", "dispose", "intellij.ml.llm.nextEdits.frontend"})
    private static final class Refresher
    implements Disposable {
        @NotNull
        private AtomicReference<Function0<Unit>> refresh;

        public Refresher(@NotNull Function0<Unit> refresh2) {
            Intrinsics.checkNotNullParameter(refresh2, (String)"refresh");
            this.refresh = new AtomicReference<Function0<Unit>>(refresh2);
        }

        public final void refresh() {
            block0: {
                Function0<Unit> function0 = this.refresh.get();
                if (function0 == null) break block0;
                function0.invoke();
            }
        }

        public void dispose() {
            this.refresh.set(null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/llm/nextEdits/frontend/ui/refresh/NextEditViewRefreshManager$State;", "", "<init>", "(Ljava/lang/String;I)V", "IDLE", "REFRESH_SCHEDULED", "REFRESHING", "intellij.ml.llm.nextEdits.frontend"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State IDLE = new State();
        public static final /* enum */ State REFRESH_SCHEDULED = new State();
        public static final /* enum */ State REFRESHING = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value2) {
            return Enum.valueOf(State.class, value2);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.IDLE, State.REFRESH_SCHEDULED, State.REFRESHING};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.IDLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.REFRESH_SCHEDULED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.REFRESHING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

