/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy;

import com.intellij.lang.Language;
import com.intellij.ml.llm.privacy.DeletedFilePathLightVirtualFile;
import com.intellij.ml.llm.privacy.LLMPrivacyBundle;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreManager;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreUxHelper;
import com.intellij.ml.llm.privacy.fileContentReaders.PsiElementIsAiIgnoreBlockedProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u001e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000bH\u0007\u001a\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0007\u001a \u0010\b\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0086@\u00a2\u0006\u0002\u0010\u000e\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0007\u001a\u0018\u0010\b\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0086@\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"notifyFileIsIgnored", "", "project", "Lcom/intellij/openapi/project/Project;", "isAiIgnoreBlocked", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "readIsAiIgnoreBlocked", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "path", "Lcom/intellij/openapi/vcs/FilePath;", "psiFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.privacy"})
@SourceDebugExtension(value={"SMAP\nPrivacyPathChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivacyPathChecker.kt\ncom/intellij/ml/llm/privacy/PrivacyPathCheckerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class PrivacyPathCheckerKt {
    @RequiresEdt
    public static final void notifyFileIsIgnored(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        int indexOfOpenFileButton = 1;
        String[] stringArray = new String[]{Messages.getOkButton(), LLMPrivacyBundle.message("popup.button.open.file", new Object[0])};
        int result2 = Messages.showDialog((String)LLMPrivacyBundle.message("popup.message", new Object[0]), (String)LLMPrivacyBundle.message("popup.title", new Object[0]), (String[])stringArray, (int)0, (Icon)Messages.getWarningIcon());
        if (result2 == indexOfOpenFileButton) {
            AiIgnoreUxHelper.Companion.getInstance(project2).openExistingFile();
        }
    }

    @RequiresReadLock
    public static final boolean isAiIgnoreBlocked(@NotNull Project project2, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (project2 instanceof DummyProject) {
            return false;
        }
        return AiIgnoreManager.Companion.getInstance(project2).isIgnored(file);
    }

    @Nullable
    public static final Object readIsAiIgnoreBlocked(@NotNull Project project2, @NotNull VirtualFile file, @NotNull Continuation<? super Boolean> $completion) {
        return CoroutinesKt.readAction(() -> PrivacyPathCheckerKt.readIsAiIgnoreBlocked$lambda$0(project2, file), $completion);
    }

    @RequiresReadLock
    public static final boolean isAiIgnoreBlocked(@NotNull Project project2, @NotNull FilePath path) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        VirtualFile virtualFile2 = path.getVirtualFile();
        if (virtualFile2 == null) {
            virtualFile2 = (VirtualFile)new DeletedFilePathLightVirtualFile(path);
        }
        VirtualFile virtualFile3 = virtualFile2;
        return PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, virtualFile3);
    }

    @RequiresReadLock
    public static final boolean isAiIgnoreBlocked(@NotNull Project project2, @Nullable PsiFile psiFile) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (psiFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl2 = false;
            bl = PrivacyPathCheckerKt.isAiIgnoreBlocked(project2, it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final Object readIsAiIgnoreBlocked(@NotNull Project project2, @Nullable PsiFile psiFile, @NotNull Continuation<? super Boolean> $completion) {
        return CoroutinesKt.readAction(() -> PrivacyPathCheckerKt.readIsAiIgnoreBlocked$lambda$1(project2, psiFile), $completion);
    }

    @RequiresReadLock
    public static final boolean isAiIgnoreBlocked(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return false;
        }
        Language language = psiElement.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return PsiElementIsAiIgnoreBlockedProvider.Companion.forLanguageOrDefault(language).isPrivate(psiElement, psiElement.getProject());
    }

    @Nullable
    public static final Object readIsAiIgnoreBlocked(@Nullable PsiElement psiElement, @NotNull Continuation<? super Boolean> $completion) {
        return CoroutinesKt.readAction(() -> PrivacyPathCheckerKt.readIsAiIgnoreBlocked$lambda$2(psiElement), $completion);
    }

    private static final boolean readIsAiIgnoreBlocked$lambda$0(Project $project, VirtualFile $file) {
        return PrivacyPathCheckerKt.isAiIgnoreBlocked($project, $file);
    }

    private static final boolean readIsAiIgnoreBlocked$lambda$1(Project $project, PsiFile $psiFile) {
        return PrivacyPathCheckerKt.isAiIgnoreBlocked($project, $psiFile);
    }

    private static final boolean readIsAiIgnoreBlocked$lambda$2(PsiElement $psiElement) {
        return PrivacyPathCheckerKt.isAiIgnoreBlocked($psiElement);
    }
}

