/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.aiignore;

import com.intellij.ml.llm.privacy.aiignore.AiIgnoreCreationProcessor;
import com.intellij.ml.llm.privacy.aiignore.AiIgnoreDetectionUtilsKtKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\f\u0010\r\u001a\u00020\u000e*\u00020\fH\u0002J\u0014\u0010\u000f\u001a\u00020\u000e*\u00020\u00062\u0006\u0010\u0010\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/ml/llm/privacy/aiignore/AiIgnoreRelatedChangesApplier;", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "project", "Lcom/intellij/openapi/project/Project;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "afterVfsChange", "", "detectNewAiIgnore", "Lcom/intellij/openapi/vfs/VirtualFile;", "looksLikeAiIgnore", "", "isAiIgnoreDeletion", "aiIgnoreFile", "intellij.ml.llm.privacy"})
final class AiIgnoreRelatedChangesApplier
implements AsyncFileListener.ChangeApplier {
    @NotNull
    private final Project project;
    @NotNull
    private final List<? extends VFileEvent> events;

    public AiIgnoreRelatedChangesApplier(@NotNull Project project2, @NotNull List<? extends VFileEvent> events) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        this.project = project2;
        this.events = events;
    }

    public void afterVfsChange() {
        VirtualFile virtualFile2 = this.detectNewAiIgnore();
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile detectedAiIgnore = virtualFile2;
        new AiIgnoreCreationProcessor(this.project).setAiIgnoreIfUnknownAndNotify(detectedAiIgnore);
    }

    private final VirtualFile detectNewAiIgnore() {
        VirtualFile newAiIgnore = null;
        for (VFileEvent vFileEvent : this.events) {
            VirtualFile affectedFile;
            if (vFileEvent.getFile() == null) continue;
            if (this.looksLikeAiIgnore(affectedFile) && vFileEvent instanceof VFileCreateEvent) {
                newAiIgnore = affectedFile;
                continue;
            }
            if (newAiIgnore == null || !this.isAiIgnoreDeletion(vFileEvent, newAiIgnore)) continue;
            newAiIgnore = null;
        }
        return newAiIgnore;
    }

    private final boolean looksLikeAiIgnore(VirtualFile $this$looksLikeAiIgnore) {
        return Intrinsics.areEqual((Object)$this$looksLikeAiIgnore.getName(), (Object)".aiignore") && AiIgnoreDetectionUtilsKtKt.guessAiIgnoreRootCandidates(this.project).contains($this$looksLikeAiIgnore.getParent());
    }

    private final boolean isAiIgnoreDeletion(VFileEvent $this$isAiIgnoreDeletion, VirtualFile aiIgnoreFile) {
        return $this$isAiIgnoreDeletion instanceof VFileDeleteEvent && Intrinsics.areEqual((Object)((VFileDeleteEvent)$this$isAiIgnoreDeletion).getFile(), (Object)aiIgnoreFile);
    }
}

