/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.extensions.vcs;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExternalAiIgnoreAwarePrivacyWrapper;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.std.FilePathPrivacyWrapper;
import com.intellij.ml.llm.privacy.fileContentReaders.SourceFileBasedPrivacyReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ContentRevision;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ml/llm/privacy/extensions/vcs/ContentRevisionPrivacyWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalAiIgnoreAwarePrivacyWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "revision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/changes/ContentRevision;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/ml/llm/privacy/extensions/std/FilePathPrivacyWrapper;", "getFile", "()Lcom/intellij/ml/llm/privacy/extensions/std/FilePathPrivacyWrapper;", "revisionNumber", "Lcom/intellij/ml/llm/privacy/PSString;", "getRevisionNumber", "()Lcom/intellij/ml/llm/privacy/PSString;", "content", "getContent", "intellij.ml.llm.privacy"})
public final class ContentRevisionPrivacyWrapper
extends ExternalAiIgnoreAwarePrivacyWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final ContentRevision revision;

    public ContentRevisionPrivacyWrapper(@NotNull Project project2, @NotNull ContentRevision revision) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        this.project = project2;
        this.revision = revision;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final FilePathPrivacyWrapper getFile() {
        FilePath filePath = this.revision.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFile(...)");
        return SharedExtensionsKtKt.getPrivacySafe((FilePath)filePath);
    }

    @NotNull
    public final PSString getRevisionNumber() {
        String string = this.revision.getRevisionNumber().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return this.promisedSafety(string);
    }

    @NotNull
    public final PSString getContent() {
        return this.redactingReadVia(this.revision, new SourceFileBasedPrivacyReader<ContentRevision, String>(){

            public SourceFileBasedPrivacyReader.SourceFileResult getSourceFile(ContentRevision entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                return SourceFileBasedPrivacyReader.SourceFileResult.Companion.noSourceFileIfNull(entity.getFile().getVirtualFile());
            }

            public String readContentsUnsafe(ContentRevision entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                String string = entity.getContent();
                if (string == null) {
                    string = "";
                }
                return string;
            }
        }).toPSString();
    }
}

