/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.privacy.extensions.vfs;

import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.extensions.ExtensionsKtKt;
import com.intellij.ml.llm.privacy.extensions.ExternalAiIgnoreAwarePrivacyWrapper;
import com.intellij.ml.llm.privacy.extensions.SharedExtensionsKtKt;
import com.intellij.ml.llm.privacy.fileContentReaders.VirtualFileReader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u0004\u0018\u00010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/privacy/extensions/vfs/VirtualFileFilteringPrivacyWrapper;", "Lcom/intellij/ml/llm/privacy/extensions/ExternalAiIgnoreAwarePrivacyWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "obj", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "readText", "Lcom/intellij/ml/llm/privacy/PSString;", "getProjectRelatedPath", "intellij.ml.llm.privacy"})
public final class VirtualFileFilteringPrivacyWrapper
extends ExternalAiIgnoreAwarePrivacyWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile obj;

    public VirtualFileFilteringPrivacyWrapper(@NotNull Project project2, @NotNull VirtualFile obj) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        this.project = project2;
        this.obj = obj;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public final PSString readText() {
        return this.redactingReadVia(this.obj, VirtualFileReader.INSTANCE).toPSString();
    }

    @Nullable
    public final PSString getProjectRelatedPath() {
        PSString pSString = SharedExtensionsKtKt.getPrivacySafe((Project)this.getProject()).getBasePath();
        if (pSString == null) {
            return null;
        }
        PSString projectPath = pSString;
        if (!ExtensionsKtKt.getPrivacySafe(this.obj).getPath().startsWith((CharSequence)projectPath)) {
            return null;
        }
        return ExtensionsKtKt.getPrivacySafe(this.obj).getPath().removePrefix((String)projectPath.unwrap()).removePrefix("/");
    }
}

