/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.provider.ollama;

import com.intellij.ml.llm.core.models.api.AiaLlmChatMessage;
import com.intellij.ml.llm.core.providers.AiaThirdPartyLlmStreamData;
import com.intellij.ml.llm.core.providers.StreamingChatCompletionCapability;
import com.intellij.ml.llm.core.providers.StreamingCompletionCapability;
import com.intellij.ml.llm.core.providers.ThirdPartyLLM;
import com.intellij.ml.llm.provider.ollama.OllamaClientAPI;
import com.intellij.ml.llm.provider.ollama.OllamaLLMProviderKt;
import com.intellij.ml.llm.provider.ollama.OllamaModelId;
import com.intellij.ml.llm.provider.ollama.Tool;
import com.intellij.ml.llm.smartChat.endpoints.LlmFunctionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0096@\u00a2\u0006\u0002\u0010\u001cJ6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0018H\u0096@\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/provider/ollama/OllamaLLMImpl;", "Lcom/intellij/ml/llm/core/providers/ThirdPartyLLM;", "Lcom/intellij/ml/llm/core/providers/StreamingChatCompletionCapability;", "Lcom/intellij/ml/llm/core/providers/StreamingCompletionCapability;", "model", "Lcom/intellij/ml/llm/provider/ollama/OllamaModelId;", "api", "Lcom/intellij/ml/llm/provider/ollama/OllamaClientAPI;", "<init>", "(Lcom/intellij/ml/llm/provider/ollama/OllamaModelId;Lcom/intellij/ml/llm/provider/ollama/OllamaClientAPI;)V", "getModel", "()Lcom/intellij/ml/llm/provider/ollama/OllamaModelId;", "getApi", "()Lcom/intellij/ml/llm/provider/ollama/OllamaClientAPI;", "llmId", "", "getLlmId", "()Ljava/lang/String;", "streamingChatCompletionCapability", "streamingCompletionCapability", "streamingChatCompletion", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ml/llm/core/providers/AiaThirdPartyLlmStreamData;", "history", "", "Lcom/intellij/ml/llm/core/models/api/AiaLlmChatMessage;", "functions", "Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "(Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "streamingCompletion", "prompt", "suffix", "stopTokens", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.provider.ollama"})
@SourceDebugExtension(value={"SMAP\nOllamaLLMImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OllamaLLMImpl.kt\ncom/intellij/ml/llm/provider/ollama/OllamaLLMImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n60#2,5:39\n60#2,5:48\n1563#3:44\n1634#3,3:45\n*S KotlinDebug\n*F\n+ 1 OllamaLLMImpl.kt\ncom/intellij/ml/llm/provider/ollama/OllamaLLMImpl\n*L\n25#1:39,5\n30#1:48,5\n26#1:44\n26#1:45,3\n*E\n"})
public final class OllamaLLMImpl
implements ThirdPartyLLM,
StreamingChatCompletionCapability,
StreamingCompletionCapability {
    @NotNull
    private final OllamaModelId model;
    @NotNull
    private final OllamaClientAPI api;

    public OllamaLLMImpl(@NotNull OllamaModelId model, @NotNull OllamaClientAPI api) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.model = model;
        this.api = api;
    }

    @NotNull
    public final OllamaModelId getModel() {
        return this.model;
    }

    @NotNull
    public final OllamaClientAPI getApi() {
        return this.api;
    }

    @NotNull
    public String getLlmId() {
        return this.model.getId();
    }

    @NotNull
    public StreamingChatCompletionCapability streamingChatCompletionCapability() {
        return this;
    }

    @NotNull
    public OllamaLLMImpl streamingCompletionCapability() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object streamingChatCompletion(@NotNull List<? extends AiaLlmChatMessage> history, @NotNull List<LlmFunctionDescriptor> functions, @NotNull Continuation<? super Flow<? extends AiaThirdPartyLlmStreamData>> $completion) {
        Collection<Tool> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object $this$debug_u24default$iv = OllamaLLMProviderKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("Ollama chat completion called for model " + this.getLlmId(), e$iv);
        }
        $this$debug_u24default$iv = functions;
        List<? extends AiaLlmChatMessage> list = history;
        OllamaModelId ollamaModelId = this.model;
        object = this.api;
        boolean $i$f$map = false;
        void $i$f$debug22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            LlmFunctionDescriptor llmFunctionDescriptor = (LlmFunctionDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tool((LlmFunctionDescriptor)p0));
        }
        collection = (List)destination$iv$iv;
        return object.chatCompletion(ollamaModelId, list, (List<Tool>)collection, $completion);
    }

    @Nullable
    public Object streamingCompletion(@NotNull String prompt2, @Nullable String suffix, @Nullable List<String> stopTokens, @NotNull Continuation<? super Flow<? extends AiaThirdPartyLlmStreamData>> $completion) {
        Logger $this$debug_u24default$iv = OllamaLLMProviderKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Ollama streaming completion called for model " + this.getLlmId(), e$iv);
        }
        return this.api.streamingCompletion(this.model, prompt2, suffix, stopTokens, $completion);
    }
}

