/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.provider.openai;

import com.intellij.ml.llm.core.models.api.AiaLlmChatMessage;
import com.intellij.ml.llm.core.providers.AiaThirdPartyLlmStreamData;
import com.intellij.ml.llm.core.providers.StreamingChatCompletionCapability;
import com.intellij.ml.llm.core.providers.StreamingCompletionCapability;
import com.intellij.ml.llm.core.providers.ThirdPartyLLM;
import com.intellij.ml.llm.provider.openai.OpenAIClientAPI;
import com.intellij.ml.llm.provider.openai.OpenAILLMProviderKt;
import com.intellij.ml.llm.provider.openai.OpenAIModelId;
import com.intellij.ml.llm.provider.openai.Tool;
import com.intellij.ml.llm.smartChat.endpoints.LlmFunctionDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0012\u001a\u00020\u0002H\u0016J\b\u0010\u0013\u001a\u00020\u0000H\u0016J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018H\u0096@\u00a2\u0006\u0002\u0010\u001cJ6\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u001e\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u000f2\u000e\u0010 \u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0018H\u0096@\u00a2\u0006\u0002\u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\""}, d2={"Lcom/intellij/ml/llm/provider/openai/OpenAILLMImpl;", "Lcom/intellij/ml/llm/core/providers/ThirdPartyLLM;", "Lcom/intellij/ml/llm/core/providers/StreamingChatCompletionCapability;", "Lcom/intellij/ml/llm/core/providers/StreamingCompletionCapability;", "model", "Lcom/intellij/ml/llm/provider/openai/OpenAIModelId;", "api", "Lcom/intellij/ml/llm/provider/openai/OpenAIClientAPI;", "<init>", "(Lcom/intellij/ml/llm/provider/openai/OpenAIModelId;Lcom/intellij/ml/llm/provider/openai/OpenAIClientAPI;)V", "getModel", "()Lcom/intellij/ml/llm/provider/openai/OpenAIModelId;", "getApi", "()Lcom/intellij/ml/llm/provider/openai/OpenAIClientAPI;", "llmId", "", "getLlmId", "()Ljava/lang/String;", "streamingChatCompletionCapability", "streamingCompletionCapability", "streamingChatCompletion", "Lkotlinx/coroutines/flow/Flow;", "Lcom/intellij/ml/llm/core/providers/AiaThirdPartyLlmStreamData;", "history", "", "Lcom/intellij/ml/llm/core/models/api/AiaLlmChatMessage;", "functions", "Lcom/intellij/ml/llm/smartChat/endpoints/LlmFunctionDescriptor;", "(Ljava/util/List;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "streamingCompletion", "prompt", "suffix", "stopTokens", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.ml.llm.provider.openai"})
@SourceDebugExtension(value={"SMAP\nOpenAILLMImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenAILLMImpl.kt\ncom/intellij/ml/llm/provider/openai/OpenAILLMImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n60#2,5:32\n60#2,5:41\n1563#3:37\n1634#3,3:38\n*S KotlinDebug\n*F\n+ 1 OpenAILLMImpl.kt\ncom/intellij/ml/llm/provider/openai/OpenAILLMImpl\n*L\n23#1:32,5\n28#1:41,5\n24#1:37\n24#1:38,3\n*E\n"})
public final class OpenAILLMImpl
implements ThirdPartyLLM,
StreamingChatCompletionCapability,
StreamingCompletionCapability {
    @NotNull
    private final OpenAIModelId model;
    @NotNull
    private final OpenAIClientAPI api;

    public OpenAILLMImpl(@NotNull OpenAIModelId model, @NotNull OpenAIClientAPI api) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)api, (String)"api");
        this.model = model;
        this.api = api;
    }

    @NotNull
    public final OpenAIModelId getModel() {
        return this.model;
    }

    @NotNull
    public final OpenAIClientAPI getApi() {
        return this.api;
    }

    @NotNull
    public String getLlmId() {
        return this.model.getId();
    }

    @NotNull
    public StreamingChatCompletionCapability streamingChatCompletionCapability() {
        return this;
    }

    @NotNull
    public OpenAILLMImpl streamingCompletionCapability() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object streamingChatCompletion(@NotNull List<? extends AiaLlmChatMessage> history, @NotNull List<LlmFunctionDescriptor> functions, @NotNull Continuation<? super Flow<? extends AiaThirdPartyLlmStreamData>> $completion) {
        Collection<Tool> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        Object $this$debug_u24default$iv = OpenAILLMProviderKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("An openAI chat completion called for model " + this.getLlmId(), e$iv);
        }
        $this$debug_u24default$iv = functions;
        List<? extends AiaLlmChatMessage> list = history;
        OpenAIModelId openAIModelId = this.model;
        object = this.api;
        boolean $i$f$map = false;
        void $i$f$debug22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            LlmFunctionDescriptor llmFunctionDescriptor = (LlmFunctionDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Tool((LlmFunctionDescriptor)p0));
        }
        collection = (List)destination$iv$iv;
        return object.chatCompletion(openAIModelId, list, (List<Tool>)collection, $completion);
    }

    @Nullable
    public Object streamingCompletion(@NotNull String prompt2, @Nullable String suffix, @Nullable List<String> stopTokens, @NotNull Continuation<? super Flow<? extends AiaThirdPartyLlmStreamData>> $completion) {
        Logger $this$debug_u24default$iv = OpenAILLMProviderKt.getLOG();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("An openAI streaming completion called for model " + this.getLlmId(), e$iv);
        }
        return this.api.streamingCompletion(this.model, prompt2, suffix, stopTokens, $completion);
    }
}

