/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.python.snippetRunner;

import com.intellij.ml.llm.core.chat.actions.AIAssistantChatActionsUtil;
import com.intellij.ml.llm.core.ssh.LLMCustomCodeSnippetRunnerProvider;
import com.intellij.ml.llm.core.ssh.LLMShRunnerProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.jetbrains.python.actions.PyExecuteInConsole;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.packaging.management.PythonPackageManagerExt;
import com.jetbrains.python.sdk.PySdkExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\u000fJ\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0007H\u0002J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0007H\u0002J\f\u0010\u0012\u001a\u00020\u0005*\u00020\u0007H\u0002J\f\u0010\u0013\u001a\u00020\u0005*\u00020\u0007H\u0002J\u001c\u0010\u0014\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/ml/llm/python/snippetRunner/PythonAICodeSnippetRunnerProvider;", "Lcom/intellij/ml/llm/core/ssh/LLMCustomCodeSnippetRunnerProvider;", "<init>", "()V", "canRun", "", "languageId", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "runScript", "", "project", "Lcom/intellij/openapi/project/Project;", "textToRun", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isShellLineComment", "isBlankOrComment", "hasBangs", "allBangs", "hasIPython", "pythonSdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "intellij.ml.llm.python"})
@SourceDebugExtension(value={"SMAP\nPythonAICodeSnippetRunnerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PythonAICodeSnippetRunnerProvider.kt\ncom/intellij/ml/llm/python/snippetRunner/PythonAICodeSnippetRunnerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,63:1\n827#2:64\n855#2,2:65\n1255#3,2:67\n1232#3,2:69\n*S KotlinDebug\n*F\n+ 1 PythonAICodeSnippetRunnerProvider.kt\ncom/intellij/ml/llm/python/snippetRunner/PythonAICodeSnippetRunnerProvider\n*L\n39#1:64\n39#1:65,2\n48#1:67,2\n51#1:69,2\n*E\n"})
public final class PythonAICodeSnippetRunnerProvider
implements LLMCustomCodeSnippetRunnerProvider {
    public boolean canRun(@Nullable String languageId, @NotNull Editor editor2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        String string2 = languageId;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        if (!Intrinsics.areEqual((Object)string, (Object)"py")) {
            String string4;
            String string5 = languageId;
            if (string5 != null) {
                String string6 = string5.toLowerCase(Locale.ROOT);
                string4 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"toLowerCase(...)");
            } else {
                string4 = null;
            }
            if (!Intrinsics.areEqual((Object)string4, (Object)"python")) {
                return false;
            }
        }
        Project project2 = editor2.getProject();
        if (this.hasIPython(editor2.getProject(), (Sdk)(project2 != null ? PySdkExtKt.getPythonSdk((Project)project2) : null))) {
            return true;
        }
        Object object = ReadAction.compute(() -> PythonAICodeSnippetRunnerProvider.canRun$lambda$0(editor2));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        String text2 = (String)object;
        if (!this.hasBangs(text2)) {
            return true;
        }
        return this.allBangs(text2) && !LLMShRunnerProvider.Companion.getEP_NAME().getExtensionList().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object runScript(@NotNull Project project2, @NotNull Editor editor2, @NotNull String textToRun, @NotNull Continuation<? super Unit> $completion) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        if (!this.hasBangs(textToRun) || this.hasIPython(project2, PySdkExtKt.getPythonSdk((Project)project2))) {
            PyExecuteInConsole.executeCodeInConsole((Project)project2, (String)textToRun, (Editor)editor2, (boolean)true, (boolean)true, (boolean)true, null);
            return Unit.INSTANCE;
        }
        Iterable iterable = StringsKt.lines((CharSequence)textToRun);
        boolean $i$f$filterNot = false;
        void var8_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (this.isBlankOrComment(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        String shellCommand = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, PythonAICodeSnippetRunnerProvider::runScript$lambda$1, (int)30, null);
        Object object = LLMShRunnerProvider.Companion.runSnippet(project2, shellCommand, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final boolean isShellLineComment(String $this$isShellLineComment) {
        return StringsKt.startsWith$default((String)$this$isShellLineComment, (String)"#", (boolean)false, (int)2, null);
    }

    private final boolean isBlankOrComment(String $this$isBlankOrComment) {
        return this.isShellLineComment($this$isBlankOrComment) || StringsKt.isBlank((CharSequence)$this$isBlankOrComment);
    }

    private final boolean hasBangs(String $this$hasBangs) {
        boolean bl;
        block1: {
            Sequence $this$any$iv = StringsKt.lineSequence((CharSequence)$this$hasBangs);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (!StringsKt.startsWith$default((CharSequence)it, (char)'!', (boolean)false, (int)2, null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean allBangs(String $this$allBangs) {
        boolean bl;
        block1: {
            Sequence $this$all$iv = StringsKt.lineSequence((CharSequence)$this$allBangs);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                if (StringsKt.startsWith$default((String)it, (String)"!", (boolean)false, (int)2, null) || this.isBlankOrComment(it)) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean hasIPython(Project project2, Sdk pythonSdk) {
        if (project2 == null || pythonSdk == null) {
            return false;
        }
        try {
            PythonPackageManager manager = PythonPackageManager.Companion.forSdk(project2, pythonSdk);
            return PythonPackageManagerExt.hasInstalledPackageSnapshot$default((PythonPackageManager)manager, (String)"ipython", null, (int)2, null);
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static final String canRun$lambda$0(Editor $editor) {
        return AIAssistantChatActionsUtil.INSTANCE.getTextToPaste($editor);
    }

    private static final CharSequence runScript$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        char[] cArray = new char[]{'!'};
        return StringsKt.trimStart((String)it, (char[])cArray);
    }
}

